/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.PersistentObject;
import cern.colt.list.tdouble.AbstractDoubleList;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class DoubleFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DoubleFactory1D dense = new DoubleFactory1D();
    public static final DoubleFactory1D sparse = new DoubleFactory1D();

    protected DoubleFactory1D() {
    }

    public DoubleMatrix1D append(DoubleMatrix1D A, DoubleMatrix1D B) {
        DoubleMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public DoubleMatrix1D ascending(int size) {
        return this.descending(size).assign(DoubleFunctions.chain(DoubleFunctions.neg, DoubleFunctions.minus(size)));
    }

    public DoubleMatrix1D descending(int size) {
        DoubleMatrix1D matrix = this.make(size);
        int v = 0;
        int i = size;
        while (--i >= 0) {
            matrix.setQuick(i, v++);
        }
        return matrix;
    }

    public DoubleMatrix1D make(AbstractDoubleList values) {
        int size = values.size();
        DoubleMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public DoubleMatrix1D make(double[] values) {
        if (this == sparse) {
            return new SparseDoubleMatrix1D(values);
        }
        return new DenseDoubleMatrix1D(values);
    }

    public DoubleMatrix1D make(DoubleMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size = (int)((long)size + parts[i].size());
        }
        DoubleMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, (int)parts[i].size()).assign(parts[i]);
            size = (int)((long)size + parts[i].size());
        }
        return vector;
    }

    public DoubleMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseDoubleMatrix1D(size);
        }
        return new DenseDoubleMatrix1D(size);
    }

    public DoubleMatrix1D make(int size, double initialValue) {
        return this.make(size).assign(initialValue);
    }

    public DoubleMatrix1D random(int size) {
        return this.make(size).assign(DoubleFunctions.random());
    }

    public DoubleMatrix1D repeat(DoubleMatrix1D A, int repeat) {
        int size = (int)A.size();
        DoubleMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public DoubleMatrix1D sample(int size, double value, double nonZeroFraction) {
        double epsilon = 1.0E-9;
        if (nonZeroFraction < 0.0 - epsilon || nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0) {
            nonZeroFraction = 0.0;
        }
        if (nonZeroFraction > 1.0) {
            nonZeroFraction = 1.0;
        }
        DoubleMatrix1D matrix = this.make(size);
        int n = (int)Math.round((double)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        int i = size;
        while (--i >= 0) {
            if (!sampler.sampleNextElement()) continue;
            matrix.setQuick(i, value);
        }
        return matrix;
    }

    public DoubleArrayList toList(DoubleMatrix1D values) {
        int size = (int)values.size();
        DoubleArrayList list = new DoubleArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.setQuick(i, values.get(i));
        }
        return list;
    }
}

