/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.ufl.cise.btf.tdouble.Dbtf_maxtrans;
import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_analyze;
import edu.ufl.cise.klu.tdouble.Dklu_defaults;
import edu.ufl.cise.klu.tdouble.Dklu_extract;
import edu.ufl.cise.klu.tdouble.Dklu_factor;
import edu.ufl.cise.klu.tdouble.Dklu_solve;

public class SparseDoubleKLUDecomposition
implements SparseDoubleLUDecomposition {
    private KLU_symbolic S;
    private KLU_numeric N;
    private KLU_common Common;
    private DoubleMatrix2D L;
    private DoubleMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public SparseDoubleKLUDecomposition(DoubleMatrix2D A, int order, boolean checkIfSingular, boolean preOrder) {
        int sprank;
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSquare(A);
        DoubleProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.Common = new KLU_common();
        Dklu_defaults.klu_defaults((KLU_common)this.Common);
        this.Common.ordering = order;
        int n = this.Common.btf = preOrder ? 1 : 0;
        if (A instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDoubleMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (Dcs_common.Dcs)A.elements();
        }
        this.n = A.rows();
        int[] Ap = dcs.p;
        int[] Ai = dcs.i;
        double[] Ax = dcs.x;
        this.S = Dklu_analyze.klu_analyze((int)this.n, (int[])Ap, (int[])Ai, (KLU_common)this.Common);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in klu_analyze()");
        }
        this.N = Dklu_factor.klu_factor((int[])Ap, (int[])Ai, (double[])Ax, (KLU_symbolic)this.S, (KLU_common)this.Common);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in klu_factor()");
        }
        if (checkIfSingular && (sprank = Dbtf_maxtrans.btf_maxtrans((int)this.n, (int)this.n, (int[])Ap, (int[])Ai, (double)this.Common.maxwork, (double[])new double[1], (int[])new int[this.n])) < this.n) {
            this.isNonSingular = false;
        }
    }

    public SparseDoubleKLUDecomposition(DoubleMatrix2D A, int order, boolean checkIfSingular) {
        this(A, order, checkIfSingular, true);
    }

    public double det() {
        if (!this.isNonsingular()) {
            return 0.0;
        }
        int pivsign = 1;
        for (int i = 0; i < this.n; ++i) {
            if (this.N.Pinv[i] == i) continue;
            pivsign = -pivsign;
        }
        if (this.U == null) {
            this.U = this.getU();
        }
        double det = pivsign;
        for (int j = 0; j < this.n; ++j) {
            det *= this.U.getQuick(j, j);
        }
        return det;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            int[] Lp = new int[this.N.lnz + 1];
            int[] Li = new int[this.N.lnz];
            double[] Lx = new double[this.N.lnz];
            Dklu_extract.klu_extract((KLU_numeric)this.N, (KLU_symbolic)this.S, (int[])Lp, (int[])Li, (double[])Lx, null, null, null, null, null, null, null, null, null, null, (KLU_common)this.Common);
            this.L = new SparseCCDoubleMatrix2D(this.n, this.n, Li, Lp, Lx);
            if (this.rcMatrix) {
                this.L = ((SparseCCDoubleMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.Pinv == null) {
            return null;
        }
        int[] pinv = new int[this.N.Pinv.length];
        System.arraycopy(this.N.Pinv, 0, pinv, 0, pinv.length);
        return pinv;
    }

    public DoubleMatrix2D getU() {
        if (this.U == null) {
            int[] Up = new int[this.N.unz + 1];
            int[] Ui = new int[this.N.unz];
            double[] Ux = new double[this.N.unz];
            Dklu_extract.klu_extract((KLU_numeric)this.N, (KLU_symbolic)this.S, null, null, null, (int[])Up, (int[])Ui, (double[])Ux, null, null, null, null, null, null, null, (KLU_common)this.Common);
            this.U = new SparseCCDoubleMatrix2D(this.n, this.n, Ui, Up, Ux);
            if (this.rcMatrix) {
                this.U = ((SparseCCDoubleMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public KLU_symbolic getSymbolicAnalysis() {
        KLU_symbolic S2 = new KLU_symbolic();
        S2.symmetry = this.S.symmetry;
        S2.est_flops = this.S.est_flops;
        S2.lnz = this.S.lnz;
        S2.unz = this.S.unz;
        S2.Lnz = (double[])this.S.Lnz.clone();
        S2.n = this.S.n;
        S2.nz = this.S.nz;
        S2.nzoff = this.S.nzoff;
        S2.nblocks = this.S.nblocks;
        S2.maxblock = this.S.maxblock;
        S2.ordering = this.S.ordering;
        S2.do_btf = this.S.do_btf;
        S2.P = (int[])this.S.P.clone();
        S2.Q = (int[])this.S.Q.clone();
        S2.R = (int[])this.S.R.clone();
        S2.structural_rank = this.S.structural_rank;
        return S2;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(DoubleMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        DoubleProperty.DEFAULT.checkDense(b);
        double[] x = b.isView() ? (double[])b.copy().elements() : (double[])b.elements();
        Dklu_solve.klu_solve((KLU_symbolic)this.S, (KLU_numeric)this.N, (int)this.n, (int)1, (double[])x, (int)0, (KLU_common)this.Common);
        if (b.isView()) {
            b.assign(x);
        }
    }
}

