/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.MRNSDDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleMRNSD
extends AbstractDoubleIterativeSolver {
    private static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    public static final double sqrteps = Math.sqrt(Math.pow(2.0, -52.0));

    public DoubleMRNSD() {
        this.iter = new MRNSDDoubleIterationMonitor();
        ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        double rnrm;
        double gamma;
        double tau;
        if (!(this.iter instanceof MRNSDDoubleIterationMonitor)) {
            this.iter = new MRNSDDoubleIterationMonitor();
            ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
        }
        double sigsq = tau = sqrteps;
        double[] minAndLoc = x.getMinLocation();
        double minX = minAndLoc[0];
        if (minX < 0.0) {
            x.assign(DoubleFunctions.plus(-minX + sigsq));
        }
        if (((MRNSDDoubleIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(A.zMult(b, null, 1.0, 0.0, true)));
        }
        DoubleMatrix1D r = A.zMult(x, null);
        r.assign(b, DoubleFunctions.plusMultFirst(-1.0));
        if (!(this.M instanceof DoubleIdentity)) {
            r = this.M.apply(r, null);
            r = this.M.transApply(r, null);
            r = A.zMult(r, null, 1.0, 0.0, true);
            r.assign(DoubleFunctions.neg);
            gamma = x.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
            rnrm = alg.norm2(r);
        } else {
            r = A.zMult(r, null, 1.0, 0.0, true);
            r.assign(DoubleFunctions.neg);
            gamma = x.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
            rnrm = Math.sqrt(gamma);
        }
        IntArrayList indexList = new IntArrayList((int)b.size());
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            DoubleMatrix1D s = x.copy();
            s.assign(r, DoubleFunctions.multNeg);
            DoubleMatrix1D u = A.zMult(s, null);
            if (!(this.M instanceof DoubleIdentity)) {
                u = this.M.apply(u, null);
            }
            double theta = gamma / u.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            s.getNegativeValues(indexList, null);
            DoubleMatrix1D w = x.copy();
            w.assign(s, DoubleFunctions.divNeg, indexList);
            double alpha = Math.min(theta, w.aggregate(DoubleFunctions.min, DoubleFunctions.identity, indexList));
            x.assign(s, DoubleFunctions.plusMultSecond(alpha));
            if (!(this.M instanceof DoubleIdentity)) {
                w = this.M.transApply(u, null);
                w = A.zMult(w, null, 1.0, 0.0, true);
                r.assign(w, DoubleFunctions.plusMultSecond(alpha));
                gamma = x.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
                rnrm = alg.norm2(r);
            } else {
                w = A.zMult(u, null, 1.0, 0.0, true);
                r.assign(w, DoubleFunctions.plusMultSecond(alpha));
                gamma = x.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
                rnrm = Math.sqrt(gamma);
            }
            this.iter.next();
        }
        return x;
    }
}

