/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;

    public SparseFComplexMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseFComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new ConcurrentHashMap(rows * (columns / 1000));
    }

    protected SparseFComplexMatrix2D(int rows, int columns, ConcurrentHashMap<Long, float[]> elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix2D assign(float[] value) {
        if (this.isNoView && value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D source) {
        if (!(source instanceof SparseFComplexMatrix2D)) {
            return super.assign(source);
        }
        SparseFComplexMatrix2D other = (SparseFComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.clear();
            this.elements.putAll(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D y, FComplexFComplexFComplexFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof FComplexPlusMultSecond) {
            final float[] alpha = ((FComplexPlusMultSecond)function).multiplicator;
            if (alpha[0] == 0.0f && alpha[1] == 1.0f) {
                return this;
            }
            y.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int i, int j, float[] value) {
                    SparseFComplexMatrix2D.this.setQuick(i, j, FComplex.plus(SparseFComplexMatrix2D.this.getQuick(i, j), FComplex.mult(alpha, value)));
                    return value;
                }
            });
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public float[] getQuick(int row, int column) {
        float[] elem = this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
        if (elem != null) {
            return new float[]{elem[0], elem[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Long, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D other) {
        if (other instanceof SelectedSparseFComplexMatrix2D) {
            SelectedSparseFComplexMatrix2D otherMatrix = (SelectedSparseFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFComplexMatrix2D) {
            SparseFComplexMatrix2D otherMatrix = (SparseFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new SparseFComplexMatrix1D(size);
    }

    @Override
    protected FComplexMatrix1D like1D(int size, int offset, int stride) {
        return new SparseFComplexMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public FComplexMatrix1D vectorize() {
        final SparseFComplexMatrix1D v = new SparseFComplexMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = 0;
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            idx = c * SparseFComplexMatrix2D.this.rows;
                            for (int r = 0; r < SparseFComplexMatrix2D.this.rows; ++r) {
                                float[] elem = SparseFComplexMatrix2D.this.getQuick(r, c);
                                if (elem[0] == 0.0f && elem[1] == 0.0f) continue;
                                v.setQuick(idx++, elem);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int c = 0; c < this.columns; ++c) {
                for (int r = 0; r < this.rows; ++r) {
                    float[] elem = this.getQuick(r, c);
                    if (elem[0] == 0.0f && elem[1] == 0.0f) continue;
                    v.setQuick(idx++, elem);
                }
            }
        }
        return v;
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (re == 0.0f && im == 0.0f) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, new float[]{re, im});
        }
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseFComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        final SparseFloatMatrix2D Im = new SparseFloatMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < SparseFComplexMatrix2D.this.columns; ++c) {
                                Im.setQuick(r, c, SparseFComplexMatrix2D.this.getQuick(r, c)[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    ((FloatMatrix2D)Im).setQuick(r, c, this.getQuick(r, c)[1]);
                }
            }
        }
        return Im;
    }

    @Override
    public FloatMatrix2D getRealPart() {
        final SparseFloatMatrix2D Re = new SparseFloatMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < SparseFComplexMatrix2D.this.columns; ++c) {
                                Re.setQuick(r, c, SparseFComplexMatrix2D.this.getQuick(r, c)[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    ((FloatMatrix2D)Re).setQuick(r, c, this.getQuick(r, c)[0]);
                }
            }
        }
        return Re;
    }
}

