/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class DenseFloatQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D QR;
    private int m;
    private int n;
    private FloatMatrix1D Rdiag;

    public DenseFloatQRDecomposition(FloatMatrix2D A) {
        int k;
        FloatProperty.DEFAULT.checkRectangular(A);
        FloatFunctions F = FloatFunctions.functions;
        this.QR = A.copy();
        this.m = A.rows();
        this.n = A.columns();
        this.Rdiag = A.like1D(this.n);
        FloatFloatFunction hypot = DenseFloatAlgebra.hypotFunction();
        FloatMatrix1D[] QRcolumns = new FloatMatrix1D[this.n];
        FloatMatrix1D[] QRcolumnsPart = new FloatMatrix1D[this.n];
        for (k = 0; k < this.n; ++k) {
            QRcolumns[k] = this.QR.viewColumn(k);
            QRcolumnsPart[k] = this.QR.viewColumn(k).viewPart(k, this.m - k);
        }
        for (k = 0; k < this.n; ++k) {
            float nrm = 0.0f;
            for (int i = k; i < this.m; ++i) {
                nrm = DenseFloatAlgebra.hypot(nrm, this.QR.getQuick(i, k));
            }
            if ((double)nrm != 0.0) {
                if (this.QR.getQuick(k, k) < 0.0f) {
                    nrm = -nrm;
                }
                QRcolumnsPart[k].assign(FloatFunctions.div(nrm));
                this.QR.setQuick(k, k, this.QR.getQuick(k, k) + 1.0f);
                for (int j = k + 1; j < this.n; ++j) {
                    FloatMatrix1D QRcolj = this.QR.viewColumn(j).viewPart(k, this.m - k);
                    float s = QRcolumnsPart[k].zDotProduct(QRcolj);
                    s = -s / this.QR.getQuick(k, k);
                    for (int i = k; i < this.m; ++i) {
                        this.QR.setQuick(i, j, this.QR.getQuick(i, j) + s * this.QR.getQuick(i, k));
                    }
                }
            }
            this.Rdiag.setQuick(k, -nrm);
        }
    }

    public FloatMatrix2D getH() {
        return DenseFloatAlgebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public FloatMatrix2D getQ() {
        FloatFunctions F = FloatFunctions.functions;
        FloatMatrix2D Q = this.QR.like();
        for (int k = this.n - 1; k >= 0; --k) {
            FloatMatrix1D QRcolk = this.QR.viewColumn(k).viewPart(k, this.m - k);
            Q.setQuick(k, k, 1.0f);
            for (int j = k; j < this.n; ++j) {
                if (this.QR.getQuick(k, k) == 0.0f) continue;
                FloatMatrix1D Qcolj = Q.viewColumn(j).viewPart(k, this.m - k);
                float s = QRcolk.zDotProduct(Qcolj);
                s = -s / this.QR.getQuick(k, k);
                Qcolj.assign(QRcolk, FloatFunctions.plusMultSecond(s));
            }
        }
        return Q;
    }

    public FloatMatrix2D getR() {
        FloatMatrix2D R = this.QR.like(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i < j) {
                    R.setQuick(i, j, this.QR.getQuick(i, j));
                    continue;
                }
                if (i == j) {
                    R.setQuick(i, j, this.Rdiag.getQuick(i));
                    continue;
                }
                R.setQuick(i, j, 0.0f);
            }
        }
        return R;
    }

    public boolean hasFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag.getQuick(j) != 0.0f) continue;
            return false;
        }
        return true;
    }

    public FloatMatrix1D solve(FloatMatrix1D b) {
        int k;
        FloatFunctions F = FloatFunctions.functions;
        if (b.size() != (long)this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        FloatMatrix1D x = b.copy();
        for (k = 0; k < this.n; ++k) {
            int i;
            float s = 0.0f;
            for (i = k; i < this.m; ++i) {
                s += this.QR.getQuick(i, k) * x.getQuick(i);
            }
            s = -s / this.QR.getQuick(k, k);
            for (i = k; i < this.m; ++i) {
                x.setQuick(i, x.getQuick(i) + s * this.QR.getQuick(i, k));
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            x.setQuick(k, x.getQuick(k) / this.Rdiag.getQuick(k));
            for (int i = 0; i < k; ++i) {
                x.setQuick(i, x.getQuick(i) - x.getQuick(k) * this.QR.getQuick(i, k));
            }
        }
        return x.viewPart(0, this.n).copy();
    }

    public FloatMatrix2D solve(FloatMatrix2D B) {
        int j;
        int k;
        FloatFunctions F = FloatFunctions.functions;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int nx = B.columns();
        FloatMatrix2D X = B.copy();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                float s = 0.0f;
                for (i = k; i < this.m; ++i) {
                    s += this.QR.getQuick(i, k) * X.getQuick(i, j);
                }
                s = -s / this.QR.getQuick(k, k);
                for (i = k; i < this.m; ++i) {
                    X.setQuick(i, j, X.getQuick(i, j) + s * this.QR.getQuick(i, k));
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                X.setQuick(k, j, X.getQuick(k, j) / this.Rdiag.getQuick(k));
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    X.setQuick(i, j2, X.getQuick(i, j2) - X.getQuick(k, j2) * this.QR.getQuick(i, k));
                }
            }
        }
        return X.viewPart(0, 0, this.n, nx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------\n");
        buf.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        buf.append("-----------------------------------------------------------------\n");
        buf.append("hasFullRank = ");
        try {
            buf.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nH = ");
        try {
            buf.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nQ = ");
        try {
            buf.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nR = ");
        try {
            buf.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\npseudo inverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }
}

