/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.algo.IntMatrix1DComparator;
import cern.colt.matrix.tint.algo.IntMatrix2DComparator;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;

public class IntSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntSorting quickSort = new IntSorting();
    public static final IntSorting mergeSort = new IntSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected IntSorting() {
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.parallelQuickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public IntMatrix1D sort(IntMatrix1D vector) {
        return vector.viewSelection(this.sortIndex(vector));
    }

    public int[] sortIndex(final IntMatrix1D vector) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseIntMatrix1D) {
            final int[] velems = (int[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int av = velems[idxa];
                    int idxb = zero + b * stride;
                    int bv = velems[idxb];
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int bv;
                    int av = vector.getQuick(a);
                    return av < (bv = vector.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public IntMatrix1D sort(IntMatrix1D vector, IntComparator c) {
        return vector.viewSelection(this.sortIndex(vector, c));
    }

    public int[] sortIndex(final IntMatrix1D vector, final IntComparator c) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseIntMatrix1D) {
            final int[] velems = (int[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    return c.compare(velems[idxa], velems[idxb]);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    return c.compare(vector.getQuick(a), vector.getQuick(b));
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public IntMatrix2D sort(IntMatrix2D matrix, final int[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int x, int y) {
                int a = aggregates[x];
                int b = aggregates[y];
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                int t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public IntMatrix2D sort(IntMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final IntMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int bv;
                int av = col.getQuick(a);
                return av < (bv = col.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public IntMatrix2D sort(IntMatrix2D matrix, final IntMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final IntMatrix1D[] views = new IntMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public IntMatrix3D sort(IntMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final IntMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int bv;
                int av = sliceView.getQuick(a);
                return av < (bv = sliceView.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public IntMatrix3D sort(IntMatrix3D matrix, final IntMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final IntMatrix2D[] views = new IntMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }
}

