/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedDenseColumnLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnLongMatrix2D
extends LongMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected long[] elements;

    public DenseColumnLongMatrix2D(long[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseColumnLongMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 1, rows);
        this.elements = new long[rows * columns];
    }

    public DenseColumnLongMatrix2D(int rows, int columns, long[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseColumnLongMatrix2D(MatrixVectorReader reader) throws IOException {
        block7: {
            int i;
            long[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block6: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new long[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new long[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                for (i = 0; i < numEntries; ++i) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                }
                if (!info.isSymmetric()) break block6;
                for (i = 0; i < numEntries; ++i) {
                    if (rowIndexes[i] == columnIndexes[i]) continue;
                    this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                }
                break block7;
            }
            if (!info.isSkewSymmetric()) break block7;
            for (i = 0; i < numEntries; ++i) {
                if (rowIndexes[i] == columnIndexes[i]) continue;
                this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
            }
        }
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseColumnLongMatrix2D.this.elements[zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnLongMatrix2D.this.columnStride;
                            int r = DenseColumnLongMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnLongMatrix2D.this.elements[r * DenseColumnLongMatrix2D.this.rowStride + cidx]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx]));
                }
                d = 0;
            }
        }
        return a;
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f, final LongProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long elem = DenseColumnLongMatrix2D.this.elements[zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        long a = 0L;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnLongMatrix2D.this.columnStride;
                            int r = DenseColumnLongMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                elem = DenseColumnLongMatrix2D.this.elements[r * DenseColumnLongMatrix2D.this.rowStride + cidx];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            long elem = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (cond.apply(elem)) {
                a = f.apply(elem);
            }
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    elem = this.elements[r * this.rowStride + cidx];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseColumnLongMatrix2D.this.elements[zero + rowElements[firstIdx - 1] * DenseColumnLongMatrix2D.this.rowStride + columnElements[firstIdx - 1] * DenseColumnLongMatrix2D.this.columnStride]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseColumnLongMatrix2D.this.elements[zero + rowElements[i] * DenseColumnLongMatrix2D.this.rowStride + columnElements[i] * DenseColumnLongMatrix2D.this.columnStride]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[size - 1] * this.rowStride + columnElements[size - 1] * this.columnStride]);
            int i = size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride]));
            }
        }
        return a;
    }

    public long aggregate(LongMatrix2D other, final LongLongFunction aggr, final LongLongFunction f) {
        if (!(other instanceof DenseColumnLongMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final long[] otherElements = (long[])other.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseColumnLongMatrix2D.this.elements[zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride], otherElements[zeroOther + (DenseColumnLongMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnLongMatrix2D.this.columnStride;
                            int cidxOther = zeroOther + c * columnStrideOther;
                            int r = DenseColumnLongMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnLongMatrix2D.this.elements[r * DenseColumnLongMatrix2D.this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], otherElements[zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther]);
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int cidxOther = zeroOther + c * columnStrideOther;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    public LongMatrix2D assign(final LongFunction function) {
        if (function instanceof LongMult) {
            long multiplicator = ((LongMult)function).multiplicator;
            if (multiplicator == 1L) {
                return this;
            }
            if (multiplicator == 0L) {
                return this.assign(0L);
            }
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        if (function instanceof LongMult) {
                            long multiplicator = ((LongMult)function).multiplicator;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] * multiplicator;
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[i] = function.apply(DenseColumnLongMatrix2D.this.elements[i]);
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof LongMult) {
                long multiplicator = ((LongMult)function).multiplicator;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * multiplicator;
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i]);
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure cond, final LongFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                long elem = DenseColumnLongMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnLongMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    long elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure cond, final long value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                long elem = DenseColumnLongMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnLongMatrix2D.this.elements[i] = value;
                                }
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    long elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnLongMatrix2D.this.elements[i] = value;
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = value;
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                            int idxOther = DenseColumnLongMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnLongMatrix2D.this.rows;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[i] = values[idxOther--];
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = values.length - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = values[idxOther--];
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "columns()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseColumnLongMatrix2D.this.rowStride + (DenseColumnLongMatrix2D.this.columns - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            long[] currentRow = values[r];
                            if (currentRow.length != DenseColumnLongMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + DenseColumnLongMatrix2D.this.columns());
                            }
                            int i = idx;
                            int c = DenseColumnLongMatrix2D.this.columns;
                            while (--c >= 0) {
                                DenseColumnLongMatrix2D.this.elements[i] = currentRow[c];
                                i -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int r = this.rows;
            while (--r >= 0) {
                long[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + this.columns());
                }
                int i = idx;
                int c = this.columns;
                while (--c >= 0) {
                    this.elements[i] = currentRow[c];
                    i -= this.columnStride;
                }
                idx -= this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D source) {
        if (!(source instanceof DenseColumnLongMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnLongMatrix2D other = (DenseColumnLongMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            LongMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnLongMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnLongMatrix2D)c;
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final long[] otherElements = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnLongMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnLongMatrix2D.this.elements[i] = otherElements[j];
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = otherElements[j];
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D y, final LongLongFunction function) {
        long multiplicator;
        if (function instanceof LongPlusMultSecond && (multiplicator = ((LongPlusMultSecond)function).multiplicator) == 0L) {
            return this;
        }
        if (function instanceof LongPlusMultFirst && (multiplicator = ((LongPlusMultFirst)function).multiplicator) == 0L) {
            return this.assign(y);
        }
        if (!(y instanceof DenseColumnLongMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnLongMatrix2D other = (DenseColumnLongMatrix2D)y;
        this.checkShape(y);
        final long[] otherElements = other.elements;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnLongMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        if (function == LongFunctions.mult) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] * otherElements[j];
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function == LongFunctions.div) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] / otherElements[j];
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function instanceof LongPlusMultSecond) {
                            long multiplicator = ((LongPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1L) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1L) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] - otherElements[j];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] + multiplicator * otherElements[j];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else if (function instanceof LongPlusMultFirst) {
                            long multiplicator = ((LongPlusMultFirst)function).multiplicator;
                            if (multiplicator == 1L) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnLongMatrix2D.this.elements[n] = DenseColumnLongMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1L) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnLongMatrix2D.this.elements[i] = otherElements[j] - DenseColumnLongMatrix2D.this.elements[i];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnLongMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnLongMatrix2D.this.elements[i] = multiplicator * DenseColumnLongMatrix2D.this.elements[i] + otherElements[j];
                                        i -= DenseColumnLongMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnLongMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[i] = function.apply(DenseColumnLongMatrix2D.this.elements[i], otherElements[j]);
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            if (function == LongFunctions.mult) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function == LongFunctions.div) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] / otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function instanceof LongPlusMultSecond) {
                long multiplicator2 = ((LongPlusMultSecond)function).multiplicator;
                if (multiplicator2 == 1L) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator2 == -1L) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] - otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + multiplicator2 * otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else if (function instanceof LongPlusMultFirst) {
                long multiplicator3 = ((LongPlusMultFirst)function).multiplicator;
                if (multiplicator3 == 1L) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator3 == -1L) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = otherElements[j] - this.elements[i];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = multiplicator3 * this.elements[i] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i], otherElements[j]);
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D y, final LongLongFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        if (!(y instanceof DenseColumnLongMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnLongMatrix2D other = (DenseColumnLongMatrix2D)y;
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final long[] otherElements = other.elements();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            int idx = zero + rowElements[i] * DenseColumnLongMatrix2D.this.rowStride + columnElements[i] * DenseColumnLongMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseColumnLongMatrix2D.this.elements[idx] = function.apply(DenseColumnLongMatrix2D.this.elements[idx], otherElements[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = size;
            while (--i >= 0) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], otherElements[idxOther]);
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                if (DenseColumnLongMatrix2D.this.elements[i] != 0L) {
                                    ++cardinality;
                                }
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    if (this.elements[i] != 0L) {
                        ++cardinality;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                long value = DenseColumnLongMatrix2D.this.elements[i];
                                if (value != 0L) {
                                    DenseColumnLongMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    long value = this.elements[i];
                    if (value != 0L) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public DenseLongMatrix2D getRowMajor() {
        DenseLongMatrix2D R = new DenseLongMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final long[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int idxR = zeroR + (DenseColumnLongMatrix2D.this.rows - 1) * rowStrideR + (firstColumn - 1) * columnStrideR;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxR;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsR[j] = DenseColumnLongMatrix2D.this.elements[i];
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                                j -= rowStrideR;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                            idxR -= columnStrideR;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxR = zeroR + (this.rows - 1) * rowStrideR + (this.columns - 1) * columnStrideR;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxR;
                int r = this.rows;
                while (--r >= 0) {
                    elementsR[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideR;
                }
                idx -= this.columnStride;
                idxR -= columnStrideR;
            }
        }
        return R;
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                long value = this.elements[i];
                if (value < 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                long value = this.elements[i];
                if (value != 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                long value = this.elements[i];
                if (value > 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    public long getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public LongMatrix2D like(int rows, int columns) {
        return new DenseColumnLongMatrix2D(rows, columns);
    }

    public LongMatrix1D like1D(int size) {
        return new DenseLongMatrix1D(size);
    }

    public long[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][3];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long maxValue = DenseColumnLongMatrix2D.this.elements[zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnLongMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnLongMatrix2D.this.columnStride;
                            int r = DenseColumnLongMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                long elem = DenseColumnLongMatrix2D.this.elements[r * DenseColumnLongMatrix2D.this.rowStride + cidx];
                                if (maxValue >= elem) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new long[]{maxValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    long elem = this.elements[r * this.rowStride + cidx];
                    if (maxValue >= elem) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new long[]{maxValue, rowLocation, columnLocation};
    }

    public long[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][3];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long minValue = DenseColumnLongMatrix2D.this.elements[zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnLongMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnLongMatrix2D.this.columnStride;
                            int r = DenseColumnLongMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                long elem = DenseColumnLongMatrix2D.this.elements[r * DenseColumnLongMatrix2D.this.rowStride + cidx];
                                if (minValue <= elem) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new long[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    long elem = this.elements[r * this.rowStride + cidx];
                    if (minValue <= elem) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new long[]{minValue, rowLocation, columnLocation};
    }

    public void setQuick(int row, int column, long value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    public long[][] toArray() {
        final long[][] values = new long[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                values[r][c] = DenseColumnLongMatrix2D.this.elements[i];
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    values[r][c] = this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return values;
    }

    public LongMatrix1D vectorize() {
        int size = (int)this.size();
        DenseLongMatrix1D v = new DenseLongMatrix1D(size);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((LongMatrix1D)v).elements(), 0, size);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final long[] elementsOther = (long[])((LongMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    final int firstIdxOther = size - j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                            int idxOther = zeroOther + (firstIdxOther - 1) * strideOther;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnLongMatrix2D.this.rows;
                                while (--r >= 0) {
                                    elementsOther[idxOther] = DenseColumnLongMatrix2D.this.elements[i];
                                    i -= DenseColumnLongMatrix2D.this.rowStride;
                                    idxOther -= strideOther;
                                }
                                idx -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = zeroOther + size - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        elementsOther[idxOther] = this.elements[i];
                        i -= this.rowStride;
                        --idxOther;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return v;
    }

    public long zSum() {
        long sum = 0L;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long sum = 0L;
                        int idx = zero + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnLongMatrix2D.this.rows;
                            while (--r >= 0) {
                                sum += DenseColumnLongMatrix2D.this.elements[i];
                                i -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    sum += ((Long)futures[j].get()).longValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    sum += this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return sum;
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        if (other instanceof SelectedDenseColumnLongMatrix2D) {
            SelectedDenseColumnLongMatrix2D otherMatrix = (SelectedDenseColumnLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnLongMatrix2D) {
            DenseColumnLongMatrix2D otherMatrix = (DenseColumnLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int size, int zero, int stride) {
        return new DenseLongMatrix1D(size, this.elements, zero, stride, true);
    }

    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnLongMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

