/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;

class SelectedDenseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseLongMatrix1D(long[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseLongMatrix1D(int size, long[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public long[] elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public long getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    public LongMatrix1D like(int size) {
        return new DenseLongMatrix1D(size);
    }

    public LongMatrix2D like2D(int rows, int columns) {
        return new DenseLongMatrix2D(rows, columns);
    }

    public LongMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public LongMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int index, long value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D other) {
        if (other instanceof SelectedDenseLongMatrix1D) {
            SelectedDenseLongMatrix1D otherMatrix = (SelectedDenseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseLongMatrix1D) {
            DenseLongMatrix1D otherMatrix = (DenseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected LongMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseLongMatrix1D(this.elements, offsets);
    }
}

