/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class DenseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix1D(Object[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseObjectMatrix1D(int size) {
        this.setUp(size);
        this.elements = new Object[size];
    }

    protected DenseObjectMatrix1D(int size, Object[] elements, int zero, int stride, boolean isView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        Object a = f.apply(DenseObjectMatrix1D.this.elements[idx]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DenseObjectMatrix1D.this.elements[idx += DenseObjectMatrix1D.this.stride]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero]);
            int idx = this.zero;
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride]));
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int idx = DenseObjectMatrix1D.this.zero + indexElements[firstIdx] * DenseObjectMatrix1D.this.stride;
                        Object a = f.apply(DenseObjectMatrix1D.this.elements[idx]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            idx = DenseObjectMatrix1D.this.zero + indexElements[i] * DenseObjectMatrix1D.this.stride;
                            Object elem = DenseObjectMatrix1D.this.elements[idx];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + indexElements[0] * this.stride;
            a = f.apply(this.elements[idx]);
            for (int i = 1; i < size; ++i) {
                idx = this.zero + indexElements[i] * this.stride;
                Object elem = this.elements[idx];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public Object aggregate(ObjectMatrix1D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        if (!(other instanceof DenseObjectMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final Object[] elemsOther = (Object[])other.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        Object a = f.apply(DenseObjectMatrix1D.this.elements[idx], elemsOther[idxOther]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DenseObjectMatrix1D.this.elements[idx += DenseObjectMatrix1D.this.stride], elemsOther[idxOther += strideOther]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero], elemsOther[zeroOther]);
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride], elemsOther[idxOther += strideOther]));
            }
        }
        return a;
    }

    public ObjectMatrix1D assign(Object[] values) {
        if (this.isNoView) {
            if (values.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
            }
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            super.assign(values);
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectFunction function) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseObjectMatrix1D.this.elements[idx] = function.apply(DenseObjectMatrix1D.this.elements[idx]);
                            idx += DenseObjectMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int k = 0; k < this.size; ++k) {
                this.elements[idx] = function.apply(this.elements[idx]);
                idx += this.stride;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D source) {
        if (!(source instanceof DenseObjectMatrix1D)) {
            return super.assign(source);
        }
        DenseObjectMatrix1D other = (DenseObjectMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            ObjectMatrix1D c = other.copy();
            if (!(c instanceof DenseObjectMatrix1D)) {
                return super.assign(source);
            }
            other = (DenseObjectMatrix1D)c;
        }
        final Object[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseObjectMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            idx += DenseObjectMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                this.elements[idx] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D y, final ObjectObjectFunction function) {
        if (!(y instanceof DenseObjectMatrix1D)) {
            return super.assign(y, function);
        }
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        final Object[] elemsOther = (Object[])y.elements();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseObjectMatrix1D.this.elements[idx] = function.apply(DenseObjectMatrix1D.this.elements[idx], elemsOther[idxOther]);
                            idx += DenseObjectMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final Object value) {
        final Object[] elems = this.elements;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            elems[idx] = value;
                            idx += DenseObjectMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                elems[idx] = value;
                idx += this.stride;
            }
        }
        return this;
    }

    public Object elements() {
        return this.elements;
    }

    public Object getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D otherMatrix = (SelectedDenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D otherMatrix = (DenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    public ObjectMatrix1D like(int size) {
        return new DenseObjectMatrix1D(size);
    }

    public ObjectMatrix2D like2D(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseObjectMatrix2D M = new DenseObjectMatrix2D(rows, columns);
        final Object[] elemsOther = (Object[])((ObjectMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, columns);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idxOther = zeroOther + c * colStrideOther;
                            int idx = DenseObjectMatrix1D.this.zero + c * rows * DenseObjectMatrix1D.this.stride;
                            for (int r = 0; r < rows; ++r) {
                                elemsOther[idxOther] = DenseObjectMatrix1D.this.elements[idx];
                                idxOther += rowStrideOther;
                                idx += DenseObjectMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int c = 0; c < columns; ++c) {
                int idxOther = zeroOther + c * colStrideOther;
                for (int r = 0; r < rows; ++r) {
                    elemsOther[idxOther] = this.elements[idx];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                }
            }
        }
        return M;
    }

    public ObjectMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseObjectMatrix3D M = new DenseObjectMatrix3D(slices, rows, columns);
        final Object[] elemsOther = (Object[])((ObjectMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < columns; ++c) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                                int idx = DenseObjectMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseObjectMatrix1D.this.stride;
                                for (int r = 0; r < rows; ++r) {
                                    elemsOther[idxOther] = DenseObjectMatrix1D.this.elements[idx];
                                    idxOther += rowStrideOther;
                                    idx += DenseObjectMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int s = 0; s < slices; ++s) {
                for (int c = 0; c < columns; ++c) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                    for (int r = 0; r < rows; ++r) {
                        elemsOther[idxOther] = this.elements[idx];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                    }
                }
            }
        }
        return M;
    }

    public void setQuick(int index, Object value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    public void swap(ObjectMatrix1D other) {
        DenseObjectMatrix1D y;
        if (!(other instanceof DenseObjectMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseObjectMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final Object[] elemsOther = (Object[])y.elements();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseObjectMatrix1D.this.zero + firstIdx * DenseObjectMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            Object tmp = DenseObjectMatrix1D.this.elements[idx];
                            DenseObjectMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            elemsOther[idxOther] = tmp;
                            idx += DenseObjectMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                Object tmp = this.elements[idx];
                this.elements[idx] = elemsOther[idxOther];
                elemsOther[idxOther] = tmp;
                idx += this.stride;
                idxOther += strideOther;
            }
        }
    }

    public void toArray(Object[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseObjectMatrix1D(this.elements, offsets);
    }
}

