/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.buffer.tdouble.DoubleBuffer;
import cern.colt.buffer.tdouble.DoubleBufferConsumer;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.tdouble.DoubleDescriptive;
import hep.aida.tdouble.bin.AbstractDoubleBin;

public abstract class AbstractDoubleBin1D
extends AbstractDoubleBin
implements DoubleBufferConsumer {
    private static final long serialVersionUID = 1L;

    protected AbstractDoubleBin1D() {
    }

    public abstract void add(double var1);

    public final synchronized void addAllOf(DoubleArrayList list) {
        this.addAllOfFromTo(list, 0, list.size() - 1);
    }

    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        for (int i = from; i <= to; ++i) {
            this.add(list.getQuick(i));
        }
    }

    public synchronized DoubleBuffer buffered(int capacity) {
        return new DoubleBuffer(this, capacity);
    }

    public String compareWith(AbstractDoubleBin1D other) {
        StringBuffer buf = new StringBuffer();
        buf.append("\nDifferences [percent]");
        buf.append("\nSize: " + this.relError(this.size(), other.size()) + " %");
        buf.append("\nSum: " + this.relError(this.sum(), other.sum()) + " %");
        buf.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), other.sumOfSquares()) + " %");
        buf.append("\nMin: " + this.relError(this.min(), other.min()) + " %");
        buf.append("\nMax: " + this.relError(this.max(), other.max()) + " %");
        buf.append("\nMean: " + this.relError(this.mean(), other.mean()) + " %");
        buf.append("\nRMS: " + this.relError(this.rms(), other.rms()) + " %");
        buf.append("\nVariance: " + this.relError(this.variance(), other.variance()) + " %");
        buf.append("\nStandard deviation: " + this.relError(this.standardDeviation(), other.standardDeviation()) + " %");
        buf.append("\nStandard error: " + this.relError(this.standardError(), other.standardError()) + " %");
        buf.append("\n");
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractDoubleBin1D)) {
            return false;
        }
        AbstractDoubleBin1D other = (AbstractDoubleBin1D)object;
        return this.size() == other.size() && this.min() == other.min() && this.max() == other.max() && this.sum() == other.sum() && this.sumOfSquares() == other.sumOfSquares();
    }

    public abstract double max();

    public synchronized double mean() {
        return this.sum() / (double)this.size();
    }

    public abstract double min();

    protected double relError(double measure1, double measure2) {
        return 100.0 * (1.0 - measure1 / measure2);
    }

    public synchronized double rms() {
        return DoubleDescriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public synchronized double standardError() {
        return DoubleDescriptive.standardError(this.size(), this.variance());
    }

    public abstract double sum();

    public abstract double sumOfSquares();

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("\n-------------");
        buf.append("\nSize: " + this.size());
        buf.append("\nSum: " + this.sum());
        buf.append("\nSumOfSquares: " + this.sumOfSquares());
        buf.append("\nMin: " + this.min());
        buf.append("\nMax: " + this.max());
        buf.append("\nMean: " + this.mean());
        buf.append("\nRMS: " + this.rms());
        buf.append("\nVariance: " + this.variance());
        buf.append("\nStandard deviation: " + this.standardDeviation());
        buf.append("\nStandard error: " + this.standardError());
        buf.append("\n");
        return buf.toString();
    }

    public synchronized void trimToSize() {
    }

    public synchronized double variance() {
        return DoubleDescriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

