/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import java.util.Locale;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import xlinear.DenseMatrix;
import xlinear.Matrix;
import xlinear.SparseMatrix;
import xlinear.internals.ColtSparseMatrix;
import xlinear.internals.CommonsDenseMatrix;
import xlinear.internals.MatrixVisitorEditInPlace;
import xlinear.internals.MatrixVisitorViewOnly;
import xlinear.internals.TablePrettyPrinter;

public class StaticUtils {
    public static final RuntimeException notAVectorException = new RuntimeException("This operation is only supported on a 1 by n or n by 1 matrix.");
    public static final RuntimeException notAScalarException = new RuntimeException("This operation is only supported on a 1 by 1 matrix.");
    static final RuntimeException denseOrSparseException = new RuntimeException("Either a SparseMatrix or DenseMatrix required.");
    static final RuntimeException notBothSparseAndDense = new RuntimeException("A matrix should not be both a SparseMatrix and a DenseMatrix");

    public static DenseMatrix createDenseMatrixByCopyingArrayContents(double[][] data) {
        BlockRealMatrix _blockRealMatrix = new BlockRealMatrix(data);
        return new CommonsDenseMatrix((RealMatrix)_blockRealMatrix);
    }

    public static SparseMatrix createSparseMatrixByCopyingArrayContents(double[][] data) {
        int nRows = data.length;
        double[] _get = data[0];
        int nCols = _get.length;
        if (nRows < 1) {
            throw new NotStrictlyPositiveException((Number)nRows);
        }
        if (nCols < 1) {
            throw new NotStrictlyPositiveException((Number)nCols);
        }
        SparseMatrix result = StaticUtils.createEmptySparseMatrix(nRows, nCols);
        for (int row = 0; row < nRows; ++row) {
            boolean _notEquals;
            double[] rowArray = data[row];
            int _length = rowArray.length;
            boolean bl = _notEquals = _length != nCols;
            if (_notEquals) {
                double[] _get_1 = data[row];
                int _length_1 = _get_1.length;
                throw new DimensionMismatchException(_length_1, nCols);
            }
            for (int col = 0; col < nCols; ++col) {
                double current = rowArray[col];
                if (current == 0.0) continue;
                result.set(row, col, current);
            }
        }
        return result;
    }

    public static DenseMatrix createDenseMatrixByCopyingArrayContents(double[] data) {
        int _length = data.length;
        DenseMatrix result = StaticUtils.createEmptyDenseMatrix(_length, 1);
        StaticUtils.copyTo(data, result);
        return result;
    }

    public static SparseMatrix createSparseMatrixByCopyingArrayContents(double[] data) {
        int _length = data.length;
        SparseMatrix result = StaticUtils.createEmptySparseMatrix(_length, 1);
        StaticUtils.copyTo(data, result);
        return result;
    }

    private static void copyTo(double[] src, Matrix destination) {
        int _nCols;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _or = false;
        int _length = src.length;
        int _nRows = destination.nRows();
        boolean bl = _notEquals = _length != _nRows;
        _or = _notEquals ? true : (_notEquals_1 = (_nCols = destination.nCols()) != 1);
        if (_or) {
            throw new RuntimeException();
        }
        for (int r = 0; r < src.length; ++r) {
            double _get = src[r];
            destination.set(r, 0, _get);
        }
    }

    public static DenseMatrix createEmptyDenseMatrix(int nRows, int nCols) {
        BlockRealMatrix _blockRealMatrix = new BlockRealMatrix(nRows, nCols);
        return new CommonsDenseMatrix((RealMatrix)_blockRealMatrix);
    }

    public static SparseMatrix createEmptySparseMatrix(int nRows, int nCols) {
        SparseDoubleMatrix2D _sparseDoubleMatrix2D = new SparseDoubleMatrix2D(nRows, nCols);
        return new ColtSparseMatrix((DoubleMatrix2D)_sparseDoubleMatrix2D);
    }

    public static SparseMatrix copy(SparseMatrix model) {
        int _nRows = model.nRows();
        int _nCols = model.nCols();
        SparseMatrix result = model.createEmpty(_nRows, _nCols);
        MatrixVisitorViewOnly _function = (row, col, currentValue) -> result.set(row, col, currentValue);
        model.visitNonZeros(_function);
        return result;
    }

    public static DenseMatrix copy(DenseMatrix model) {
        int _nRows = model.nRows();
        int _nCols = model.nCols();
        DenseMatrix result = model.createEmpty(_nRows, _nCols);
        MatrixVisitorEditInPlace _function = (row, col, currentValue) -> model.get(row, col);
        result.editInPlace(_function);
        return result;
    }

    public static ColtSparseMatrix convertToColtSparseMatrix(SparseMatrix model) {
        int _nRows = model.nRows();
        int _nCols = model.nCols();
        SparseDoubleMatrix2D _sparseDoubleMatrix2D = new SparseDoubleMatrix2D(_nRows, _nCols);
        ColtSparseMatrix result = new ColtSparseMatrix((DoubleMatrix2D)_sparseDoubleMatrix2D);
        MatrixVisitorViewOnly _function = (row, col, currentValue) -> result.set(row, col, currentValue);
        model.visitNonZeros(_function);
        return result;
    }

    public static CommonsDenseMatrix convertToCommonsDenseMatrix(DenseMatrix model) {
        int _nRows = model.nRows();
        int _nCols = model.nCols();
        BlockRealMatrix _blockRealMatrix = new BlockRealMatrix(_nRows, _nCols);
        CommonsDenseMatrix result = new CommonsDenseMatrix((RealMatrix)_blockRealMatrix);
        MatrixVisitorEditInPlace _function = (row, col, currentValue) -> model.get(row, col);
        result.editInPlace(_function);
        return result;
    }

    public static SparseMatrix identity(int size) {
        SparseMatrix result = StaticUtils.createEmptySparseMatrix(size, size);
        for (int i = 0; i < size; ++i) {
            result.set(i, i, 1.0);
        }
        return result;
    }

    public static String toString(Matrix matrix) {
        String _xblockexpression = null;
        TablePrettyPrinter printer = new TablePrettyPrinter();
        for (int row2 = 0; row2 < matrix.nRows(); ++row2) {
            printer.set(1 + row2, 0, "" + Integer.valueOf(row2) + " | ");
        }
        for (int col2 = 0; col2 < matrix.nCols(); ++col2) {
            printer.set(0, 1 + 2 * col2, "" + Integer.valueOf(col2));
            printer.makeJustificationToLeft(1 + 2 * col2 + 1);
        }
        MatrixVisitorViewOnly _function = (row, col, value) -> {
            String str = String.format(Locale.US, "%G", value);
            int dotLocation = str.indexOf(".");
            CharSequence _xifexpression = null;
            _xifexpression = dotLocation == -1 ? str : str.subSequence(0, dotLocation);
            String prefix = _xifexpression;
            CharSequence _xifexpression_1 = null;
            if (dotLocation == -1) {
                _xifexpression_1 = "";
            } else {
                int _length = str.length();
                _xifexpression_1 = str.subSequence(dotLocation, _length);
            }
            String suffix = _xifexpression_1;
            String _string = prefix.toString();
            String _plus = "  " + _string;
            printer.set(1 + row, 1 + 2 * col + 0, _plus);
            String _string_1 = suffix.toString();
            printer.set(1 + row, 1 + 2 * col + 1, _string_1);
        };
        StaticUtils.forceVisitAllEntries(matrix, _function);
        _xblockexpression = printer.toString("");
        return _xblockexpression;
    }

    public static String toStringDimensions(Matrix matrix) {
        int _nRows = matrix.nRows();
        String _plus = "" + Integer.valueOf(_nRows);
        String _plus_1 = _plus + " x ";
        int _nCols = matrix.nCols();
        return _plus_1 + Integer.valueOf(_nCols);
    }

    public static void visitSkippingSomeZeros(Matrix matrix, MatrixVisitorViewOnly visitor) {
        boolean _matched = false;
        if (!_matched && matrix instanceof SparseMatrix) {
            _matched = true;
            ((SparseMatrix)matrix).visitNonZeros(visitor);
        }
        if (!_matched && matrix instanceof DenseMatrix) {
            _matched = true;
            ((DenseMatrix)matrix).visit(visitor);
        }
        if (!_matched) {
            throw denseOrSparseException;
        }
    }

    public static void forceVisitAllEntries(Matrix matrix, MatrixVisitorViewOnly visitor) {
        boolean _matched = false;
        if (!_matched && matrix instanceof DenseMatrix) {
            _matched = true;
            ((DenseMatrix)matrix).visit(visitor);
        }
        if (!_matched && matrix instanceof SparseMatrix) {
            _matched = true;
            for (int r = 0; r < ((SparseMatrix)matrix).nRows(); ++r) {
                for (int c = 0; c < ((SparseMatrix)matrix).nCols(); ++c) {
                    double _get = ((SparseMatrix)matrix).get(r, c);
                    visitor.visit(r, c, _get);
                }
            }
        }
        if (!_matched) {
            throw denseOrSparseException;
        }
    }

    public static DenseMatrix multiply(SparseMatrix sparse, DenseMatrix dense) {
        StaticUtils.checkMatrixMultiplicationDimensionsMatch(sparse, dense);
        int _nRows = sparse.nRows();
        int _nCols = dense.nCols();
        DenseMatrix result = dense.createEmpty(_nRows, _nCols);
        MatrixVisitorViewOnly _function = (m1Row, sharedDim, m1Value) -> {
            for (int m2Col = 0; m2Col < dense.nCols(); ++m2Col) {
                double m2Value = dense.get(sharedDim, m2Col);
                if (m2Value == 0.0) continue;
                StaticUtils.increment(result, m1Row, m2Col, m1Value * m2Value);
            }
        };
        sparse.visitNonZeros(_function);
        return result;
    }

    public static DenseMatrix multiply(DenseMatrix dense, SparseMatrix sparse) {
        StaticUtils.checkMatrixMultiplicationDimensionsMatch(dense, sparse);
        int _nRows = dense.nRows();
        int _nCols = sparse.nCols();
        DenseMatrix result = dense.createEmpty(_nRows, _nCols);
        MatrixVisitorViewOnly _function = (sharedDim, m2Col, m2Value) -> {
            for (int m1Row = 0; m1Row < dense.nRows(); ++m1Row) {
                double m1Value = dense.get(m1Row, sharedDim);
                if (m1Value == 0.0) continue;
                StaticUtils.increment(result, m1Row, m2Col, m1Value * m2Value);
            }
        };
        sparse.visitNonZeros(_function);
        return result;
    }

    public static void increment(Matrix m, int row, int col, double increment) {
        double _get = m.get(row, col);
        double _plus = increment + _get;
        m.set(row, col, _plus);
    }

    public static DenseMatrix add(DenseMatrix matrix1, DenseMatrix matrix2) {
        DenseMatrix result = StaticUtils.copy(matrix1);
        StaticUtils.addInPlace(result, matrix2);
        return result;
    }

    public static void addInPlace(DenseMatrix destination, DenseMatrix source) {
        StaticUtils.checkSizesEqual(destination, source);
        MatrixVisitorEditInPlace _function = (row, col, currentValue) -> {
            double _get = source.get(row, col);
            return _get + currentValue;
        };
        destination.editInPlace(_function);
    }

    public static SparseMatrix add(SparseMatrix matrix1, SparseMatrix matrix2) {
        SparseMatrix result = StaticUtils.copy(matrix1);
        StaticUtils.addInPlace((Matrix)result, matrix2);
        return result;
    }

    public static DenseMatrix add(SparseMatrix matrix2, DenseMatrix matrix1) {
        DenseMatrix result = StaticUtils.copy(matrix1);
        StaticUtils.addInPlace((Matrix)result, matrix2);
        return result;
    }

    public static void addInPlace(Matrix destination, SparseMatrix source) {
        if (destination == source) {
            StaticUtils.scaleInPlace(source, 2.0);
            return;
        }
        StaticUtils.checkSizesEqual(destination, source);
        MatrixVisitorViewOnly _function = (row, col, currentValue) -> {
            double _get = destination.get(row, col);
            double _plus = currentValue + _get;
            destination.set(row, col, _plus);
        };
        source.visitNonZeros(_function);
    }

    public static void addInPlace(SparseMatrix destination, DenseMatrix source) {
        if (destination == source) {
            throw notBothSparseAndDense;
        }
        StaticUtils.checkSizesEqual(destination, source);
        MatrixVisitorViewOnly _function = (row, col, value) -> StaticUtils.increment(destination, row, col, value);
        source.visit(_function);
    }

    public static void scaleInPlace(SparseMatrix matrix, double scalar) {
        if (scalar == 1.0) {
            return;
        }
        MatrixVisitorEditInPlace _function = (row, col, value) -> value * scalar;
        matrix.editNonZerosInPlace(_function);
    }

    public static SparseMatrix scale(SparseMatrix matrix, double scalar) {
        SparseMatrix result = StaticUtils.copy(matrix);
        StaticUtils.scaleInPlace(result, scalar);
        return result;
    }

    public static void scaleInPlace(DenseMatrix matrix, double scalar) {
        if (scalar == 1.0) {
            return;
        }
        MatrixVisitorEditInPlace _function = (row, col, value) -> value * scalar;
        matrix.editInPlace(_function);
    }

    public static DenseMatrix scale(DenseMatrix matrix, double scalar) {
        DenseMatrix result = StaticUtils.copy(matrix);
        StaticUtils.scaleInPlace(result, scalar);
        return result;
    }

    public static void subtractInPlace(DenseMatrix matrix1, DenseMatrix matrix2) {
        DenseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        StaticUtils.addInPlace(matrix1, _scale);
    }

    public static void subtractInPlace(SparseMatrix matrix1, SparseMatrix matrix2) {
        SparseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        StaticUtils.addInPlace((Matrix)matrix1, _scale);
    }

    public static void subtractInPlace(SparseMatrix matrix1, DenseMatrix matrix2) {
        DenseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        StaticUtils.addInPlace(matrix1, _scale);
    }

    public static void subtractInPlace(DenseMatrix matrix1, SparseMatrix matrix2) {
        SparseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        StaticUtils.addInPlace((Matrix)matrix1, _scale);
    }

    public static DenseMatrix subtract(DenseMatrix matrix1, DenseMatrix matrix2) {
        DenseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        return StaticUtils.add(matrix1, _scale);
    }

    public static SparseMatrix subtract(SparseMatrix matrix1, SparseMatrix matrix2) {
        SparseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        return StaticUtils.add(matrix1, _scale);
    }

    public static DenseMatrix subtract(SparseMatrix matrix1, DenseMatrix matrix2) {
        DenseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        return StaticUtils.add(matrix1, _scale);
    }

    public static DenseMatrix subtract(DenseMatrix matrix1, SparseMatrix matrix2) {
        SparseMatrix _scale = StaticUtils.scale(matrix2, -1.0);
        return StaticUtils.add(_scale, matrix1);
    }

    public static void checkValidSlice(Matrix m, int row0Incl, int row1Excl, int col0Incl, int col1Excl) {
        if (row1Excl <= row0Incl || col1Excl <= col0Incl) {
            throw new IllegalArgumentException("Slice dimensions should be positive.");
        }
        StaticUtils.checkBounds(m, row0Incl, col0Incl);
        StaticUtils.checkBounds(m, row1Excl - 1, col1Excl - 1);
    }

    public static void checkBounds(Matrix m, int row, int col) {
        int _nCols;
        boolean _greaterEqualsThan_1;
        int _nRows;
        boolean _greaterEqualsThan;
        boolean _or = false;
        _or = row < 0 ? true : (_greaterEqualsThan = row >= (_nRows = m.nRows()));
        if (_or) {
            int _nRows_1 = m.nRows();
            int _minus = _nRows_1 - 1;
            throw StaticUtils.outOfRangeException(row, _minus, true);
        }
        boolean _or_1 = false;
        _or_1 = col < 0 ? true : (_greaterEqualsThan_1 = col >= (_nCols = m.nCols()));
        if (_or_1) {
            int _nCols_1 = m.nCols();
            int _minus_1 = _nCols_1 - 1;
            throw StaticUtils.outOfRangeException(col, _minus_1, false);
        }
    }

    public static OutOfRangeException outOfRangeException(int index, int max, boolean isRow) {
        LocalizedFormats _xifexpression = null;
        _xifexpression = isRow ? LocalizedFormats.ROW_INDEX : LocalizedFormats.COLUMN_INDEX;
        return new OutOfRangeException((Localizable)_xifexpression, (Number)index, (Number)0, (Number)max);
    }

    public static void checkMatrixMultiplicationDimensionsMatch(Matrix matrix1, Matrix matrix2) {
        int _nRows;
        boolean _notEquals;
        int _nCols = matrix1.nCols();
        boolean bl = _notEquals = _nCols != (_nRows = matrix2.nRows());
        if (_notEquals) {
            int _nCols_1 = matrix1.nCols();
            int _nRows_1 = matrix2.nRows();
            throw new DimensionMismatchException(_nCols_1, _nRows_1);
        }
    }

    private static void checkSizesEqual(Matrix matrix1, Matrix matrix2) {
        int _nCols_1;
        int _nCols;
        boolean _notEquals_1;
        int _nRows_1;
        boolean _notEquals;
        boolean _or = false;
        int _nRows = matrix1.nRows();
        boolean bl = _notEquals = _nRows != (_nRows_1 = matrix2.nRows());
        _or = _notEquals ? true : (_notEquals_1 = (_nCols = matrix1.nCols()) != (_nCols_1 = matrix2.nCols()));
        if (_or) {
            throw StaticUtils.sizesNoteEqualException(matrix1, matrix2);
        }
    }

    private static DimensionMismatchException sizesNoteEqualException(Matrix matrix1, Matrix matrix2) {
        int _nRows_1;
        boolean _notEquals;
        int _nRows = matrix1.nRows();
        boolean bl = _notEquals = _nRows != (_nRows_1 = matrix2.nRows());
        if (_notEquals) {
            int _nRows_2 = matrix1.nRows();
            int _nRows_3 = matrix2.nRows();
            return StaticUtils.dimensionMismatchException(_nRows_2, _nRows_3);
        }
        int _nCols = matrix1.nCols();
        int _nCols_1 = matrix2.nCols();
        return StaticUtils.dimensionMismatchException(_nCols, _nCols_1);
    }

    private static DimensionMismatchException dimensionMismatchException(int d1, int d2) {
        int _max = Math.max(d1, d2);
        int _min = Math.min(d1, d2);
        return new DimensionMismatchException(_max, _min);
    }
}

