/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;

public interface AccessAnyD<N extends Number>
extends StructureAnyD,
Access1D<N> {
    @Override
    default public double doubleValue(long index) {
        return this.doubleValue(AccessUtils.reference(index, this.shape()));
    }

    public double doubleValue(long[] var1);

    @Override
    default public N get(long index) {
        return this.get(AccessUtils.reference(index, this.shape()));
    }

    public N get(long[] var1);

    public static interface Sliceable<N extends Number>
    extends StructureAnyD,
    Access1D.Sliceable<N> {
        public Access1D<N> slice(long[] var1, int var2);
    }

    public static interface Visitable<N extends Number>
    extends StructureAnyD,
    Access1D.Visitable<N> {
        public void visitOne(long[] var1, VoidFunction<N> var2);
    }

    public static interface IndexOf
    extends StructureAnyD,
    Access1D.IndexOf {
    }

    public static interface Settable<N extends Number>
    extends StructureAnyD,
    Access1D.Settable<N> {
        @Override
        default public void add(long index, double addend) {
            this.add(AccessUtils.reference(index, this.shape()), addend);
        }

        @Override
        default public void add(long index, Number addend) {
            this.add(AccessUtils.reference(index, this.shape()), addend);
        }

        public void add(long[] var1, double var2);

        public void add(long[] var1, Number var2);

        @Override
        default public void set(long index, double value) {
            this.set(AccessUtils.reference(index, this.shape()), value);
        }

        @Override
        default public void set(long index, Number value) {
            this.set(AccessUtils.reference(index, this.shape()), value);
        }

        public void set(long[] var1, double var2);

        public void set(long[] var1, Number var2);
    }

    public static interface Modifiable<N extends Number>
    extends Settable<N>,
    Access1D.Modifiable<N> {
        public void modifyOne(long[] var1, UnaryFunction<N> var2);

        @Override
        default public void modifyRange(long first, long limit, UnaryFunction<N> function) {
            for (long i = first; i < limit; ++i) {
                this.modifyOne(i, function);
            }
        }
    }

    public static interface Fillable<N extends Number>
    extends Settable<N>,
    Access1D.Fillable<N> {
        public void fillOne(long[] var1, N var2);

        public void fillOne(long[] var1, NullaryFunction<N> var2);

        @Override
        default public void fillRange(long first, long limit, N value) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, value);
            }
        }

        @Override
        default public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, supplier);
            }
        }
    }

    public static interface Factory<I extends AccessAnyD<?>> {
        public I copy(AccessAnyD<?> var1);

        public I makeFilled(long[] var1, NullaryFunction<?> var2);

        public I makeZero(long ... var1);
    }

    public static interface Elements
    extends StructureAnyD,
    Access1D.Elements {
        public boolean isAbsolute(long[] var1);

        public boolean isSmall(long[] var1, double var2);

        default public boolean isZero(long[] reference) {
            return this.isSmall(reference, PrimitiveMath.ONE);
        }
    }

    public static interface Builder<I extends AccessAnyD<?>>
    extends StructureAnyD,
    Access1D.Builder<I> {
        @Override
        public I build();

        public Builder<I> set(long[] var1, double var2);

        public Builder<I> set(long[] var1, Number var2);
    }
}

