/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class Array1D<N extends Number>
extends AbstractList<N>
implements Access1D<N>,
Access1D.Elements,
Access1D.IndexOf,
Access1D.Fillable<N>,
Access1D.Modifiable<N>,
Access1D.Visitable<N>,
Access1D.Sliceable<N>,
RandomAccess,
Serializable {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        BasicArray.BasicFactory<BigDecimal> delegate() {
            return BasicArray.BIG;
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        BasicArray.BasicFactory<ComplexNumber> delegate() {
            return BasicArray.COMPLEX;
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public Array1D<Double> copy(Access1D<?> source) {
            long tmpCount = source.count();
            BasicArray<Double> tmpDelegate = this.delegate().makeToBeFilled(tmpCount);
            for (long i = 0L; i < tmpCount; ++i) {
                tmpDelegate.set(i, source.doubleValue(i));
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public Array1D<Double> copy(double ... source) {
            return new PrimitiveArray(source).asArray1D();
        }

        @Override
        BasicArray.BasicFactory<Double> delegate() {
            return BasicArray.PRIMITIVE;
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        BasicArray.BasicFactory<Quaternion> delegate() {
            return BasicArray.QUATERNION;
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        BasicArray.BasicFactory<RationalNumber> delegate() {
            return BasicArray.RATIONAL;
        }
    };
    public final long length;
    private final BasicArray<N> myDelegate;
    private final long myFirst;
    private final long myLimit;
    private final long myStep;

    private static <T extends Number> T[] copyAndSort(Array1D<T> anArray) {
        int tmpLength = (int)anArray.length;
        Object[] retVal = new Number[tmpLength];
        for (int i = 0; i < tmpLength; ++i) {
            retVal[i] = anArray.get(i);
        }
        Arrays.sort(retVal);
        return retVal;
    }

    private Array1D() {
        this(null);
    }

    Array1D(BasicArray<N> delegate) {
        this(delegate, 0L, delegate.count(), 1L);
    }

    Array1D(BasicArray<N> delegate, long first, long limit, long step) {
        this.myDelegate = delegate;
        this.myFirst = first;
        this.myLimit = limit;
        this.myStep = step;
        this.length = (this.myLimit - this.myFirst) / this.myStep;
    }

    @Override
    public void add(long index, double addend) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.add(tmpIndex, addend);
    }

    @Override
    public void add(long index, Number addend) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.add(tmpIndex, addend);
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    public Array1D<N> copy() {
        DenseArray retVal = null;
        if (this.myDelegate instanceof PrimitiveArray) {
            retVal = new PrimitiveArray((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, this.doubleValue(i));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof ComplexArray) {
            retVal = new ComplexArray((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, (Number)this.get(i));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof BigArray) {
            retVal = new BigArray((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, (Number)this.get(i));
            }
            return new Array1D<N>(retVal);
        }
        return null;
    }

    public Array1D<N> copy(int ... indices) {
        DenseArray retVal = null;
        int tmpLength = indices.length;
        if (this.myDelegate instanceof PrimitiveArray) {
            retVal = new PrimitiveArray(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, this.doubleValue(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof ComplexArray) {
            retVal = new ComplexArray(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, (Number)this.get(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof BigArray) {
            retVal = new BigArray(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, (Number)this.get(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        return null;
    }

    @Override
    public long count() {
        return this.length;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(this.myFirst + this.myStep * index);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.fillOne(tmpIndex, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.fillOne(tmpIndex, supplier);
    }

    @Override
    public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOneMatching(this.myFirst + this.myStep * index, values, valueIndex);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.fill(tmpFirst, tmpLimit, this.myStep, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.fill(tmpFirst, tmpLimit, this.myStep, supplier);
    }

    @Override
    public N get(int index) {
        return this.myDelegate.get(this.myFirst + this.myStep * (long)index);
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(this.myFirst + this.myStep * index);
    }

    @Override
    public int indexOf(Object obj) {
        block3: {
            int tmpLength;
            block2: {
                tmpLength = (int)this.length;
                if (obj != null) break block2;
                for (int i = 0; i < tmpLength; ++i) {
                    if (this.get(i) != null) continue;
                    return i;
                }
                break block3;
            }
            if (!(obj instanceof Number)) break block3;
            for (int i = 0; i < tmpLength; ++i) {
                if (!obj.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public long indexOfLargest() {
        return this.indexOfLargestInRange(this.myFirst, this.myLimit);
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return (this.myDelegate.indexOfLargest(this.myFirst + this.myStep * first, this.myFirst + this.myStep * limit, this.myStep) - this.myFirst) / this.myStep;
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(this.myFirst + this.myStep * index);
    }

    @Deprecated
    public boolean isAllZeros() {
        return this.myDelegate.isSmall(this.myFirst, this.myLimit, this.myStep, PrimitiveMath.ONE);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    @Deprecated
    public boolean isRangeZeros(long first, long limit) {
        return this.myDelegate.isSmall(this.myFirst + this.myStep * first, this.myFirst + this.myStep * limit, this.myStep, PrimitiveMath.ONE);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(this.myFirst + this.myStep * index, comparedTo);
    }

    @Override
    public void modifyAll(UnaryFunction<N> function) {
        this.myDelegate.modify(this.myFirst, this.myLimit, this.myStep, function);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long tmpLength = Math.min(this.length, left.count());
        if (this.myDelegate instanceof PrimitiveArray) {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, (Number)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long tmpLength = Math.min(this.length, right.count());
        if (this.myDelegate instanceof PrimitiveArray) {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, (Number)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> function) {
        this.myDelegate.modifyOne(this.myFirst + this.myStep * index, function);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> function) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.modify(tmpFirst, tmpLimit, this.myStep, function);
    }

    @Deprecated
    public int searchAscending(N key) {
        if (this.myDelegate instanceof DenseArray) {
            if (this.count() != this.myDelegate.count()) {
                int tmpLength = (int)this.length;
                Object[] tmpArray = new Number[tmpLength];
                for (int i = 0; i < tmpLength; ++i) {
                    tmpArray[i] = this.get(i);
                }
                return Arrays.binarySearch(tmpArray, key);
            }
            return ((DenseArray)this.myDelegate).searchAscending(key);
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int searchDescending(N key) {
        if (this.myDelegate instanceof DenseArray) {
            int tmpLength = (int)this.length;
            Object[] tmpArray = new Number[tmpLength];
            for (int i = 0; i < tmpLength; ++i) {
                tmpArray[i] = this.get(tmpLength - 1 - i);
            }
            int tmpInd = Arrays.binarySearch(tmpArray, key);
            if (tmpInd >= 0) {
                return tmpLength - 1 - tmpInd;
            }
            if (tmpInd < -1) {
                return -tmpLength - tmpInd - 1;
            }
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public N set(int index, Number value) {
        long tmpIndex = this.myFirst + this.myStep * (long)index;
        Object retVal = this.myDelegate.get(tmpIndex);
        this.myDelegate.set(tmpIndex, value);
        return retVal;
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(this.myFirst + this.myStep * index, value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(this.myFirst + this.myStep * index, value);
    }

    @Override
    public int size() {
        return (int)this.length;
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return new Array1D<N>(this.myDelegate, this.myFirst + this.myStep * first, this.myFirst + this.myStep * limit, this.myStep);
    }

    @Deprecated
    public void sortAscending() {
        if (this.myDelegate instanceof DenseArray) {
            if (this.count() != this.myDelegate.count()) {
                Number[] tmpArray = Array1D.copyAndSort((Array1D)this);
                int tmpLength = (int)this.length;
                for (int i = 0; i < tmpLength; ++i) {
                    this.set(i, tmpArray[i]);
                }
            } else {
                ((DenseArray)this.myDelegate).sortAscending();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Deprecated
    public void sortDescending() {
        if (this.myDelegate instanceof DenseArray) {
            Number[] tmpArray = Array1D.copyAndSort((Array1D)this);
            int tmpLength = (int)this.length;
            for (int i = 0; i < tmpLength; ++i) {
                this.set(i, tmpArray[tmpLength - 1 - i]);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Spliterator<N> spliterator() {
        return Spliterators.spliterator(this, 1040);
    }

    @Override
    public Array1D<N> subList(int first, int limit) {
        return this.sliceRange(first, limit);
    }

    @Deprecated
    public double[] toRawCopy() {
        int tmpLength = (int)this.length;
        double[] retVal = new double[tmpLength];
        for (int i = 0; i < tmpLength; ++i) {
            retVal[i] = this.doubleValue(i);
        }
        return retVal;
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(this.myFirst, this.myLimit, this.myStep, visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(this.myFirst + this.myStep * index, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.visit(tmpFirst, tmpLimit, this.myStep, visitor);
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    public static abstract class Factory<N extends Number>
    implements Access1D.Factory<Array1D<N>> {
        @Override
        public Array1D<N> copy(Access1D<?> source) {
            long tmpCount = source.count();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpCount);
            for (long i = 0L; i < tmpCount; ++i) {
                tmpDelegate.set(i, (Number)source.get(i));
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public Array1D<N> copy(double ... source) {
            int tmpLength = source.length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                tmpDelegate.set((long)i, source[i]);
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public final Array1D<N> copy(List<? extends Number> source) {
            int tmpSize = source.size();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpSize);
            for (int i = 0; i < tmpSize; ++i) {
                tmpDelegate.set((long)i, source.get(i));
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public final Array1D<N> copy(Number ... source) {
            int tmpLength = source.length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                tmpDelegate.set((long)i, source[i]);
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public final Array1D<N> makeFilled(long count, NullaryFunction<?> supplier) {
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(count);
            int i = 0;
            while ((long)i < count) {
                tmpDelegate.set((long)i, (Number)supplier.get());
                ++i;
            }
            return tmpDelegate.asArray1D();
        }

        @Override
        public final Array1D<N> makeZero(long count) {
            return ((BasicArray)this.delegate().makeZero(count)).asArray1D();
        }

        public final Array1D<N> wrap(BasicArray<N> array) {
            return array.asArray1D();
        }

        abstract BasicArray.BasicFactory<N> delegate();
    }
}

