/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.machine.JavaType;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public class PrimitiveArray
extends DenseArray<Double> {
    static final long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static final DenseArray.DenseFactory<Double> FACTORY = new DenseArray.DenseFactory<Double>(){

        @Override
        public final BasicArray<Double> makeFilled(long count, NullaryFunction<?> supplier) {
            int tmpSize = (int)count;
            double[] tmpData = new double[tmpSize];
            for (int i = 0; i < tmpSize; ++i) {
                tmpData[i] = supplier.doubleValue();
            }
            return new PrimitiveArray(tmpData);
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        DenseArray<Double> make(int size) {
            return PrimitiveArray.make(size);
        }

        @Override
        Scalar<Double> zero() {
            return PrimitiveScalar.ZERO;
        }
    };
    public final double[] data;

    public static final PrimitiveArray make(int size) {
        return new PrimitiveArray(size);
    }

    public static final SegmentedArray<Double> makeSegmented(int size) {
        return SegmentedArray.make(FACTORY, size);
    }

    public static final SegmentedArray<Double> makeSegmented(long count) {
        return SegmentedArray.make(FACTORY, count);
    }

    public static final PrimitiveArray wrap(double[] data) {
        return new PrimitiveArray(data);
    }

    private static void add(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left + right[i];
        }
    }

    private static void add(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right;
        }
    }

    private static void add(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right[i];
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left / right[i];
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right;
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right[i];
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left * right[i];
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right;
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right[i];
        }
    }

    private static void negate(double[] data, int first, int limit, int step, double[] values) {
        for (int i = first; i < limit; i += step) {
            data[i] = -values[i];
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left - right[i];
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right;
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right[i];
        }
    }

    protected static void exchange(double[] data, int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            double tmpVal = data[tmpIndexA];
            data[tmpIndexA] = data[tmpIndexB];
            data[tmpIndexB] = tmpVal;
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    protected static void fill(double[] data, Access1D<?> values) {
        int tmpLimit = (int)Math.min((long)data.length, values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            data[i] = values.doubleValue(i);
        }
    }

    protected static void fill(double[] data, int first, int limit, int step, double value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    protected static void fill(double[] data, int first, int limit, int step, NullaryFunction<Double> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = supplier.doubleValue();
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof PrimitiveArray && right instanceof PrimitiveArray) {
            PrimitiveArray.invoke(data, first, limit, step, ((PrimitiveArray)left).data, function, ((PrimitiveArray)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        if (left instanceof PrimitiveArray) {
            PrimitiveArray.invoke(data, first, limit, step, ((PrimitiveArray)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right);
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> values, ParameterFunction<Double> function, int aParam) {
        if (values instanceof PrimitiveArray) {
            PrimitiveArray.invoke(data, first, limit, step, ((PrimitiveArray)values).data, function, aParam);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.doubleValue(i), aParam);
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> values, UnaryFunction<Double> function) {
        if (values instanceof PrimitiveArray) {
            PrimitiveArray.invoke(data, first, limit, step, ((PrimitiveArray)values).data, function);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof PrimitiveArray) {
            PrimitiveArray.invoke(data, first, limit, step, left, function, ((PrimitiveArray)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, VoidFunction<Double> aVisitor) {
        for (int i = first; i < limit; i += step) {
            aVisitor.invoke(data[i]);
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveFunction.ADD) {
            PrimitiveArray.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            PrimitiveArray.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            PrimitiveArray.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            PrimitiveArray.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double right) {
        if (function == PrimitiveFunction.ADD) {
            PrimitiveArray.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            PrimitiveArray.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            PrimitiveArray.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            PrimitiveArray.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveFunction.ADD) {
            PrimitiveArray.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            PrimitiveArray.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            PrimitiveArray.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            PrimitiveArray.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] values, ParameterFunction<Double> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(values[i], aParam);
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] values, UnaryFunction<Double> function) {
        if (function == PrimitiveFunction.NEGATE) {
            PrimitiveArray.negate(data, first, limit, step, values);
        } else if (function instanceof BinaryFunction.FixedFirst) {
            BinaryFunction.FixedFirst tmpFunc = (BinaryFunction.FixedFirst)function;
            PrimitiveArray.invoke(data, first, limit, step, tmpFunc.doubleValue(), tmpFunc.getFunction(), values);
        } else if (function instanceof BinaryFunction.FixedSecond) {
            BinaryFunction.FixedSecond tmpFunc = (BinaryFunction.FixedSecond)function;
            PrimitiveArray.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.doubleValue());
        } else if (function instanceof ParameterFunction.FixedParameter) {
            ParameterFunction.FixedParameter tmpFunc = (ParameterFunction.FixedParameter)function;
            PrimitiveArray.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.getParameter());
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values[i]);
            }
        }
    }

    protected PrimitiveArray(double[] data) {
        this.data = data;
    }

    protected PrimitiveArray(int size) {
        this.data = new double[size];
    }

    public boolean equals(Object anObj) {
        if (anObj instanceof PrimitiveArray) {
            return Arrays.equals(this.data, ((PrimitiveArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        PrimitiveArray.fill(this.data, values);
    }

    @Override
    public final void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        PrimitiveArray.invoke(this.data, 0, tmpLimit, 1, left, function, right);
    }

    @Override
    public final void fillMatching(UnaryFunction<Double> function, Access1D<Double> arguments) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), arguments.count());
        PrimitiveArray.invoke(this.data, 0, tmpLimit, 1, arguments, function);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.data, 0, this.data.length, 1040);
    }

    public DoubleStream stream(boolean parallel) {
        return StreamSupport.doubleStream(this.spliterator(), parallel);
    }

    @Override
    protected void add(int index, double addend) {
        int n = index;
        this.data[n] = this.data[n] + addend;
    }

    @Override
    protected void add(int index, Number addend) {
        int n = index;
        this.data[n] = this.data[n] + addend.doubleValue();
    }

    protected final double[] copyOfData() {
        return ArrayUtils.copyOf(this.data);
    }

    @Override
    protected final double doubleValue(int index) {
        return this.data[index];
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        PrimitiveArray.exchange(this.data, firstA, firstB, step, count);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        PrimitiveArray.invoke(this.data, first, limit, 1, left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        PrimitiveArray.invoke(this.data, first, limit, 1, left, function, (double)right);
    }

    @Override
    protected final void fill(int first, int limit, Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        PrimitiveArray.invoke(this.data, first, limit, 1, (double)left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, int step, Double value) {
        PrimitiveArray.fill(this.data, first, limit, step, value);
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<Double> supplier) {
        PrimitiveArray.fill(this.data, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.data[index] = value;
    }

    @Override
    protected void fillOne(int index, NullaryFunction<Double> supplier) {
        this.data[index] = supplier.doubleValue();
    }

    @Override
    protected void fillOneMatching(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = values.doubleValue(valueIndex);
    }

    @Override
    protected final Double get(int index) {
        return this.data[index];
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = first; i < limit; i += step) {
            double tmpValue = Math.abs(this.data[i]);
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.data[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.data[index]);
    }

    @Override
    protected void modify(int index, Access1D<Double> left, BinaryFunction<Double> function) {
        this.data[index] = function.invoke(left.doubleValue(index), this.data[index]);
    }

    @Override
    protected void modify(int index, BinaryFunction<Double> function, Access1D<Double> right) {
        this.data[index] = function.invoke(this.data[index], right.doubleValue(index));
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        PrimitiveArray.invoke(this.data, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        PrimitiveArray.invoke(this.data, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Double right) {
        PrimitiveArray.invoke(this.data, first, limit, step, this.data, function, (double)right);
    }

    @Override
    protected final void modify(int first, int limit, int step, Double left, BinaryFunction<Double> function) {
        PrimitiveArray.invoke(this.data, first, limit, step, (double)left, function, this.data);
    }

    @Override
    protected final void modify(int first, int limit, int step, ParameterFunction<Double> function, int parameter) {
        PrimitiveArray.invoke(this.data, first, limit, step, this.data, function, parameter);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        PrimitiveArray.invoke(this.data, first, limit, step, this, function);
    }

    @Override
    protected void modify(int index, UnaryFunction<Double> function) {
        this.data[index] = function.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(Double aNmbr) {
        return Arrays.binarySearch(this.data, aNmbr);
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = value;
    }

    @Override
    protected final void set(int index, Number value) {
        this.data[index] = value.doubleValue();
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    @Override
    protected final void sortAscending() {
        Arrays.sort(this.data);
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        PrimitiveArray.invoke(this.data, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    boolean isPrimitive() {
        return true;
    }

    @Override
    DenseArray<Double> newInstance(int capacity) {
        return new PrimitiveArray(capacity);
    }

    Spliterator.OfDouble split() {
        return Spliterators.spliterator(this.data, 0);
    }
}

