/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.finance.portfolio.SimpleAsset;
import org.ojalgo.finance.portfolio.SimplePortfolio;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

abstract class EquilibriumModel
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient BasicMatrix myAssetReturns;
    private transient BasicMatrix myAssetVolatilities;
    private transient BasicMatrix myAssetWeights;
    private final MarketEquilibrium myMarketEquilibrium;
    private transient Scalar<?> myMeanReturn;
    private transient Scalar<?> myReturnVariance;

    private EquilibriumModel() {
        this((MarketEquilibrium)null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected EquilibriumModel(FinancePortfolio.Context context) {
        this.myMarketEquilibrium = new MarketEquilibrium(context.getCovariances());
    }

    protected EquilibriumModel(MarketEquilibrium marketEquilibrium) {
        this.myMarketEquilibrium = marketEquilibrium.copy();
    }

    @Override
    public final double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        BasicMatrix tmpAssetWeights = (BasicMatrix)FinancePortfolio.MATRIX_FACTORY.columns(tmpWeights);
        BasicMatrix tmpAssetReturns = this.getAssetReturns();
        return this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public final double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        BasicMatrix tmpAssetWeights = (BasicMatrix)FinancePortfolio.MATRIX_FACTORY.columns(tmpWeights);
        return this.calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public final BasicMatrix getAssetReturns() {
        if (this.myAssetReturns == null) {
            this.myAssetReturns = this.calculateAssetReturns();
        }
        return this.myAssetReturns;
    }

    @Override
    public final BasicMatrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = this.myMarketEquilibrium.toCorrelations();
        }
        return this.myAssetVolatilities;
    }

    public final BasicMatrix getAssetWeights() {
        BasicMatrix tmpAssetWeights;
        if (this.myAssetWeights == null && (tmpAssetWeights = this.calculateAssetWeights()) != null) {
            this.myAssetWeights = tmpAssetWeights.enforce(WEIGHT_CONTEXT);
        }
        return this.myAssetWeights;
    }

    @Override
    public final BasicMatrix getCorrelations() {
        return this.myMarketEquilibrium.toCorrelations();
    }

    @Override
    public final BasicMatrix getCovariances() {
        return this.myMarketEquilibrium.getCovariances();
    }

    public final MarketEquilibrium getMarketEquilibrium() {
        return this.myMarketEquilibrium.copy();
    }

    @Override
    public final double getMeanReturn() {
        if (this.myMeanReturn == null) {
            BasicMatrix tmpAssetWeights = this.getAssetWeights();
            BasicMatrix tmpAssetReturns = this.getAssetReturns();
            if (tmpAssetWeights != null && tmpAssetReturns != null) {
                this.myMeanReturn = this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns);
            }
        }
        return this.myMeanReturn.doubleValue();
    }

    @Override
    public final double getReturnVariance() {
        if (this.myReturnVariance == null) {
            this.myReturnVariance = this.calculatePortfolioVariance(this.getAssetWeights());
        }
        return this.myReturnVariance.doubleValue();
    }

    public final Scalar<?> getRiskAversion() {
        return this.myMarketEquilibrium.getRiskAversion();
    }

    public final String[] getSymbols() {
        return this.myMarketEquilibrium.getAssetKeys();
    }

    @Override
    public final List<BigDecimal> getWeights() {
        BasicMatrix tmpAssetWeights = this.getAssetWeights();
        if (tmpAssetWeights != null) {
            return tmpAssetWeights.toBigStore().asList();
        }
        return null;
    }

    public final void setRiskAversion(Number factor) {
        this.myMarketEquilibrium.setRiskAversion(factor);
        this.reset();
    }

    @Override
    public int size() {
        return this.myMarketEquilibrium.size();
    }

    public final List<SimpleAsset> toSimpleAssets() {
        BasicMatrix tmpReturns = this.getAssetReturns();
        BasicMatrix tmpCovariances = this.getCovariances();
        List<BigDecimal> tmpWeights = this.getWeights();
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpReturns.doubleValue(i, 0L);
            double tmpVolatility = Math.sqrt(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            retVal.add(new SimpleAsset(tmpMeanReturn, tmpVolatility, tmpWeight));
        }
        return retVal;
    }

    public final SimplePortfolio toSimplePortfolio() {
        return new SimplePortfolio(this.getCorrelations(), this.toSimpleAssets());
    }

    @Override
    public String toString() {
        return TypeUtils.format("RAF={} {}", this.getRiskAversion().toString(), super.toString());
    }

    protected abstract BasicMatrix calculateAssetReturns();

    protected final BasicMatrix calculateAssetReturns(BasicMatrix aWeightsVctr) {
        return this.myMarketEquilibrium.calculateAssetReturns(aWeightsVctr);
    }

    protected abstract BasicMatrix calculateAssetWeights();

    protected final BasicMatrix calculateAssetWeights(BasicMatrix aReturnsVctr) {
        return this.myMarketEquilibrium.calculateAssetWeights(aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioReturn(BasicMatrix aWeightsVctr, BasicMatrix aReturnsVctr) {
        return MarketEquilibrium.calculatePortfolioReturn(aWeightsVctr, aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioVariance(BasicMatrix aWeightsVctr) {
        return this.myMarketEquilibrium.calculatePortfolioVariance(aWeightsVctr);
    }

    protected final void calibrate(BasicMatrix aWeightsVctr, BasicMatrix aReturnsVctr) {
        Scalar<?> tmpRiskAvesrion = this.myMarketEquilibrium.calculateImpliedRiskAversion(aWeightsVctr, aReturnsVctr);
        this.setRiskAversion((Number)tmpRiskAvesrion.getNumber());
    }

    @Override
    protected void reset() {
        this.myAssetWeights = null;
        this.myAssetReturns = null;
        this.myMeanReturn = null;
        this.myReturnVariance = null;
    }

    final boolean isDefaultRiskAversion() {
        return this.myMarketEquilibrium.isDefaultRiskAversion();
    }
}

