/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.EquilibriumModel;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.LowerUpper;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class MarkowitzModel
extends EquilibriumModel {
    private static final double _0_0 = BigMath.ZERO.doubleValue();
    private static final String BALANCE = "Balance";
    private static final double INIT = Math.sqrt(PrimitiveMath.TEN);
    private static final double MAX = PrimitiveMath.HUNDRED * PrimitiveMath.HUNDRED;
    private static final double MIN = PrimitiveMath.HUNDREDTH;
    private static final NumberContext TARGET_CONTEXT = NumberContext.getGeneral(7, 14);
    private static final String VARIANCE = "Variance";
    private final HashMap<int[], LowerUpper> myConstraints = new HashMap();
    private final BasicMatrix myExpectedExcessReturns;
    private transient ExpressionsBasedModel myOptimisationModel;
    private transient Optimisation.State myOptimisationState = Optimisation.State.UNEXPLORED;
    private transient Expression myOptimisationVariance;
    private boolean myShortingAllowed = false;
    private BigDecimal myTargetReturn;
    private BigDecimal myTargetVariance;
    private final Variable[] myVariables;

    public MarkowitzModel(BasicMatrix covarianceMatrix, BasicMatrix expectedExcessReturns) {
        this(new MarketEquilibrium(covarianceMatrix), expectedExcessReturns);
    }

    public MarkowitzModel(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
        this.myExpectedExcessReturns = portfolioContext.getAssetReturns();
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(this.myExpectedExcessReturns.toBigDecimal(i, 0).negate());
        }
    }

    public MarkowitzModel(MarketEquilibrium marketEquilibrium, BasicMatrix expectedExcessReturns) {
        super(marketEquilibrium);
        this.myExpectedExcessReturns = expectedExcessReturns;
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(this.myExpectedExcessReturns.toBigDecimal(i, 0).negate());
        }
        if (marketEquilibrium.size() != (int)expectedExcessReturns.count()) {
            throw new IllegalArgumentException("Wrong dimensiuons!");
        }
    }

    private MarkowitzModel(MarketEquilibrium marketEquilibrium) {
        super(marketEquilibrium);
        this.myExpectedExcessReturns = null;
        this.myVariables = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public LowerUpper addConstraint(BigDecimal lowerLimit, BigDecimal upperLimit, int ... assetIndeces) {
        return this.myConstraints.put(assetIndeces, new LowerUpper(lowerLimit, upperLimit));
    }

    public final void clearAllConstraints() {
        this.myConstraints.clear();
        this.reset();
    }

    public final Optimisation.State getOptimisationState() {
        if (this.myOptimisationState == null) {
            this.myOptimisationState = Optimisation.State.UNEXPLORED;
        }
        return this.myOptimisationState;
    }

    public final void setLowerLimit(int assetIndex, BigDecimal lowerLimit) {
        this.myVariables[assetIndex].lower(lowerLimit);
        this.reset();
    }

    public final void setShortingAllowed(boolean allowed) {
        this.myShortingAllowed = allowed;
        this.reset();
    }

    public final void setTargetReturn(BigDecimal targetReturn) {
        this.myTargetReturn = targetReturn;
        this.myTargetVariance = null;
        this.reset();
    }

    public final void setTargetVariance(BigDecimal targetVariance) {
        this.myTargetVariance = targetVariance;
        this.myTargetReturn = null;
        this.reset();
    }

    public final void setUpperLimit(int assetIndex, BigDecimal upperLimit) {
        this.myVariables[assetIndex].upper(upperLimit);
        this.reset();
    }

    @Override
    public String toString() {
        if (this.myOptimisationModel == null) {
            this.calculateAssetWeights();
        }
        return this.myOptimisationModel.toString();
    }

    private ExpressionsBasedModel generateOptimisationModel(double riskAversion) {
        if (this.myOptimisationModel == null || this.myOptimisationVariance == null) {
            int i;
            Variable[] tmpVariables = new Variable[this.myVariables.length];
            for (int i2 = 0; i2 < tmpVariables.length; ++i2) {
                tmpVariables[i2] = this.myVariables[i2].copy();
                if (this.myShortingAllowed || this.myVariables[i2].getLowerLimit() != null && this.myVariables[i2].getLowerLimit().signum() != -1) continue;
                tmpVariables[i2].lower(BigMath.ZERO);
            }
            this.myOptimisationModel = new ExpressionsBasedModel(tmpVariables);
            this.myOptimisationVariance = this.myOptimisationModel.addExpression(VARIANCE);
            BasicMatrix tmpCovariances = this.getCovariances();
            for (int j = 0; j < tmpVariables.length; ++j) {
                for (i = 0; i < tmpVariables.length; ++i) {
                    this.myOptimisationVariance.set(i, j, (Number)tmpCovariances.toBigDecimal(i, j));
                }
            }
            Expression tmpBalanceExpression = this.myOptimisationModel.addExpression(BALANCE);
            for (i = 0; i < tmpVariables.length; ++i) {
                tmpBalanceExpression.set(i, (Number)BigMath.ONE);
            }
            tmpBalanceExpression.level(BigMath.ONE);
            for (Map.Entry<int[], LowerUpper> tmpConstraintSet : this.myConstraints.entrySet()) {
                int[] tmpKey = tmpConstraintSet.getKey();
                LowerUpper tmpValue = tmpConstraintSet.getValue();
                Expression tmpExpr = this.myOptimisationModel.addExpression(Arrays.toString(tmpKey));
                for (int i3 = 0; i3 < tmpKey.length; ++i3) {
                    tmpExpr.set(tmpKey[i3], (Number)BigMath.ONE);
                }
                ((Expression)tmpExpr.lower(tmpValue.lower)).upper(tmpValue.upper);
            }
        }
        this.myOptimisationVariance.weight(riskAversion / 2.0);
        return this.myOptimisationModel;
    }

    private Optimisation.Result optimise() {
        Optimisation.Result retVal;
        if (this.myTargetReturn != null || this.myTargetVariance != null) {
            double tmpTargetValue = this.myTargetVariance != null ? this.myTargetVariance.doubleValue() : (this.myTargetReturn != null ? this.myTargetReturn.doubleValue() : _0_0);
            retVal = this.generateOptimisationModel(_0_0).minimise();
            double tmpTargetNow = _0_0;
            double tmpTargetDiff = _0_0;
            double tmpTargetLast = _0_0;
            tmpTargetLast = this.myTargetVariance != null ? this.calculatePortfolioVariance(retVal).doubleValue() : (this.myTargetReturn != null ? this.calculatePortfolioReturn(retVal, this.myExpectedExcessReturns).doubleValue() : tmpTargetValue);
            if (retVal.getState().isFeasible() && tmpTargetValue < tmpTargetLast) {
                double tmpHigh;
                double tmpLow;
                double tmpCurrent;
                if (this.isDefaultRiskAversion()) {
                    tmpCurrent = INIT;
                    tmpLow = MAX;
                    tmpHigh = MIN;
                } else {
                    tmpCurrent = this.getRiskAversion().doubleValue();
                    tmpLow = tmpCurrent * INIT;
                    tmpHigh = tmpCurrent / INIT;
                }
                do {
                    retVal = this.generateOptimisationModel(tmpCurrent).minimise();
                    tmpTargetLast = tmpTargetNow;
                    tmpTargetNow = this.myTargetVariance != null ? this.calculatePortfolioVariance(retVal).doubleValue() : (this.myTargetReturn != null ? this.calculatePortfolioReturn(retVal, this.myExpectedExcessReturns).doubleValue() : tmpTargetValue);
                    tmpTargetDiff = tmpTargetNow - tmpTargetValue;
                    if (tmpTargetDiff < _0_0) {
                        tmpLow = tmpCurrent;
                    } else if (tmpTargetDiff > _0_0) {
                        tmpHigh = tmpCurrent;
                    }
                    tmpCurrent = Math.sqrt(tmpLow * tmpHigh);
                } while (!TARGET_CONTEXT.isSmall(tmpTargetValue, tmpTargetDiff) && TARGET_CONTEXT.isDifferent(tmpTargetLast, tmpTargetNow));
            }
        } else {
            retVal = this.generateOptimisationModel(this.getRiskAversion().doubleValue()).minimise();
        }
        return retVal;
    }

    @Override
    protected BasicMatrix calculateAssetReturns() {
        return this.myExpectedExcessReturns;
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        Optimisation.Result tmpResult = this.optimise();
        this.myOptimisationState = tmpResult.getState();
        return (BasicMatrix)MATRIX_FACTORY.columns(tmpResult);
    }

    @Override
    protected void reset() {
        super.reset();
        this.myOptimisationModel = null;
        this.myOptimisationVariance = null;
        this.myOptimisationState = Optimisation.State.UNEXPLORED;
    }

    final Scalar<?> calculatePortfolioReturn(Access1D<?> weightsVctr, BasicMatrix returnsVctr) {
        return super.calculatePortfolioReturn((BasicMatrix)MATRIX_FACTORY.columns(weightsVctr), returnsVctr);
    }

    final Scalar<?> calculatePortfolioVariance(Access1D<?> weightsVctr) {
        return super.calculatePortfolioVariance((BasicMatrix)MATRIX_FACTORY.columns(weightsVctr));
    }
}

