/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.TypeUtils;

public abstract class FunctionUtils {
    public static <N extends Number> boolean isZeroModified(UnaryFunction<N> function) {
        return !TypeUtils.isZero(function.invoke(PrimitiveMath.ZERO));
    }

    public static int max(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b, long c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int min(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int min(int a, int b, int c, int d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b, long c) {
        return Math.min(Math.min(a, b), c);
    }

    private FunctionUtils() {
    }
}

