/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.Iterator1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixError;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

abstract class AbstractMatrix<N extends Number, I extends BasicMatrix>
implements BasicMatrix,
Serializable {
    private transient Eigenvalue<N> myEigenvalue = null;
    private transient int myHashCode = 0;
    private transient LU<N> myLU = null;
    private final PhysicalStore.Factory<N, ? extends PhysicalStore<N>> myPhysicalFactory;
    private transient QR<N> myQR = null;
    private transient SingularValue<N> mySingularValue = null;
    private final MatrixStore<N> myStore;

    private AbstractMatrix() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    AbstractMatrix(MatrixStore<N> store) {
        this.myStore = store;
        this.myPhysicalFactory = this.getFactory().getPhysicalFactory();
    }

    @Override
    public I add(Access2D<?> addend) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, addend);
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        retVal.fillMatching(this.myStore, this.myPhysicalFactory.function().add(), this.getStoreFrom(addend));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I add(BasicMatrix addend) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, addend);
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        retVal.fillMatching(this.myStore, this.myPhysicalFactory.function().add(), this.getStoreFrom(addend));
        return this.getFactory().instantiate(retVal);
    }

    public I add(int row, int col, Access2D<?> addend) {
        MatrixStore<N> tmpDiff = this.getStoreFrom(addend);
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.builder().superimpose(row, col, tmpDiff).get());
    }

    public I add(int row, int col, Number aNmbr) {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.builder().superimpose(row, col, aNmbr).get());
    }

    @Override
    public I add(Number addend) {
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        N tmpRight = this.myPhysicalFactory.scalar().cast(addend);
        retVal.fillMatching(this.myPhysicalFactory.function().add().second(tmpRight), this.myStore);
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I conjugate() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.conjugate());
    }

    public Access2D.Builder<I> copyToBuilder() {
        return this.getFactory().wrap(this.myStore.copy());
    }

    @Override
    public long count() {
        return this.myStore.count();
    }

    @Override
    public long countColumns() {
        return this.myStore.countColumns();
    }

    @Override
    public long countRows() {
        return this.myStore.countRows();
    }

    public I divide(Number divisor) {
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        N tmpRight = this.myPhysicalFactory.scalar().cast(divisor);
        retVal.fillMatching(this.myPhysicalFactory.function().divide().second(tmpRight), this.myStore);
        return this.getFactory().instantiate(retVal);
    }

    public I divideElements(Access2D<?> aMtrx) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, aMtrx);
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        retVal.fillMatching(this.myStore, this.myPhysicalFactory.function().divide(), this.getStoreFrom(aMtrx));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public double doubleValue(long index) {
        return this.myStore.doubleValue(index);
    }

    @Override
    public double doubleValue(long i, long j) {
        return this.myStore.doubleValue(i, j);
    }

    @Override
    public boolean equals(Access2D<?> aMtrx, NumberContext aCntxt) {
        return AccessUtils.equals(this.myStore, aMtrx, aCntxt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Access2D) {
            return this.equals((Access2D)obj, NumberContext.getGeneral(6));
        }
        return super.equals(obj);
    }

    @Override
    public void flushCache() {
        this.myHashCode = 0;
        this.myEigenvalue = null;
        this.myLU = null;
        this.myQR = null;
        this.mySingularValue = null;
    }

    @Override
    public N get(long index) {
        return this.myStore.get(index);
    }

    @Override
    public N get(long aRow, long aColumn) {
        return this.getStore().get(aRow, aColumn);
    }

    public I getColumnsRange(int aFirst, int aLimit) {
        return this.getFactory().instantiate(this.myStore.builder().columns(aFirst, aLimit).build());
    }

    public Scalar<N> getCondition() {
        return this.myPhysicalFactory.scalar().convert(this.getComputedSingularValue().getCondition());
    }

    public Scalar<N> getDeterminant() {
        return this.myPhysicalFactory.scalar().convert((Number)this.getComputedLU().getDeterminant());
    }

    @Override
    public List<ComplexNumber> getEigenvalues() {
        return this.getComputedEigenvalue().getEigenvalues();
    }

    public Scalar<N> getFrobeniusNorm() {
        if (this.getSingularValue().isComputed()) {
            return this.myPhysicalFactory.scalar().convert(this.getSingularValue().getFrobeniusNorm());
        }
        return this.myPhysicalFactory.scalar().convert((Number)this.myStore.aggregateAll(Aggregator.NORM2));
    }

    public Scalar<N> getInfinityNorm() {
        double retVal = PrimitiveMath.ZERO;
        AggregatorFunction<N> tmpRowSumAggr = this.myPhysicalFactory.aggregator().norm1();
        int tmpRowDim = (int)this.myStore.countRows();
        for (int i = 0; i < tmpRowDim; ++i) {
            this.myStore.visitRow(i, 0L, tmpRowSumAggr);
            retVal = Math.max(retVal, tmpRowSumAggr.doubleValue());
            tmpRowSumAggr.reset();
        }
        return this.myPhysicalFactory.scalar().convert(retVal);
    }

    public Scalar<N> getKyFanNorm(int k) {
        return this.myPhysicalFactory.scalar().convert(this.getComputedSingularValue().getKyFanNorm(k));
    }

    public Scalar<N> getOneNorm() {
        double retVal = PrimitiveMath.ZERO;
        AggregatorFunction<N> tmpColSumAggr = this.myPhysicalFactory.aggregator().norm1();
        int tmpColDim = (int)this.countColumns();
        for (int j = 0; j < tmpColDim; ++j) {
            this.myStore.visitColumn(0L, j, tmpColSumAggr);
            retVal = Math.max(retVal, tmpColSumAggr.doubleValue());
            tmpColSumAggr.reset();
        }
        return this.myPhysicalFactory.scalar().convert(retVal);
    }

    public Scalar<N> getOperatorNorm() {
        return this.myPhysicalFactory.scalar().convert(this.getComputedSingularValue().getOperatorNorm());
    }

    @Override
    public int getRank() {
        if (this.getSingularValue().isComputed() || this.isFat()) {
            return this.getComputedSingularValue().getRank();
        }
        if (this.getQR().isComputed() || this.isTall()) {
            return this.getComputedQR().getRank();
        }
        return this.getComputedLU().getRank();
    }

    public I getRowsRange(int aFirst, int aLimit) {
        return this.getFactory().instantiate(this.myStore.builder().rows(aFirst, aLimit).build());
    }

    public List<Double> getSingularValues() {
        return this.getComputedSingularValue().getSingularValues();
    }

    public Scalar<N> getTrace() {
        AggregatorFunction<N> tmpAggr = this.myPhysicalFactory.aggregator().sum();
        this.myStore.visitDiagonal(0L, 0L, tmpAggr);
        return this.myPhysicalFactory.scalar().convert((Number)tmpAggr.getNumber());
    }

    public Scalar<N> getTraceNorm() {
        return this.myPhysicalFactory.scalar().convert(this.getComputedSingularValue().getTraceNorm());
    }

    public Scalar<N> getVectorNorm(int aDegree) {
        switch (aDegree) {
            case 0: {
                return this.myPhysicalFactory.scalar().convert((Number)this.myStore.aggregateAll(Aggregator.CARDINALITY));
            }
            case 1: {
                return this.myPhysicalFactory.scalar().convert((Number)this.myStore.aggregateAll(Aggregator.NORM1));
            }
            case 2: {
                return this.myPhysicalFactory.scalar().convert((Number)this.myStore.aggregateAll(Aggregator.NORM2));
            }
        }
        return this.myPhysicalFactory.scalar().convert((Number)this.myStore.aggregateAll(Aggregator.LARGEST));
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            this.myHashCode = MatrixUtils.hashCode(this.myStore);
        }
        return this.myHashCode;
    }

    public I invert() {
        MatrixStore retVal = null;
        retVal = this.isSquare() && this.getComputedLU().isSolvable() ? this.getComputedLU().getInverse() : (this.isTall() && this.getComputedQR().isSolvable() ? this.getComputedQR().getInverse() : this.getComputedSingularValue().getInverse());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public boolean isEmpty() {
        return this.countRows() <= 0L || this.countColumns() <= 0L;
    }

    @Override
    public boolean isFat() {
        return !this.isEmpty() && this.countRows() < this.countColumns();
    }

    @Override
    public boolean isFullRank() {
        return (long)this.getRank() == Math.min(this.myStore.countRows(), this.myStore.countColumns());
    }

    @Override
    public boolean isHermitian() {
        return this.isSquare() && this.myStore.equals((MatrixStore<N>)this.myStore.conjugate(), NumberContext.getGeneral(6));
    }

    @Override
    public boolean isScalar() {
        return this.myStore.countRows() == 1L && this.countColumns() == 1L;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return this.myStore.isSmall(comparedTo);
    }

    @Override
    public boolean isSquare() {
        return !this.isEmpty() && this.countRows() == this.countColumns();
    }

    @Override
    public boolean isSymmetric() {
        return this.isSquare() && this.myStore.equals((MatrixStore<N>)this.myStore.transpose(), NumberContext.getGeneral(6));
    }

    @Override
    public boolean isTall() {
        return !this.isEmpty() && this.countRows() > this.countColumns();
    }

    @Override
    public boolean isVector() {
        return this.countColumns() == 1L || this.countRows() == 1L;
    }

    @Override
    public Iterator<Number> iterator() {
        return new Iterator1D<Number>(this.myStore);
    }

    public I mergeColumns(Access2D<?> aMtrx) {
        MatrixError.throwIfNotEqualColumnDimensions(this.myStore, aMtrx);
        return this.getFactory().instantiate(this.myStore.builder().below(this.getStoreFrom(aMtrx)).build());
    }

    public I mergeRows(Access2D<?> aMtrx) {
        MatrixError.throwIfNotEqualRowDimensions(this.myStore, aMtrx);
        return this.getFactory().instantiate(this.myStore.builder().right(this.getStoreFrom(aMtrx)).build());
    }

    public I modify(UnaryFunction<? extends Number> aFunc) {
        PhysicalStore<? extends Number> retVal = this.myStore.copy();
        retVal.modifyAll(aFunc);
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I multiply(Access2D<?> right) {
        MatrixError.throwIfMultiplicationNotPossible(this.myStore, right);
        return this.getFactory().instantiate(this.myStore.multiply(this.getStoreFrom(right)));
    }

    @Override
    public I multiply(double scalar) {
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        N tmpRight = this.myPhysicalFactory.scalar().cast(scalar);
        retVal.fillMatching(this.myPhysicalFactory.function().multiply().second(tmpRight), this.myStore);
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I multiply(Number scalar) {
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        N tmpRight = this.myPhysicalFactory.scalar().cast(scalar);
        retVal.fillMatching(this.myPhysicalFactory.function().multiply().second(tmpRight), this.myStore);
        return this.getFactory().instantiate(retVal);
    }

    public I multiplyElements(Access2D<?> aMtrx) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, aMtrx);
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        retVal.fillMatching(this.myStore, this.myPhysicalFactory.function().multiply(), this.getStoreFrom(aMtrx));
        return this.getFactory().instantiate(retVal);
    }

    public I multiplyLeft(Access2D<?> aMtrx) {
        MatrixError.throwIfMultiplicationNotPossible(aMtrx, this.myStore);
        return this.getFactory().instantiate(this.getStoreFrom(aMtrx).multiply(this.myStore));
    }

    @Override
    public Scalar<?> multiplyVectors(Access2D<?> aVctr) {
        if (this.countRows() == 1L) {
            return this.multiply((Access2D<?>)(aVctr.countColumns() == 1L ? aVctr : this.getStoreFrom(aVctr).transpose())).toScalar(0L, 0L);
        }
        if (this.countColumns() == 1L) {
            return this.multiplyLeft((Access2D<?>)(aVctr.countRows() == 1L ? aVctr : this.getStoreFrom(aVctr).transpose())).toScalar(0L, 0L);
        }
        throw new ProgrammingError("Not a vector!");
    }

    @Override
    public I negate() {
        PhysicalStore<N> retVal = this.myStore.copy();
        retVal.modifyAll(this.myPhysicalFactory.function().negate());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public double norm() {
        return this.myStore.norm();
    }

    public I selectColumns(int ... someCols) {
        return this.getFactory().instantiate(this.myStore.builder().column(someCols).build());
    }

    public I selectRows(int ... someRows) {
        return this.getFactory().instantiate(this.myStore.builder().row(someRows).build());
    }

    @Override
    public I signum() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.signum());
    }

    public I solve(Access2D<?> aRHS) {
        MatrixStore<N> retVal = null;
        retVal = this.isSquare() && this.getComputedLU().isSolvable() ? this.getComputedLU().solve(this.getStoreFrom(aRHS)) : (this.isTall() && this.getComputedQR().isSolvable() ? this.getComputedQR().solve(this.getStoreFrom(aRHS)) : this.getComputedSingularValue().solve(this.getStoreFrom(aRHS)));
        return this.getFactory().instantiate(retVal);
    }

    public I subtract(Access2D<?> aMtrx) {
        MatrixError.throwIfNotEqualDimensions(this, aMtrx);
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        retVal.fillMatching(this.myStore, this.myPhysicalFactory.function().subtract(), this.getStoreFrom(aMtrx));
        return this.getFactory().instantiate(retVal);
    }

    public I subtract(Number value) {
        PhysicalStore retVal = (PhysicalStore)this.myPhysicalFactory.makeZero(this.countRows(), this.countColumns());
        N tmpRight = this.myPhysicalFactory.scalar().cast(value);
        retVal.fillMatching(this.myPhysicalFactory.function().subtract().second(tmpRight), this.myStore);
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public PhysicalStore<BigDecimal> toBigStore() {
        return (PhysicalStore)BigDenseStore.FACTORY.copy(this);
    }

    @Override
    public PhysicalStore<ComplexNumber> toComplexStore() {
        return (PhysicalStore)ComplexDenseStore.FACTORY.copy(this);
    }

    @Override
    public List<BasicMatrix> toListOfColumns() {
        int tmpColDim = (int)this.countColumns();
        ArrayList<BasicMatrix> retVal = new ArrayList<BasicMatrix>(tmpColDim);
        for (int j = 0; j < tmpColDim; ++j) {
            retVal.add(j, (BasicMatrix)this.selectColumns(j));
        }
        return retVal;
    }

    public List<N> toListOfElements() {
        return this.myStore.copy().asList();
    }

    @Override
    public List<BasicMatrix> toListOfRows() {
        int tmpRowDim = (int)this.countRows();
        ArrayList<BasicMatrix> retVal = new ArrayList<BasicMatrix>(tmpRowDim);
        for (int i = 0; i < tmpRowDim; ++i) {
            retVal.add(i, (BasicMatrix)this.selectRows(i));
        }
        return retVal;
    }

    @Override
    public PhysicalStore<Double> toPrimitiveStore() {
        return (PhysicalStore)PrimitiveDenseStore.FACTORY.copy(this);
    }

    public Scalar<N> toScalar(long row, long col) {
        return this.myStore.toScalar(row, col);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public I transpose() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.transpose());
    }

    private final Eigenvalue<N> getComputedEigenvalue() {
        Eigenvalue<N> retVal = this.getEigenvalue();
        if (!retVal.isComputed()) {
            retVal.decompose(this.myStore);
        }
        return retVal;
    }

    private final LU<N> getComputedLU() {
        LU<N> retVal = this.getLU();
        if (!retVal.isComputed()) {
            retVal.decompose(this.myStore);
        }
        return retVal;
    }

    private final QR<N> getComputedQR() {
        QR<N> retVal = this.getQR();
        if (!retVal.isComputed()) {
            retVal.decompose(this.myStore);
        }
        return retVal;
    }

    private final SingularValue<N> getComputedSingularValue() {
        SingularValue<N> retVal = this.getSingularValue();
        if (!retVal.isComputed()) {
            retVal.decompose(this.myStore);
        }
        return retVal;
    }

    private final Eigenvalue<N> getEigenvalue() {
        if (this.myEigenvalue == null) {
            this.myEigenvalue = Eigenvalue.make(this.myStore);
        }
        return this.myEigenvalue;
    }

    private final LU<N> getLU() {
        if (this.myLU == null) {
            this.myLU = LU.make(this.myStore);
        }
        return this.myLU;
    }

    private final QR<N> getQR() {
        if (this.myQR == null) {
            this.myQR = QR.make(this.myStore);
        }
        return this.myQR;
    }

    private final SingularValue<N> getSingularValue() {
        if (this.mySingularValue == null) {
            this.mySingularValue = SingularValue.make(this.myStore);
        }
        return this.mySingularValue;
    }

    abstract MatrixFactory<N, I> getFactory();

    final PhysicalStore.Factory<N, ? extends PhysicalStore<N>> getPhysicalFactory() {
        return this.myPhysicalFactory;
    }

    final MatrixStore<N> getStore() {
        return this.myStore;
    }

    abstract MatrixStore<N> getStoreFrom(Access1D<?> var1);
}

