/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

final class MatrixFactory<N extends Number, I extends BasicMatrix>
implements BasicMatrix.Factory<I> {
    private final Constructor<I> myConstructor;
    private final PhysicalStore.Factory<N, ?> myPhysicalFactory;

    private static Constructor<? extends BasicMatrix> getConstructor(Class<? extends BasicMatrix> aTemplate) {
        try {
            Constructor<? extends BasicMatrix> retVal = aTemplate.getDeclaredConstructor(MatrixStore.class);
            retVal.setAccessible(true);
            return retVal;
        }
        catch (SecurityException anException) {
            return null;
        }
        catch (NoSuchMethodException anException) {
            return null;
        }
    }

    private MatrixFactory() {
        this(null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    MatrixFactory(Class<I> aTemplate, PhysicalStore.Factory<N, ?> aPhysical) {
        this.myPhysicalFactory = aPhysical;
        this.myConstructor = MatrixFactory.getConstructor(aTemplate);
    }

    @Override
    public I columns(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I copy(Access2D<?> source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.copy(source));
    }

    @Override
    public Access2D.Builder<I> getBuilder(int count) {
        return this.getBuilder(count, 1);
    }

    @Override
    public Access2D.Builder<I> getBuilder(int rows, int columns) {
        return new MatrixBuilder(this.myPhysicalFactory, rows, columns);
    }

    @Override
    public I makeEye(long rows, long columns) {
        int tmpMinDim = (int)Math.min(rows, columns);
        MatrixStore.Builder<N> retVal = this.myPhysicalFactory.builder().makeIdentity(tmpMinDim);
        if (rows > (long)tmpMinDim) {
            retVal = retVal.below((int)rows - tmpMinDim);
        } else if (columns > (long)tmpMinDim) {
            retVal = retVal.right((int)columns - tmpMinDim);
        }
        return this.instantiate((MatrixStore<N>)retVal.get());
    }

    @Override
    public I makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.makeFilled(rows, columns, supplier));
    }

    @Override
    public I makeZero(long rows, long columns) {
        return this.instantiate((MatrixStore<N>)this.myPhysicalFactory.builder().makeZero((int)rows, (int)columns).get());
    }

    @Override
    public I rows(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    protected final PhysicalStore.Factory<N, ?> getPhysicalFactory() {
        return this.myPhysicalFactory;
    }

    final I instantiate(MatrixStore<N> aStore) {
        try {
            return (I)((BasicMatrix)this.myConstructor.newInstance(aStore));
        }
        catch (IllegalArgumentException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InstantiationException anException) {
            throw new ProgrammingError(anException);
        }
        catch (IllegalAccessException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InvocationTargetException anException) {
            throw new ProgrammingError(anException);
        }
    }

    final MatrixBuilder wrap(PhysicalStore<N> aStore) {
        return new MatrixBuilder(aStore);
    }

    final class MatrixBuilder
    implements Access2D.Builder<I> {
        private final PhysicalStore.Factory<N, ?> myFactory;
        private final PhysicalStore<N> myPhysicalStore;
        private boolean mySafe = true;

        private MatrixBuilder() {
            this(null, 0, 0);
        }

        protected MatrixBuilder(PhysicalStore.Factory<N, ?> aFactory, int aRowDim, int aColDim) {
            this.myPhysicalStore = (PhysicalStore)aFactory.makeZero(aRowDim, aColDim);
            this.myFactory = aFactory;
        }

        MatrixBuilder(PhysicalStore<N> aPhysicalStore) {
            this.myPhysicalStore = aPhysicalStore;
            this.myFactory = aPhysicalStore.factory();
        }

        @Override
        public I build() {
            this.mySafe = false;
            return MatrixFactory.this.instantiate(this.myPhysicalStore);
        }

        @Override
        public long count() {
            return this.myPhysicalStore.count();
        }

        @Override
        public long countColumns() {
            return this.myPhysicalStore.countColumns();
        }

        @Override
        public long countRows() {
            return this.myPhysicalStore.countRows();
        }

        public final MatrixBuilder fillAll(Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.fillAll(this.myFactory.scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillColumn(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.fillColumn((long)((int)row), (long)((int)column), this.myFactory.scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillDiagonal(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.fillDiagonal((long)((int)row), (long)((int)column), this.myFactory.scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillRow(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.fillRow((long)((int)row), (long)((int)column), this.myFactory.scalar().cast(value));
            return this;
        }

        public final MatrixBuilder set(long index, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.set(index, value);
            return this;
        }

        public final MatrixBuilder set(long row, long column, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.set(row, column, value);
            return this;
        }

        public final MatrixBuilder set(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.set(row, column, (Number)this.myFactory.scalar().cast(value));
            return this;
        }

        public final MatrixBuilder set(long index, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myPhysicalStore.set(index, (Number)this.myFactory.scalar().cast(value));
            return this;
        }
    }
}

