/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveMatrix
extends AbstractMatrix<Double, PrimitiveMatrix> {
    public static final BasicMatrix.Factory<PrimitiveMatrix> FACTORY = new MatrixFactory<Double, PrimitiveMatrix>(PrimitiveMatrix.class, PrimitiveDenseStore.FACTORY);

    public static Access2D.Builder<PrimitiveMatrix> getBuilder(int aLength) {
        return FACTORY.getBuilder(aLength);
    }

    public static Access2D.Builder<PrimitiveMatrix> getBuilder(int aRowDim, int aColDim) {
        return FACTORY.getBuilder(aRowDim, aColDim);
    }

    PrimitiveMatrix(MatrixStore<Double> aStore) {
        super(aStore);
    }

    @Override
    public PrimitiveMatrix enforce(NumberContext context) {
        return (PrimitiveMatrix)this.modify(context.getPrimitiveFunction());
    }

    @Override
    public BigDecimal toBigDecimal(int row, int column) {
        return new BigDecimal(this.getStore().doubleValue(row, column));
    }

    @Override
    public ComplexNumber toComplexNumber(int row, int column) {
        return ComplexNumber.valueOf(this.getStore().doubleValue(row, column));
    }

    @Override
    public PhysicalStore<Double> toPrimitiveStore() {
        return this.getStore().copy();
    }

    @Override
    public String toString(int row, int col) {
        return Double.toString(this.doubleValue(row, col));
    }

    @Override
    MatrixFactory<Double, PrimitiveMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    MatrixStore<Double> getStoreFrom(Access1D<?> matrix) {
        if (matrix instanceof PrimitiveMatrix) {
            return ((PrimitiveMatrix)matrix).getStore();
        }
        if (matrix instanceof PrimitiveDenseStore) {
            return (PrimitiveDenseStore)matrix;
        }
        if (matrix instanceof MatrixStore && !this.isEmpty() && matrix.get(0L) instanceof Double) {
            return (MatrixStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return (MatrixStore)this.getPhysicalFactory().copy((Access2D)matrix);
        }
        return (MatrixStore)this.getPhysicalFactory().columns(matrix);
    }
}

