/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QRDecomposition;
import org.ojalgo.matrix.decomposition.RawQR;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface QR<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Determinant<N> {
    public static <N extends Number> QR<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new QRDecomposition.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new QRDecomposition.Complex();
        }
        if (tmpNumber instanceof Double) {
            if (256L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new QRDecomposition.Primitive();
            }
            return new RawQR();
        }
        throw new IllegalArgumentException();
    }

    public static QR<BigDecimal> makeBig() {
        return new QRDecomposition.Big();
    }

    public static QR<ComplexNumber> makeComplex() {
        return new QRDecomposition.Complex();
    }

    public static QR<Double> makePrimitive() {
        return new QRDecomposition.Primitive();
    }

    public MatrixStore<N> getQ();

    public MatrixStore<N> getR();

    public int getRank();

    public boolean isFullColumnRank();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

