/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.Maths;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

abstract class RawEigenvalue
extends RawDecomposition
implements Eigenvalue<Double> {
    private transient double cdivr;
    private transient double cdivi;
    private double[] d;
    private double[] e;
    private double[][] H;
    private RawStore myInverse;
    private int n;
    private double[][] Vt;

    protected RawEigenvalue() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        this.getRawInPlaceStore().fillMatching(matrix);
        this.doDecompose(tmpData);
        return this.getDeterminant();
    }

    @Override
    public boolean computeValuesOnly(ElementsSupplier<Double> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    @Override
    public boolean equals(MatrixStore<Double> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    public RawStore getD() {
        RawStore X = new RawStore(this.n, this.n);
        double[][] D = X.data;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                D[i][j] = PrimitiveMath.ZERO;
            }
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D[i][i - 1] = this.e[i];
        }
        return X;
    }

    @Override
    public Double getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return tmpVisitor.getNumber().doubleValue();
    }

    @Override
    public Array1D<ComplexNumber> getEigenvalues() {
        double[] tmpRe = this.getRealEigenvalues();
        double[] tmpIm = this.getImagEigenvalues();
        Access1D retVal = Array1D.COMPLEX.makeZero(tmpRe.length);
        for (int i = 0; i < ((Array1D)retVal).size(); ++i) {
            ((Array1D)retVal).set(i, (Object)ComplexNumber.of(tmpRe[i], tmpIm[i]));
        }
        ((Array1D)retVal).sortDescending();
        return retVal;
    }

    public RawStore getInverse() {
        if (this.myInverse == null) {
            double[][] tmpQ1 = this.getV().data;
            double[] tmpEigen = this.getRealEigenvalues();
            RawStore tmpMtrx = new RawStore(tmpEigen.length, tmpQ1.length);
            for (int i = 0; i < tmpEigen.length; ++i) {
                int j;
                if (TypeUtils.isZero(tmpEigen[i])) {
                    for (j = 0; j < tmpQ1.length; ++j) {
                        tmpMtrx.set((long)i, (long)j, PrimitiveMath.ZERO);
                    }
                    continue;
                }
                for (j = 0; j < tmpQ1.length; ++j) {
                    tmpMtrx.set((long)i, (long)j, tmpQ1[j][i] / tmpEigen[i]);
                }
            }
            this.myInverse = new RawStore(this.getV().multiply((Access1D)tmpMtrx));
        }
        return this.myInverse;
    }

    @Override
    public ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return tmpVisitor.getNumber();
    }

    public RawStore getV() {
        return new RawStore(this.Vt, this.n, this.n).transpose();
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(original, false);
        this.getRawInPlaceStore().fillMatching(original);
        this.doDecompose(tmpData);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isOrdered() {
        return !this.isHermitian();
    }

    public boolean isSolvable() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }

    @Override
    public void reset() {
        this.myInverse = null;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(body, false);
        this.getRawInPlaceStore().fillMatching(body);
        this.doDecompose(tmpData);
        preallocated.fillMatching(rhs);
        return this.getInverse().multiply((Access1D)preallocated);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        return null;
    }

    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        return null;
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int nn = this.n;
        int n = nn - 1;
        boolean low = false;
        int high = nn - 1;
        double eps = PrimitiveMath.MACHINE_EPSILON;
        double exshift = PrimitiveMath.ZERO;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = PrimitiveMath.ZERO;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < 0 | i2 > high) {
                this.d[i2] = this.H[i2][i2];
                this.e[i2] = PrimitiveMath.ZERO;
            }
            for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += Math.abs(this.H[i2][j2]);
            }
        }
        int iter = 0;
        while (n >= 0) {
            int m;
            for (l = n; l > 0; --l) {
                s = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (s == PrimitiveMath.ZERO) {
                    s = norm;
                }
                if (Math.abs(this.H[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                this.H[n][n] = this.H[n][n] + exshift;
                this.d[n] = this.H[n][n];
                this.e[n] = PrimitiveMath.ZERO;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H[n][n - 1] * this.H[n - 1][n];
                p = (this.H[n - 1][n - 1] - this.H[n][n]) / PrimitiveMath.TWO;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                this.H[n][n] = this.H[n][n] + exshift;
                this.H[n - 1][n - 1] = this.H[n - 1][n - 1] + exshift;
                x = this.H[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != PrimitiveMath.ZERO) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = PrimitiveMath.ZERO;
                    this.e[n] = PrimitiveMath.ZERO;
                    x = this.H[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = this.H[n - 1][j];
                        this.H[n - 1][j] = q * z + p * this.H[n][j];
                        this.H[n][j] = q * this.H[n][j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this.H[i][n - 1];
                        this.H[i][n - 1] = q * z + p * this.H[i][n];
                        this.H[i][n] = q * this.H[i][n] - p * z;
                    }
                    for (i = 0; i <= high; ++i) {
                        z = this.Vt[n - 1][i];
                        this.Vt[n - 1][i] = q * z + p * this.Vt[n][i];
                        this.Vt[n][i] = q * this.Vt[n][i] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H[n][n];
            y = PrimitiveMath.ZERO;
            w = PrimitiveMath.ZERO;
            if (l < n) {
                y = this.H[n - 1][n - 1];
                w = this.H[n][n - 1] * this.H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = 0;
                while (i <= n) {
                    double[] dArray = this.H[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / PrimitiveMath.TWO;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / PrimitiveMath.TWO + s);
                    i = 0;
                    while (i <= n) {
                        double[] dArray = this.H[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.H[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H[m + 1][m] + this.H[m][m + 1];
                q = this.H[m + 1][m + 1] - z - r - s;
                r = this.H[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.H[m + 1][m + 1])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                this.H[i3][i3 - 2] = PrimitiveMath.ZERO;
                if (i3 <= m + 2) continue;
                this.H[i3][i3 - 3] = PrimitiveMath.ZERO;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H[k][k - 1];
                    q = this.H[k + 1][k - 1];
                    r = notlast ? this.H[k + 2][k - 1] : PrimitiveMath.ZERO;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x == PrimitiveMath.ZERO) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.H[k][k - 1] = -s * x;
                } else if (l != m) {
                    this.H[k][k - 1] = -this.H[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = this.H[k][j3] + q * this.H[k + 1][j3];
                    if (notlast) {
                        this.H[k + 2][j3] = this.H[k + 2][j3] - (p += r * this.H[k + 2][j3]) * z;
                    }
                    this.H[k][j3] = this.H[k][j3] - p * x;
                    this.H[k + 1][j3] = this.H[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * this.H[i4][k] + y * this.H[i4][k + 1];
                    if (notlast) {
                        this.H[i4][k + 2] = this.H[i4][k + 2] - (p += z * this.H[i4][k + 2]) * r;
                    }
                    this.H[i4][k] = this.H[i4][k] - p;
                    this.H[i4][k + 1] = this.H[i4][k + 1] - p * q;
                }
                for (i4 = 0; i4 <= high; ++i4) {
                    p = x * this.Vt[k][i4] + y * this.Vt[k + 1][i4];
                    if (notlast) {
                        this.Vt[k + 2][i4] = this.Vt[k + 2][i4] - (p += z * this.Vt[k + 2][i4]) * r;
                    }
                    this.Vt[k][i4] = this.Vt[k][i4] - p;
                    this.Vt[k + 1][i4] = this.Vt[k + 1][i4] - p * q;
                }
            }
        }
        if (norm == PrimitiveMath.ZERO) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H[n][n] = PrimitiveMath.ONE;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = this.H[i][i] - p;
                    r = PrimitiveMath.ZERO;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this.H[i][j4] * this.H[j4][n];
                    }
                    if (this.e[i] < PrimitiveMath.ZERO) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == PrimitiveMath.ZERO) {
                        this.H[i][n] = w != PrimitiveMath.ZERO ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.H[i][i + 1];
                        y = this.H[i + 1][i];
                        q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                        this.H[i][n] = t = (x * s - z * r) / q;
                        this.H[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(this.H[i][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        this.H[j4][n] = this.H[j4][n] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
            } else {
                this.cdiv(PrimitiveMath.ZERO, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                this.H[n - 1][n - 1] = this.cdivr;
                this.H[n - 1][n] = this.cdivi;
            }
            this.H[n][n - 1] = PrimitiveMath.ZERO;
            this.H[n][n] = PrimitiveMath.ONE;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = PrimitiveMath.ZERO;
                double sa = PrimitiveMath.ZERO;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this.H[i][j5] * this.H[j5][n - 1];
                    sa += this.H[i][j5] * this.H[j5][n];
                }
                w = this.H[i][i] - p;
                if (this.e[i] < PrimitiveMath.ZERO) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (this.e[i] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.H[i][n - 1] = this.cdivr;
                    this.H[i][n] = this.cdivi;
                } else {
                    double vi;
                    x = this.H[i][i + 1];
                    y = this.H[i + 1][i];
                    double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                    if (vr == PrimitiveMath.ZERO & (vi = (this.d[i] - p) * PrimitiveMath.TWO * q) == PrimitiveMath.ZERO) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this.H[i][n - 1] = this.cdivr;
                    this.H[i][n] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.H[i + 1][n - 1] = (-ra - w * this.H[i][n - 1] + q * this.H[i][n]) / x;
                        this.H[i + 1][n] = (-sa - w * this.H[i][n] - q * this.H[i][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this.H[i][n - 1], -s - y * this.H[i][n], z, q);
                        this.H[i + 1][n - 1] = this.cdivr;
                        this.H[i + 1][n] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.H[i][n - 1]), Math.abs(this.H[i][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    this.H[j5][n - 1] = this.H[j5][n - 1] / t;
                    this.H[j5][n] = this.H[j5][n] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < 0 | i5 > high)) continue;
            for (j = i5; j < nn; ++j) {
                this.Vt[j][i5] = this.H[i5][j];
            }
        }
        for (j2 = nn - 1; j2 >= 0; --j2) {
            for (i = 0; i <= high; ++i) {
                z = PrimitiveMath.ZERO;
                for (int k = 0; k <= Math.min(j2, high); ++k) {
                    z += this.Vt[k][i] * this.H[k][j2];
                }
                this.Vt[j2][i] = z;
            }
        }
    }

    private void orthes() {
        int m;
        boolean low = false;
        int high = this.n - 1;
        double[] ort = new double[this.n];
        for (m = 1; m <= high - 1; ++m) {
            double f;
            double scale = PrimitiveMath.ZERO;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.H[i][m - 1]);
            }
            if (scale == PrimitiveMath.ZERO) continue;
            double h = PrimitiveMath.ZERO;
            for (int i = high; i >= m; --i) {
                ort[i] = this.H[i][m - 1] / scale;
                h += ort[i] * ort[i];
            }
            double g = Math.sqrt(h);
            if (ort[m] > 0.0) {
                g = -g;
            }
            h -= ort[m] * g;
            ort[m] = ort[m] - g;
            for (int j = m; j < this.n; ++j) {
                int i;
                f = PrimitiveMath.ZERO;
                for (i = high; i >= m; --i) {
                    f += ort[i] * this.H[i][j];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.H[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = PrimitiveMath.ZERO;
                for (j = high; j >= m; --j) {
                    f += ort[j] * this.H[i][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this.H[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * ort[j];
                }
            }
            ort[m] = scale * ort[m];
            this.H[m][m - 1] = scale * g;
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.Vt[j][i] = i == j ? PrimitiveMath.ONE : PrimitiveMath.ZERO;
            }
        }
        for (m = high - 1; m >= 1; --m) {
            if (this.H[m][m - 1] == PrimitiveMath.ZERO) continue;
            for (int i = m + 1; i <= high; ++i) {
                ort[i] = this.H[i][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = PrimitiveMath.ZERO;
                for (i = m; i <= high; ++i) {
                    g += ort[i] * this.Vt[j][i];
                }
                g = g / ort[m] / this.H[m][m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.Vt[j];
                    int n = i;
                    dArray[n] = dArray[n] + g * ort[i];
                }
            }
        }
    }

    private void rot1(double[] tmpVt_i, double[] tmpVt_i1, double c, double s) {
        for (int k = 0; k < this.n; ++k) {
            double h = tmpVt_i1[k];
            tmpVt_i1[k] = s * tmpVt_i[k] + c * h;
            tmpVt_i[k] = c * tmpVt_i[k] - s * h;
        }
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = PrimitiveMath.ZERO;
        double f = PrimitiveMath.ZERO;
        double tst1 = PrimitiveMath.ZERO;
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= PrimitiveMath.MACHINE_EPSILON * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (PrimitiveMath.TWO * this.e[l]);
                    double r = Maths.hypot(p, PrimitiveMath.ONE);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = PrimitiveMath.ONE;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = PrimitiveMath.ZERO;
                    double s2 = PrimitiveMath.ZERO;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = Maths.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        this.rot1(this.Vt[i2], this.Vt[i2 + 1], c, s);
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > PrimitiveMath.MACHINE_EPSILON * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = PrimitiveMath.ZERO;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int k = i;
            double p = this.d[i];
            for (int j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            double[] tmpCol = this.Vt[i];
            this.Vt[i] = this.Vt[k];
            this.Vt[k] = tmpCol;
        }
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        return null;
    }

    abstract boolean doDecompose(double[][] var1);

    void doDecomposeGeneral(double[][] data) {
        this.n = data.length;
        this.Vt = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.H = data;
        this.orthes();
        this.hqr2();
    }

    void doDecomposeSymmetric(double[][] data) {
        this.n = data.length;
        this.Vt = data;
        this.d = new double[this.n];
        this.e = new double[this.n];
        HouseholderHermitian.tred2jj(this.Vt, this.d, this.e, true);
        this.tql2();
    }

    double[] getImagEigenvalues() {
        return this.e;
    }

    double[] getRealEigenvalues() {
        return this.d;
    }

    static final class Symmetric
    extends RawEigenvalue
    implements MatrixDecomposition.Solver<Double> {
        Symmetric() {
        }

        @Override
        public boolean isHermitian() {
            return true;
        }

        @Override
        boolean doDecompose(double[][] data) {
            this.doDecomposeSymmetric(data);
            return this.computed(true);
        }
    }

    static final class General
    extends RawEigenvalue {
        General() {
        }

        @Override
        public boolean isHermitian() {
            return false;
        }

        @Override
        boolean doDecompose(double[][] data) {
            this.doDecomposeGeneral(data);
            return this.computed(true);
        }
    }

    static final class Dynamic
    extends RawEigenvalue {
        Dynamic() {
        }

        @Override
        public boolean isHermitian() {
            return this.checkSymmetry();
        }

        @Override
        boolean doDecompose(double[][] data) {
            if (this.checkSymmetry()) {
                this.doDecomposeSymmetric(data);
            } else {
                this.doDecomposeGeneral(data);
            }
            return this.computed(true);
        }
    }
}

