/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Maths;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.matrix.store.operation.SubtractScaledVector;
import org.ojalgo.type.context.NumberContext;

final class RawQR
extends RawDecomposition
implements QR<Double> {
    private double[] myDiagonalR;
    private boolean myFullSize = false;

    RawQR() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, true);
        ((MatrixStore.Builder)MatrixStore.PRIMITIVE.makeWrapper(matrix).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(retVal);
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        double[][] retVal = this.reset(matrix, true);
        matrix.transpose().supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(retVal);
    }

    @Override
    public boolean equals(MatrixStore<Double> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public Double getDeterminant() {
        AggregatorFunction<Double> tmpAggrFunc = PrimitiveAggregator.getSet().product();
        this.getR().visitDiagonal(0L, 0L, tmpAggrFunc);
        return tmpAggrFunc.getNumber();
    }

    public RawStore getQ() {
        int m = this.getRowDim();
        int n = this.getColDim();
        double[][] tmpData = this.getRawInPlaceData();
        RawStore retVal = new RawStore(m, n);
        double[][] retData = retVal.data;
        for (int k = n - 1; k >= 0; --k) {
            for (int i = 0; i < m; ++i) {
                retData[i][k] = PrimitiveMath.ZERO;
            }
            retData[k][k] = PrimitiveMath.ONE;
            for (int j = k; j < n; ++j) {
                int i;
                if (tmpData[k][k] == 0.0) continue;
                double s = PrimitiveMath.ZERO;
                for (i = k; i < m; ++i) {
                    s += tmpData[k][i] * retData[i][j];
                }
                s = -s / tmpData[k][k];
                for (i = k; i < m; ++i) {
                    double[] dArray = retData[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + s * tmpData[k][i];
                }
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getR() {
        int tmpColDim = this.getColDim();
        double[][] tmpData = this.getRawInPlaceData();
        RawStore retVal = new RawStore(tmpColDim, tmpColDim);
        double[][] retData = retVal.data;
        for (int i = 0; i < tmpColDim; ++i) {
            double[] tmpRow = retData[i];
            tmpRow[i] = this.myDiagonalR[i];
            for (int j = i + 1; j < tmpColDim; ++j) {
                tmpRow[j] = tmpData[j][i];
            }
        }
        return retVal;
    }

    @Override
    public int getRank() {
        int retVal = 0;
        MatrixStore<Double> tmpR = this.getR();
        int tmpMinDim = (int)Math.min(tmpR.countRows(), tmpR.countColumns());
        AggregatorFunction<Double> tmpLargest = PrimitiveAggregator.LARGEST.get();
        tmpR.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpR.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public final MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(MatrixStore.PRIMITIVE.makeWrapper(original), true);
        ((MatrixStore.Builder)MatrixStore.PRIMITIVE.makeWrapper(original).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(tmpData);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isFullColumnRank() {
        int n = this.getColDim();
        for (int j = 0; j < n; ++j) {
            if (this.myDiagonalR[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isSolvable() {
        return this.isFullColumnRank();
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }

    @Override
    public void setFullSize(boolean fullSize) {
        this.myFullSize = fullSize;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(body, true);
        ((MatrixStore.Builder)MatrixStore.PRIMITIVE.makeWrapper(body).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(tmpData);
        preallocated.fillMatching(rhs);
        return this.doSolve((PrimitiveDenseStore)preallocated);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve((PrimitiveDenseStore)preallocated);
    }

    @Override
    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        return this.solve((Access2D<?>)rhs, (Access2D<?>)preallocated);
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        MatrixStore.PRIMITIVE.makeIdentity(this.getRowDim()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    boolean doDecompose(double[][] data) {
        int m = this.getRowDim();
        int n = this.getColDim();
        this.myDiagonalR = new double[n];
        for (int k = 0; k < n; ++k) {
            int i;
            double[] tmpColK = data[k];
            double nrm = PrimitiveMath.ZERO;
            for (i = k; i < m; ++i) {
                nrm = Maths.hypot(nrm, tmpColK[i]);
            }
            if (nrm != PrimitiveMath.ZERO) {
                if (tmpColK[k] < 0.0) {
                    nrm = -nrm;
                }
                i = k;
                while (i < m) {
                    int n2 = i++;
                    tmpColK[n2] = tmpColK[n2] / nrm;
                }
                int n3 = k;
                tmpColK[n3] = tmpColK[n3] + PrimitiveMath.ONE;
                for (int j = k + 1; j < n; ++j) {
                    SubtractScaledVector.invoke(data[j], 0, tmpColK, 0, DotProduct.invoke(tmpColK, 0, data[j], 0, k, m) / tmpColK[k], k, m);
                }
            }
            this.myDiagonalR[k] = -nrm;
        }
        return this.computed(true);
    }

    MatrixStore<Double> doSolve(PrimitiveDenseStore preallocated) {
        double[] tmpColK;
        int k;
        double[] tmpRHSdata = preallocated.data;
        int m = this.getRowDim();
        int n = this.getColDim();
        int s = (int)preallocated.countColumns();
        if ((int)preallocated.countRows() != m) {
            throw new IllegalArgumentException("RawStore row dimensions must agree.");
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("RawStore is rank deficient.");
        }
        double[][] tmpData = this.getRawInPlaceData();
        for (k = 0; k < n; ++k) {
            tmpColK = tmpData[k];
            for (int j = 0; j < s; ++j) {
                double tmpVal = DotProduct.invoke(tmpColK, 0, tmpRHSdata, m * j, k, m);
                SubtractScaledVector.invoke(tmpRHSdata, m * j, tmpColK, 0, tmpVal / tmpColK[k], k, m);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            tmpColK = tmpData[k];
            double tmpDiagK = this.myDiagonalR[k];
            for (int j = 0; j < s; ++j) {
                int n2 = k + j * m;
                tmpRHSdata[n2] = tmpRHSdata[n2] / tmpDiagK;
                SubtractScaledVector.invoke(tmpRHSdata, j * m, tmpColK, 0, tmpRHSdata[k + j * m], 0, k);
            }
        }
        return preallocated.builder().rows(0, n).build();
    }
}

