/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.Schur;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class SchurDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Schur<N> {
    private Array1D<ComplexNumber> myDiagonal;
    private MatrixStore<N> myQ;

    protected SchurDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public boolean decompose(ElementsSupplier<N> matrix) {
        this.reset();
        this.setInPlace(matrix);
        int tmpDiagDim = this.getMinDim();
        DecompositionStore tmpQ = this.makeEye(tmpDiagDim, tmpDiagDim);
        Array1D<ComplexNumber> tmpDiagonal = this.getInPlace().computeInPlaceSchur(tmpQ, false);
        this.setQ(tmpQ);
        this.setDiagonal(tmpDiagonal);
        return this.computed(true);
    }

    @Override
    public boolean equals(MatrixStore<N> other, NumberContext context) {
        return MatrixUtils.equals(other, this, context);
    }

    @Override
    public Array1D<ComplexNumber> getDiagonal() {
        return this.myDiagonal;
    }

    @Override
    public MatrixStore<N> getQ() {
        return this.myQ;
    }

    @Override
    public MatrixStore<N> getU() {
        return this.getInPlace().builder().hessenberg(true).build();
    }

    public boolean isFullSize() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public boolean isSolvable() {
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.myDiagonal = null;
        this.myQ = null;
    }

    public MatrixStore<N> solve(Access2D<N> rhs, DecompositionStore<N> preallocated) {
        throw new UnsupportedOperationException();
    }

    final void setDiagonal(Array1D<ComplexNumber> newDiagonal) {
        this.myDiagonal = newDiagonal;
    }

    final void setQ(MatrixStore<N> newQ) {
        this.myQ = newQ;
    }

    static final class Primitive
    extends SchurDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    public static final class SchurResult<N extends Number> {
        private final Array1D<ComplexNumber> myDiagonal;
        private final MatrixStore<N> myQ;

        public SchurResult(Array1D<ComplexNumber> aDiagonal, MatrixStore<N> aQ) {
            this.myDiagonal = aDiagonal;
            this.myQ = aQ;
        }

        private SchurResult() {
            this(null, null);
        }

        public final Array1D<ComplexNumber> getDiagonal() {
            return this.myDiagonal;
        }

        public final MatrixStore<N> getQ() {
            return this.myQ;
        }
    }
}

