/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.scalar.Scalar;

final class ConjugatedStore<N extends Number>
extends TransjugatedStore<N> {
    ConjugatedStore(MatrixStore<N> aBase) {
        super(aBase);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this.getBase();
    }

    @Override
    public N get(long aRow, long aCol) {
        return ((Scalar)this.getBase().toScalar((int)aCol, (int)aRow).conjugate()).getNumber();
    }

    @Override
    public MatrixStore<N> multiply(Access1D<N> right) {
        MatrixStore<Access1D<N>> retVal;
        if (right instanceof ConjugatedStore) {
            retVal = ((ConjugatedStore)right).getOriginal().multiply(this.getBase());
            retVal = new ConjugatedStore<Access1D<Access1D<N>>>(retVal);
        } else {
            retVal = super.multiply(right);
        }
        return retVal;
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return (Scalar)this.getBase().toScalar(column, row).conjugate();
    }
}

