/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.AboveBelowStore;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.BinaryOperatorSupplier;
import org.ojalgo.matrix.store.ColumnsStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.IdentityStore;
import org.ojalgo.matrix.store.LeftRightStore;
import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.LowerHermitianStore;
import org.ojalgo.matrix.store.LowerHessenbergStore;
import org.ojalgo.matrix.store.LowerTriangularStore;
import org.ojalgo.matrix.store.MatrixProductSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RowsStore;
import org.ojalgo.matrix.store.SingleStore;
import org.ojalgo.matrix.store.SuperimposedStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.UnaryOperatorSupplier;
import org.ojalgo.matrix.store.UpperHermitianStore;
import org.ojalgo.matrix.store.UpperHessenbergStore;
import org.ojalgo.matrix.store.UpperTriangularStore;
import org.ojalgo.matrix.store.WrapperStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public interface MatrixStore<N extends Number>
extends Access2D<N>,
Access2D.Elements,
Access2D.Visitable<N>,
Access2D.Sliceable<N>,
NormedVectorSpace<MatrixStore<N>, N>,
ElementsSupplier<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public Builder<BigDecimal> makeIdentity(int dimension) {
            return new Builder<BigDecimal>(new IdentityStore<BigDecimal>(BigDenseStore.FACTORY, dimension));
        }

        @Override
        public Builder<BigDecimal> makeSingle(BigDecimal element) {
            return new Builder<BigDecimal>(new SingleStore<BigDecimal>(BigDenseStore.FACTORY, element));
        }

        @Override
        public Builder<BigDecimal> makeWrapper(Access2D<?> access) {
            return new Builder<BigDecimal>(new WrapperStore<BigDecimal>(BigDenseStore.FACTORY, access));
        }

        @Override
        public Builder<BigDecimal> makeZero(int rowsCount, int columnsCount) {
            return new Builder<BigDecimal>(new ZeroStore<BigDecimal>(BigDenseStore.FACTORY, rowsCount, columnsCount));
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public Builder<ComplexNumber> makeIdentity(int dimension) {
            return new Builder<ComplexNumber>(new IdentityStore<ComplexNumber>(ComplexDenseStore.FACTORY, dimension));
        }

        @Override
        public Builder<ComplexNumber> makeSingle(ComplexNumber element) {
            return new Builder<ComplexNumber>(new SingleStore<ComplexNumber>(ComplexDenseStore.FACTORY, element));
        }

        @Override
        public Builder<ComplexNumber> makeWrapper(Access2D<?> access) {
            return new Builder<ComplexNumber>(new WrapperStore<ComplexNumber>(ComplexDenseStore.FACTORY, access));
        }

        @Override
        public Builder<ComplexNumber> makeZero(int rowsCount, int columnsCount) {
            return new Builder<ComplexNumber>(new ZeroStore<ComplexNumber>(ComplexDenseStore.FACTORY, rowsCount, columnsCount));
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public Builder<Double> makeIdentity(int dimension) {
            return new Builder<Double>(new IdentityStore<Double>(PrimitiveDenseStore.FACTORY, dimension));
        }

        @Override
        public Builder<Double> makeSingle(Double element) {
            return new Builder<Double>(new SingleStore<Double>(PrimitiveDenseStore.FACTORY, element));
        }

        @Override
        public Builder<Double> makeWrapper(Access2D<?> access) {
            return new Builder<Double>(new WrapperStore<Double>(PrimitiveDenseStore.FACTORY, access));
        }

        @Override
        public Builder<Double> makeZero(int rowsCount, int columnsCount) {
            return new Builder<Double>(new ZeroStore<Double>(PrimitiveDenseStore.FACTORY, rowsCount, columnsCount));
        }
    };

    @Override
    default public MatrixStore<N> add(MatrixStore<N> addend) {
        return this.operateOnMatching(this.factory().function().add(), addend).get();
    }

    public N aggregateAll(Aggregator var1);

    public Builder<N> builder();

    @Override
    default public MatrixStore<N> conjugate() {
        return new ConjugatedStore(this);
    }

    public PhysicalStore<N> copy();

    public boolean equals(MatrixStore<N> var1, NumberContext var2);

    default public int firstInColumn(int col) {
        return 0;
    }

    default public int firstInRow(int row) {
        return 0;
    }

    @Override
    default public MatrixStore<N> get() {
        return this;
    }

    @Deprecated
    default public boolean isLowerLeftShaded() {
        return false;
    }

    @Override
    default public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.norm());
    }

    @Deprecated
    default public boolean isUpperRightShaded() {
        return false;
    }

    default public int limitOfColumn(int col) {
        return (int)this.countRows();
    }

    default public int limitOfRow(int row) {
        return (int)this.countColumns();
    }

    @Override
    default public MatrixStore<N> multiply(Access1D<N> right) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = right.count() / this.countColumns();
        PhysicalStore retVal = (PhysicalStore)this.factory().makeZero(tmpCountRows, tmpCountColumns);
        this.multiply(right, retVal);
        return retVal;
    }

    default public PhysicalStore<N> multiply(Access1D<N> right, PhysicalStore<N> target) {
        target.fillByMultiplying(this, right);
        return target;
    }

    @Override
    default public MatrixStore<N> multiply(double scalar) {
        return this.multiply((Number)this.factory().scalar().cast(scalar));
    }

    @Override
    default public MatrixStore<N> multiply(N scalar) {
        return this.operateOnAll(this.factory().function().multiply().second(scalar)).get();
    }

    public N multiplyBoth(Access1D<N> var1);

    default public ElementsSupplier<N> multiplyLeft(Access1D<N> left) {
        return new MatrixProductSupplier<N>(left, this);
    }

    @Override
    default public MatrixStore<N> negate() {
        return this.operateOnAll(this.factory().function().negate()).get();
    }

    @Override
    default public double norm() {
        return ((Number)this.aggregateAll(Aggregator.NORM2)).doubleValue();
    }

    @Override
    default public ElementsSupplier<N> operateOnAll(UnaryFunction<N> operator) {
        return new UnaryOperatorSupplier<N>(operator, this);
    }

    @Override
    default public ElementsSupplier<N> operateOnMatching(BinaryFunction<N> operator, MatrixStore<N> right) {
        return new BinaryOperatorSupplier<N>(this, operator, right);
    }

    @Override
    default public ElementsSupplier<N> operateOnMatching(MatrixStore<N> left, BinaryFunction<N> operator) {
        return new BinaryOperatorSupplier<N>(left, operator, this);
    }

    @Deprecated
    default public MatrixStore<N> scale(N scalar) {
        return this.multiply((Number)scalar);
    }

    @Override
    default public MatrixStore<N> signum() {
        return this.multiply(PrimitiveMath.ONE / this.norm());
    }

    @Override
    default public Access1D<N> sliceColumn(final long row, final long column) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countRows() - row;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, column);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, column);
            }
        };
    }

    @Override
    default public Access1D<N> sliceDiagonal(final long row, final long column) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return Math.min(MatrixStore.this.countRows() - row, MatrixStore.this.countColumns() - column);
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, column + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, column + index);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRange(final long first, final long limit) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return limit - first;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(first + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(first + index);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRow(final long row, final long column) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countColumns() - column;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row, column + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row, column + index);
            }
        };
    }

    default public MatrixStore<N> subtract(MatrixStore<N> subtrahend) {
        return this.operateOnMatching(this.factory().function().subtract(), subtrahend).get();
    }

    default public Scalar<N> toScalar(long row, long column) {
        return this.factory().scalar().convert((Number)this.get(row, column));
    }

    @Override
    default public MatrixStore<N> transpose() {
        return new TransposedStore(this);
    }

    @Override
    default public void visitOne(long row, long column, VoidFunction<N> visitor) {
        visitor.invoke(this.get(row, column));
    }

    public static interface Factory<N extends Number> {
        public Builder<N> makeIdentity(int var1);

        public Builder<N> makeSingle(N var1);

        public Builder<N> makeWrapper(Access2D<?> var1);

        public Builder<N> makeZero(int var1, int var2);
    }

    public static final class Builder<N extends Number>
    implements ElementsSupplier<N> {
        private MatrixStore<N> myStore;

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildColumn(int aMinRowDim, MatrixStore<N> ... aColStore) {
            MatrixStore<N> retVal = aColStore[0];
            for (int i = 1; i < aColStore.length; ++i) {
                retVal = new AboveBelowStore<N>(retVal, aColStore[i]);
            }
            int tmpRowDim = (int)retVal.countRows();
            if (tmpRowDim < aMinRowDim) {
                retVal = new AboveBelowStore<N>(retVal, new ZeroStore(retVal.factory(), aMinRowDim - tmpRowDim, (int)retVal.countColumns()));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildColumn(PhysicalStore.Factory<N, ?> factory, int aMinRowDim, N ... aColStore) {
            AboveBelowStore<N> retVal = (AboveBelowStore<N>)factory.columns(new Number[][]{aColStore});
            int tmpRowDim = (int)retVal.countRows();
            if (tmpRowDim < aMinRowDim) {
                retVal = new AboveBelowStore<N>(retVal, new ZeroStore<N>(factory, aMinRowDim - tmpRowDim, (int)retVal.countColumns()));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildRow(int aMinColDim, MatrixStore<N> ... aRowStore) {
            MatrixStore<N> retVal = aRowStore[0];
            for (int j = 1; j < aRowStore.length; ++j) {
                retVal = new LeftRightStore<N>(retVal, aRowStore[j]);
            }
            int tmpColDim = (int)retVal.countColumns();
            if (tmpColDim < aMinColDim) {
                retVal = new LeftRightStore<N>(retVal, new ZeroStore(retVal.factory(), (int)retVal.countRows(), aMinColDim - tmpColDim));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildRow(PhysicalStore.Factory<N, ?> factory, int aMinColDim, N ... aRowStore) {
            LogicalStore retVal = new TransposedStore((MatrixStore)factory.columns(new Number[][]{aRowStore}));
            int tmpColDim = (int)retVal.countColumns();
            if (tmpColDim < aMinColDim) {
                retVal = new LeftRightStore(retVal, new ZeroStore<N>(factory, (int)retVal.countRows(), aMinColDim - tmpColDim));
            }
            return retVal;
        }

        private Builder() {
            this(null);
            ProgrammingError.throwForIllegalInvocation();
        }

        Builder(MatrixStore<N> matrixStore) {
            this.myStore = matrixStore;
        }

        public final Builder<N> above(int aRowDim) {
            ZeroStore tmpUpperStore = new ZeroStore(this.myStore.factory(), aRowDim, (int)this.myStore.countColumns());
            this.myStore = new AboveBelowStore(tmpUpperStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> above(MatrixStore<N> ... upperStore) {
            MatrixStore<N> tmpUpperStore = Builder.buildRow((int)this.myStore.countColumns(), upperStore);
            this.myStore = new AboveBelowStore<N>(tmpUpperStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> above(N ... anUpperStore) {
            MatrixStore tmpUpperStore = Builder.buildRow(this.myStore.factory(), (int)((int)this.myStore.countColumns()), anUpperStore);
            this.myStore = new AboveBelowStore<N>(tmpUpperStore, this.myStore);
            return this;
        }

        public final Builder<N> below(int aRowDim) {
            ZeroStore tmpLowerStore = new ZeroStore(this.myStore.factory(), aRowDim, (int)this.myStore.countColumns());
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> below(MatrixStore<N> ... aLowerStore) {
            MatrixStore<N> tmpLowerStore = Builder.buildRow((int)this.myStore.countColumns(), aLowerStore);
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> below(N ... aLowerStore) {
            MatrixStore tmpLowerStore = Builder.buildRow(this.myStore.factory(), (int)((int)this.myStore.countColumns()), aLowerStore);
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        public final Builder<N> bidiagonal(boolean upper, boolean assumeOne) {
            this.myStore = upper ? new UpperTriangularStore<N>(new LowerHessenbergStore<N>(this.myStore), assumeOne) : new LowerTriangularStore<N>(new UpperHessenbergStore<N>(this.myStore), assumeOne);
            return this;
        }

        public final MatrixStore<N> build() {
            return this.myStore;
        }

        public final Builder<N> column(int ... col) {
            this.myStore = new ColumnsStore<N>(this.myStore, col);
            return this;
        }

        public final Builder<N> columns(int aFirst, int aLimit) {
            this.myStore = new ColumnsStore<N>(aFirst, aLimit, this.myStore);
            return this;
        }

        public final Builder<N> conjugate() {
            this.myStore = this.myStore instanceof ConjugatedStore ? ((ConjugatedStore)this.myStore).getOriginal() : new ConjugatedStore<N>(this.myStore);
            return this;
        }

        public final PhysicalStore<N> copy() {
            return this.myStore.copy();
        }

        @Override
        public final long count() {
            return this.myStore.count();
        }

        @Override
        public final long countColumns() {
            return this.myStore.countColumns();
        }

        @Override
        public final long countRows() {
            return this.myStore.countRows();
        }

        public final Builder<N> diagonal(boolean assumeOne) {
            this.myStore = new UpperTriangularStore<N>(new LowerTriangularStore<N>(this.myStore, assumeOne), assumeOne);
            return this;
        }

        @SafeVarargs
        public final Builder<N> diagonally(MatrixStore<N> ... aDiagonalStore) {
            PhysicalStore.Factory tmpFactory = this.myStore.factory();
            for (int ij = 0; ij < aDiagonalStore.length; ++ij) {
                MatrixStore<N> tmpDiagonalStore = aDiagonalStore[ij];
                int tmpBaseRowDim = (int)this.myStore.countRows();
                int tmpBaseColDim = (int)this.myStore.countColumns();
                int tmpDiagRowDim = (int)tmpDiagonalStore.countRows();
                int tmpDiagColDim = (int)tmpDiagonalStore.countColumns();
                ZeroStore tmpRightStore = new ZeroStore(tmpFactory, tmpBaseRowDim, tmpDiagColDim);
                LeftRightStore<N> tmpAboveStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
                ZeroStore tmpLeftStore = new ZeroStore(tmpFactory, tmpDiagRowDim, tmpBaseColDim);
                LeftRightStore tmpBelowStore = new LeftRightStore(tmpLeftStore, tmpDiagonalStore);
                this.myStore = new AboveBelowStore<N>(tmpAboveStore, tmpBelowStore);
            }
            return this;
        }

        @Override
        public PhysicalStore.Factory<N, ?> factory() {
            return this.myStore.factory();
        }

        @Override
        public final MatrixStore<N> get() {
            return this.myStore;
        }

        public final Builder<N> hermitian(boolean upper) {
            this.myStore = upper ? new UpperHermitianStore<N>(this.myStore) : new LowerHermitianStore<N>(this.myStore);
            return this;
        }

        public final Builder<N> hessenberg(boolean upper) {
            this.myStore = upper ? new UpperHessenbergStore<N>(this.myStore) : new LowerHessenbergStore<N>(this.myStore);
            return this;
        }

        public final Builder<N> left(int aColDim) {
            ZeroStore tmpLeftStore = new ZeroStore(this.myStore.factory(), (int)this.myStore.countRows(), aColDim);
            this.myStore = new LeftRightStore(tmpLeftStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> left(MatrixStore<N> ... aLeftStore) {
            MatrixStore<N> tmpLeftStore = Builder.buildColumn((int)this.myStore.countRows(), aLeftStore);
            this.myStore = new LeftRightStore<N>(tmpLeftStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> left(N ... aLeftStore) {
            MatrixStore tmpLeftStore = Builder.buildColumn(this.myStore.factory(), (int)((int)this.myStore.countRows()), aLeftStore);
            this.myStore = new LeftRightStore<N>(tmpLeftStore, this.myStore);
            return this;
        }

        public final Builder<N> right(int aColDim) {
            ZeroStore tmpRightStore = new ZeroStore(this.myStore.factory(), (int)this.myStore.countRows(), aColDim);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> right(MatrixStore<N> ... aRightStore) {
            MatrixStore<N> tmpRightStore = Builder.buildColumn((int)this.myStore.countRows(), aRightStore);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        @SafeVarargs
        public final Builder<N> right(N ... aRightStore) {
            MatrixStore tmpRightStore = Builder.buildColumn(this.myStore.factory(), (int)((int)this.myStore.countRows()), aRightStore);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        public final Builder<N> row(int ... row) {
            this.myStore = new RowsStore<N>(this.myStore, row);
            return this;
        }

        public final Builder<N> rows(int aFirst, int aLimit) {
            this.myStore = new RowsStore<N>(aFirst, aLimit, this.myStore);
            return this;
        }

        public final Builder<N> superimpose(int row, int col, MatrixStore<N> aStore) {
            this.myStore = new SuperimposedStore<N>(this.myStore, row, col, aStore);
            return this;
        }

        public final Builder<N> superimpose(int row, int col, Number aStore) {
            this.myStore = new SuperimposedStore<N>(this.myStore, row, col, new SingleStore(this.myStore.factory(), aStore));
            return this;
        }

        public final Builder<N> superimpose(MatrixStore<N> aStore) {
            this.myStore = new SuperimposedStore<N>(this.myStore, 0, 0, aStore);
            return this;
        }

        @Override
        public final void supplyTo(ElementsConsumer<N> consumer) {
            if (!consumer.isAcceptable(this)) {
                throw new ProgrammingError("Not acceptable!");
            }
            consumer.accept((Access2D<N>)this.get());
        }

        public String toString() {
            return this.myStore.toString();
        }

        @Override
        public final Builder<N> transpose() {
            this.myStore = this.myStore instanceof TransposedStore ? ((TransposedStore)this.myStore).getOriginal() : new TransposedStore<N>(this.myStore);
            return this;
        }

        public final Builder<N> triangular(boolean upper, boolean assumeOne) {
            this.myStore = upper ? new UpperTriangularStore<N>(this.myStore, assumeOne) : new LowerTriangularStore<N>(this.myStore, assumeOne);
            return this;
        }

        public final Builder<N> tridiagonal() {
            this.myStore = new UpperHessenbergStore<N>(new LowerHessenbergStore<N>(this.myStore));
            return this;
        }
    }
}

