/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;

public final class SparseStore<N extends Number>
extends FactoryStore<N>
implements Access2D.Settable<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public SparseStore<BigDecimal> make(long rowsCount, long columnsCount) {
            return SparseStore.makeBig((int)rowsCount, (int)columnsCount);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public SparseStore<ComplexNumber> make(long rowsCount, long columnsCount) {
            return SparseStore.makeComplex((int)rowsCount, (int)columnsCount);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public SparseStore<Double> make(long rowsCount, long columnsCount) {
            return SparseStore.makePrimitive((int)rowsCount, (int)columnsCount);
        }
    };
    private final SparseArray<N> myElements;
    private final int[] myFirsts;
    private final int[] myLimits;

    public static SparseStore<BigDecimal> makeBig(int rowsCount, int columnsCount) {
        return new SparseStore<BigDecimal>(BigDenseStore.FACTORY, rowsCount, columnsCount, SparseArray.makeBig(rowsCount * columnsCount));
    }

    public static SparseStore<ComplexNumber> makeComplex(int rowsCount, int columnsCount) {
        return new SparseStore<ComplexNumber>(ComplexDenseStore.FACTORY, rowsCount, columnsCount, SparseArray.makeComplex(rowsCount * columnsCount));
    }

    public static SparseStore<Double> makePrimitive(int rowsCount, int columnsCount) {
        return new SparseStore<Double>(PrimitiveDenseStore.FACTORY, rowsCount, columnsCount, SparseArray.makePrimitive(rowsCount * columnsCount));
    }

    private SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myElements = null;
        this.myFirsts = null;
        this.myLimits = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount, SparseArray<N> elements) {
        super(factory, rowsCount, columnsCount);
        this.myElements = elements;
        this.myFirsts = new int[rowsCount];
        this.myLimits = new int[rowsCount];
        Arrays.fill(this.myFirsts, columnsCount);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myElements.add(AccessUtils.index((long)this.myFirsts.length, row, col), addend);
        this.updateNonZeros(row, col);
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myElements.add(AccessUtils.index((long)this.myFirsts.length, row, col), addend);
        this.updateNonZeros(row, col);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myElements.doubleValue(AccessUtils.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public int firstInColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeFirst = tmpRowDim * col;
        int tmpRangeLimit = tmpRowDim * (col + 1);
        long tmpFirstInRange = this.myElements.firstInRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeFirst == tmpFirstInRange) {
            return 0;
        }
        return (int)(tmpFirstInRange % (long)tmpRowDim);
    }

    @Override
    public int firstInRow(int row) {
        return this.myFirsts[row];
    }

    @Override
    public N get(long row, long col) {
        return this.myElements.get(AccessUtils.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public int limitOfColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeLimit = tmpRowDim * (col + 1);
        int tmpRangeFirst = tmpRowDim * col;
        long tmpLimitOfRange = this.myElements.limitOfRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeLimit == tmpLimitOfRange) {
            return tmpRowDim;
        }
        return (int)tmpLimitOfRange % tmpRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myLimits[row];
    }

    @Override
    public void set(long row, long col, double value) {
        this.myElements.set(AccessUtils.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myElements.set(AccessUtils.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    private void updateNonZeros(long row, long col) {
        this.updateNonZeros((int)row, (int)col);
    }

    @Override
    protected void supplyNonZerosTo(ElementsConsumer<N> consumer) {
        this.myElements.supplyNonZerosTo(consumer);
    }

    void updateNonZeros(int row, int col) {
        this.myFirsts[row] = Math.min(col, this.myFirsts[row]);
        this.myLimits[row] = Math.max(col + 1, this.myLimits[row]);
    }

    public static interface Factory<N extends Number> {
        public SparseStore<N> make(long var1, long var3);
    }
}

