/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;

public final class GenerateApplyAndCopyHouseholderRow
extends MatrixOperation {
    public static final GenerateApplyAndCopyHouseholderRow SETUP = new GenerateApplyAndCopyHouseholderRow();
    public static int THRESHOLD = 128;

    public static boolean invoke(BigDecimal[] data, int structure, int row, int col, Householder.Big destination) {
        int tmpColDim = data.length / structure;
        BigDecimal[] tmpVector = destination.vector;
        destination.first = col;
        BigDecimal tmpNormInf = BigMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = tmpNormInf.max(tmpVector[j].abs());
        }
        boolean retVal = tmpNormInf.signum() != 0;
        BigDecimal tmpNorm2 = BigMath.ZERO;
        if (retVal) {
            for (int j = col + 1; j < tmpColDim; ++j) {
                BigDecimal tmpVal = BigFunction.DIVIDE.invoke(tmpVector[j], tmpNormInf);
                tmpNorm2 = BigFunction.ADD.invoke(tmpNorm2, BigFunction.MULTIPLY.invoke(tmpVal, tmpVal));
                tmpVector[j] = tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2.doubleValue());
        }
        if (retVal) {
            BigDecimal tmpScale = BigFunction.DIVIDE.invoke(tmpVector[col], tmpNormInf);
            tmpNorm2 = BigFunction.ADD.invoke(tmpNorm2, BigFunction.MULTIPLY.invoke(tmpScale, tmpScale));
            tmpNorm2 = BigFunction.SQRT.invoke(tmpNorm2);
            if (tmpScale.signum() != 1) {
                data[row + col * structure] = tmpNorm2.multiply(tmpNormInf);
                tmpScale = BigFunction.SUBTRACT.invoke(tmpScale, tmpNorm2);
            } else {
                data[row + col * structure] = tmpNorm2.negate().multiply(tmpNormInf);
                tmpScale = BigFunction.ADD.invoke(tmpScale, tmpNorm2);
            }
            tmpVector[col] = BigMath.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                data[row + j * structure] = tmpVector[j] = BigFunction.DIVIDE.invoke(tmpVector[j], tmpScale);
            }
            destination.beta = BigFunction.DIVIDE.invoke(tmpScale.abs(), tmpNorm2);
        }
        return retVal;
    }

    public static boolean invoke(ComplexNumber[] data, int structure, int row, int col, Householder.Complex destination) {
        int tmpColDim = data.length / structure;
        ComplexNumber[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = Math.max(tmpNormInf, tmpVector[j].norm());
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            for (int j = col + 1; j < tmpColDim; ++j) {
                ComplexNumber tmpVal = tmpVector[j].divide(tmpNormInf);
                tmpNorm2 += tmpVal.norm() * tmpVal.norm();
                tmpVector[j] = tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2);
        }
        if (retVal) {
            ComplexNumber tmpScale = tmpVector[col].divide(tmpNormInf);
            tmpNorm2 += tmpScale.norm() * tmpScale.norm();
            tmpNorm2 = Math.sqrt(tmpNorm2);
            data[row + col * structure] = ComplexNumber.makePolar(tmpNorm2 * tmpNormInf, tmpScale.phase());
            tmpScale = tmpScale.subtract(ComplexNumber.makePolar(tmpNorm2, tmpScale.phase()));
            tmpVector[col] = ComplexNumber.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                data[row + j * structure] = tmpVector[j] = ComplexFunction.DIVIDE.invoke(tmpVector[j], tmpScale).conjugate();
            }
            destination.beta = ComplexNumber.valueOf(tmpScale.norm() / tmpNorm2);
        }
        return retVal;
    }

    public static boolean invoke(double[] data, int structure, int row, int col, Householder.Primitive destination) {
        int tmpColDim = data.length / structure;
        double[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = Math.max(tmpNormInf, Math.abs(tmpVector[j]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int j = col + 1;
            while (j < tmpColDim) {
                int n = j++;
                double d = tmpVector[n] / tmpNormInf;
                tmpVector[n] = d;
                double tmpVal = d;
                tmpNorm2 += tmpVal * tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2);
        }
        if (retVal) {
            double tmpScale = tmpVector[col] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = Math.sqrt(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + col * structure] = tmpNorm2 * tmpNormInf;
                tmpScale -= tmpNorm2;
            } else {
                data[row + col * structure] = -tmpNorm2 * tmpNormInf;
                tmpScale += tmpNorm2;
            }
            tmpVector[col] = PrimitiveMath.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                int n = j;
                double d = tmpVector[n] / tmpScale;
                tmpVector[n] = d;
                data[row + j * structure] = d;
            }
            destination.beta = Math.abs(tmpScale) / tmpNorm2;
        }
        return retVal;
    }

    private GenerateApplyAndCopyHouseholderRow() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

