/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class SubtractScaledVector
extends MatrixOperation {
    public static final SubtractScaledVector SETUP = new SubtractScaledVector();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int dataIndexBase, BigDecimal[] vector, int vectorIndexBase, BigDecimal scalar, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            data[dataIndexBase + i] = BigFunction.SUBTRACT.invoke(data[dataIndexBase + i], BigFunction.MULTIPLY.invoke(scalar, vector[vectorIndexBase + i]));
        }
    }

    public static void invoke(ComplexNumber[] data, int dataIndexBase, ComplexNumber[] vector, int vectorIndexBase, ComplexNumber scalar, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            data[dataIndexBase + i] = data[dataIndexBase + i].subtract(scalar.multiply(vector[vectorIndexBase + i]));
        }
    }

    public static void invoke(double[] data, int dataIndexBase, double[] vector, int vectorIndexBase, double scalar, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            int n = dataIndexBase + i;
            data[n] = data[n] - scalar * vector[vectorIndexBase + i];
        }
    }

    private SubtractScaledVector() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

