/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.AbstractDeterminator;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;

public interface DeterminantTask<N extends Number>
extends MatrixTask<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public DeterminantTask<BigDecimal> make(MatrixStore<BigDecimal> template, boolean symmetric) {
            if (symmetric) {
                return Cholesky.make(template);
            }
            return LU.make(template);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public DeterminantTask<ComplexNumber> make(MatrixStore<ComplexNumber> template, boolean symmetric) {
            if (symmetric) {
                return Cholesky.make(template);
            }
            return LU.make(template);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public DeterminantTask<Double> make(MatrixStore<Double> template, boolean symmetric) {
            long tmpDim = template.countRows();
            if (tmpDim == 1L) {
                return AbstractDeterminator.FULL_1X1;
            }
            if (symmetric) {
                if (tmpDim == 2L) {
                    return AbstractDeterminator.SYMMETRIC_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractDeterminator.SYMMETRIC_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractDeterminator.SYMMETRIC_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractDeterminator.SYMMETRIC_5X5;
                }
                return Cholesky.make(template);
            }
            if (tmpDim == 2L) {
                return AbstractDeterminator.FULL_2X2;
            }
            if (tmpDim == 3L) {
                return AbstractDeterminator.FULL_3X3;
            }
            if (tmpDim == 4L) {
                return AbstractDeterminator.FULL_4X4;
            }
            if (tmpDim == 5L) {
                return AbstractDeterminator.FULL_5X5;
            }
            return LU.make(template);
        }
    };

    public N calculateDeterminant(Access2D<?> var1);

    public static abstract class Factory<N extends Number> {
        public final DeterminantTask<N> make(MatrixStore<N> template) {
            return this.make(template, MatrixUtils.isHermitian(template));
        }

        public abstract DeterminantTask<N> make(MatrixStore<N> var1, boolean var2);
    }
}

