/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.AbstractSolver;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.scalar.ComplexNumber;

public interface SolverTask<N extends Number>
extends MatrixTask<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public SolverTask<BigDecimal> make(MatrixStore<BigDecimal> templateBody, MatrixStore<BigDecimal> templateRHS, boolean hermitian) {
            if (hermitian) {
                return Cholesky.make(templateBody);
            }
            if (templateBody.countRows() == templateBody.countColumns()) {
                return LU.make(templateBody);
            }
            if (templateBody.countRows() >= templateBody.countColumns()) {
                return QR.make(templateBody);
            }
            return SingularValue.make(templateBody);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public SolverTask<ComplexNumber> make(MatrixStore<ComplexNumber> templateBody, MatrixStore<ComplexNumber> templateRHS, boolean hermitian) {
            if (hermitian) {
                return Cholesky.make(templateBody);
            }
            if (templateBody.countRows() == templateBody.countColumns()) {
                return LU.make(templateBody);
            }
            if (templateBody.countRows() >= templateBody.countColumns()) {
                return QR.make(templateBody);
            }
            return SingularValue.make(templateBody);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public SolverTask<Double> make(MatrixStore<Double> templateBody, MatrixStore<Double> templateRHS, boolean hermitian) {
            if (hermitian) {
                long tmpDim = templateBody.countColumns();
                if (tmpDim == 1L) {
                    return AbstractSolver.FULL_1X1;
                }
                if (tmpDim == 2L) {
                    return AbstractSolver.SYMMETRIC_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractSolver.SYMMETRIC_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractSolver.SYMMETRIC_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractSolver.SYMMETRIC_5X5;
                }
                return Cholesky.make(templateBody);
            }
            long tmpDim = templateBody.countColumns();
            if (templateBody.countRows() == tmpDim) {
                if (tmpDim == 1L) {
                    return AbstractSolver.FULL_1X1;
                }
                if (tmpDim == 2L) {
                    return AbstractSolver.FULL_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractSolver.FULL_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractSolver.FULL_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractSolver.FULL_5X5;
                }
                return LU.make(templateBody);
            }
            if (templateBody.countRows() >= tmpDim) {
                if (tmpDim <= 5L) {
                    return AbstractSolver.LEAST_SQUARES;
                }
                return QR.make(templateBody);
            }
            return SingularValue.make(templateBody);
        }
    };

    public DecompositionStore<N> preallocate(Structure2D var1, Structure2D var2);

    default public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws TaskException {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    public MatrixStore<N> solve(Access2D<?> var1, Access2D<?> var2, DecompositionStore<N> var3) throws TaskException;

    public static abstract class Factory<N extends Number> {
        public final SolverTask<N> make(MatrixStore<N> templateBody, MatrixStore<N> templateRHS) {
            return this.make(templateBody, templateRHS, MatrixUtils.isHermitian(templateBody));
        }

        public abstract SolverTask<N> make(MatrixStore<N> var1, MatrixStore<N> var2, boolean var3);
    }
}

