/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.ComplexNumber;

public abstract class Rotation<N extends Number> {
    public final int high;
    public final int low;

    public static Big makeBig(int aLowerIndex, int aHigherIndex, BigDecimal anAngle) {
        return new Big(aLowerIndex, aHigherIndex, BigFunction.COS.invoke(anAngle), BigFunction.SIN.invoke(anAngle));
    }

    public static Complex makeComplex(int aLowerIndex, int aHigherIndex, ComplexNumber anAngle) {
        return new Complex(aLowerIndex, aHigherIndex, ComplexFunction.COS.invoke(anAngle), ComplexFunction.SIN.invoke(anAngle));
    }

    public static Primitive makePrimitive(int aLowerIndex, int aHigherIndex, double anAngle) {
        return new Primitive(aLowerIndex, aHigherIndex, PrimitiveFunction.COS.invoke(anAngle), PrimitiveFunction.SIN.invoke(anAngle));
    }

    private Rotation() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected Rotation(int aLowerIndex, int aHigherIndex) {
        this.low = aLowerIndex;
        this.high = aHigherIndex;
    }

    public abstract double doubleCosineValue();

    public abstract double doubleSineValue();

    public abstract N getCosine();

    public abstract N getSine();

    public abstract Rotation<N> invert();

    public String toString() {
        return "low=" + this.low + ", high=" + this.high + ", cos=" + this.getCosine() + ", sin=" + this.getSine();
    }

    public static final class Primitive
    extends Rotation<Double> {
        public final double cos;
        public final double sin;

        public Primitive(int index) {
            this(index, index, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex, double aCosine, double aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Primitive(Rotation<Double> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine() != null && !Double.isNaN(aRotation.doubleCosineValue()) ? aRotation.doubleCosineValue() : Double.NaN;
            this.sin = aRotation.getSine() != null && !Double.isNaN(aRotation.doubleSineValue()) ? aRotation.doubleSineValue() : Double.NaN;
        }

        @Override
        public double doubleCosineValue() {
            return this.cos;
        }

        @Override
        public double doubleSineValue() {
            return this.sin;
        }

        @Override
        public Double getCosine() {
            return this.cos;
        }

        @Override
        public Double getSine() {
            return this.sin;
        }

        public Primitive invert() {
            return new Primitive(this.high, this.low, this.cos, this.sin);
        }
    }

    public static final class Complex
    extends Rotation<ComplexNumber> {
        public final ComplexNumber cos;
        public final ComplexNumber sin;

        public Complex(int index) {
            this(index, index, null, null);
        }

        public Complex(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, null, null);
        }

        public Complex(int aLowerIndex, int aHigherIndex, ComplexNumber aCosine, ComplexNumber aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Complex(Rotation<ComplexNumber> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine();
            this.sin = aRotation.getSine();
        }

        @Override
        public double doubleCosineValue() {
            return this.cos.doubleValue();
        }

        @Override
        public double doubleSineValue() {
            return this.sin.doubleValue();
        }

        @Override
        public ComplexNumber getCosine() {
            return this.cos;
        }

        @Override
        public ComplexNumber getSine() {
            return this.sin;
        }

        public Complex invert() {
            return new Complex(this.high, this.low, this.cos, this.sin);
        }
    }

    public static final class Big
    extends Rotation<BigDecimal> {
        public final BigDecimal cos;
        public final BigDecimal sin;

        public Big(int index) {
            this(index, index, null, null);
        }

        public Big(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, null, null);
        }

        public Big(int aLowerIndex, int aHigherIndex, BigDecimal aCosine, BigDecimal aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Big(Rotation<BigDecimal> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine();
            this.sin = aRotation.getSine();
        }

        @Override
        public double doubleCosineValue() {
            return this.cos.doubleValue();
        }

        @Override
        public double doubleSineValue() {
            return this.sin.doubleValue();
        }

        @Override
        public BigDecimal getCosine() {
            return this.cos;
        }

        @Override
        public BigDecimal getSine() {
            return this.sin;
        }

        public Big invert() {
            return new Big(this.high, this.low, this.cos, this.sin);
        }
    }
}

