/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;

final class QPESolver
extends ConstrainedSolver {
    private boolean myFeasible = false;
    private final PrimitiveDenseStore myIterationX = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.countVariables(), 1L);

    QPESolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    private boolean isFeasible() {
        boolean retVal = true;
        MatrixStore<Double> tmpAEX = this.getAEX();
        MatrixStore<Double> tmpBE = this.getBE();
        int i = 0;
        while (retVal && (long)i < tmpBE.countRows()) {
            if (this.options.slack.isDifferent(tmpBE.doubleValue(i), tmpAEX.doubleValue(i))) {
                retVal = false;
            }
            ++i;
        }
        return retVal;
    }

    @Override
    protected final MatrixStore<Double> getIterationKKT() {
        MatrixStore<Double> tmpIterationQ = this.getIterationQ();
        MatrixStore<Double> tmpIterationA = this.getIterationA();
        return tmpIterationQ.builder().right(new MatrixStore[]{tmpIterationA.transpose()}).below(tmpIterationA).build();
    }

    @Override
    protected final MatrixStore<Double> getIterationRHS() {
        MatrixStore<Double> tmpIterationC = this.getIterationC();
        MatrixStore<Double> tmpIterationB = this.getIterationB();
        return tmpIterationC.builder().below(tmpIterationB).build();
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        super.initialise(kickStarter);
        if (kickStarter != null) {
            this.fillX(kickStarter);
            this.myFeasible = this.isFeasible();
            if (!this.myFeasible) {
                this.resetX();
            }
        } else {
            this.resetX();
            this.myFeasible = false;
        }
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        MatrixStore tmpInvQAT;
        MatrixStore tmpS;
        MatrixStore<Double> tmpIterQ = this.getIterationQ();
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA();
        MatrixStore<Double> tmpIterB = this.getIterationB();
        boolean tmpSolvable = false;
        PrimitiveDenseStore tmpIterX = this.myIterationX;
        PrimitiveDenseStore tmpIterL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpIterA.countRows(), 1L);
        if (tmpIterA.countRows() < tmpIterA.countColumns() && (tmpSolvable = this.myCholesky.isSolvable()) && (tmpSolvable = this.myLU.compute(tmpS = tmpIterA.multiply((Double)((Object)(tmpInvQAT = this.myCholesky.solve(tmpIterA.transpose()))))))) {
            MatrixStore<Double> tmpInvQC = this.myCholesky.solve(tmpIterC, tmpIterX);
            this.myLU.solve(tmpIterA.multiply((Double)((Object)tmpInvQC)).subtract(tmpIterB), tmpIterL);
            this.myCholesky.solve(tmpIterC.subtract(tmpIterA.transpose().multiply(tmpIterL)), tmpIterX);
        }
        if (!tmpSolvable && (tmpSolvable = this.myLU.compute(this.getIterationKKT()))) {
            MatrixStore<Double> tmpXL = this.myLU.solve(this.getIterationRHS());
            tmpIterX.fillMatching(tmpXL.builder().rows(0, this.countVariables()).build());
            tmpIterL.fillMatching(tmpXL.builder().rows(this.countVariables(), (int)tmpXL.count()).build());
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
            this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
        }
        if (tmpSolvable) {
            this.setState(Optimisation.State.OPTIMAL);
            if (this.myFeasible) {
                this.getX().fillMatching(this.getX(), PrimitiveFunction.ADD, tmpIterX);
                this.getLE().fillMatching(tmpIterL);
            } else {
                this.getX().fillMatching(tmpIterX);
                this.getLE().fillMatching(tmpIterL);
            }
        } else if (this.myFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.resetX();
        }
    }

    @Override
    final MatrixStore<Double> getIterationA() {
        return this.getAE();
    }

    @Override
    final MatrixStore<Double> getIterationB() {
        if (this.myFeasible) {
            return MatrixStore.PRIMITIVE.makeZero(this.countEqualityConstraints(), 1).get();
        }
        return this.getBE();
    }

    @Override
    final MatrixStore<Double> getIterationC() {
        if (this.myFeasible) {
            MatrixStore<Double> tmpQ = this.getQ();
            MatrixStore<Double> tmpC = this.getC();
            DecompositionStore<Double> tmpX = this.getX();
            return tmpC.subtract(tmpQ.multiply((Double)((Object)tmpX)));
        }
        return this.getC();
    }
}

