/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.PrimitiveScalar;

final class SymmetricSchurComplementSupplier
implements ElementsSupplier<Double> {
    private final MatrixStore<Double> myAE;
    private final MatrixStore<Double> myFullAI;
    private int[] myIncluded;
    private final SparseArray<Double> mySparse;
    private final int myCountE;
    private final int myCountI;
    private final int myFullDim;

    SymmetricSchurComplementSupplier(MatrixStore<Double> equalities, MatrixStore<Double> inequalities) {
        this.myAE = equalities;
        this.myFullAI = inequalities;
        this.myCountE = (int)this.myAE.countRows();
        this.myCountI = (int)this.myFullAI.countRows();
        this.myFullDim = this.myCountE + this.myCountI;
        this.mySparse = SparseArray.makePrimitive(this.myFullDim * this.myFullDim);
    }

    void add(int j, Access1D<Double> column) {
        PrimitiveDenseStore tmpColE = (PrimitiveDenseStore)this.factory().makeZero(this.myCountE, 1L);
        PhysicalStore<Double> tmpProdE = this.myAE.multiply(column, tmpColE);
        for (int i = 0; i < this.myCountE; ++i) {
            double tmpVal = tmpProdE.doubleValue(i);
            if (PrimitiveScalar.isSmall(tmpVal, 1.0)) continue;
            this.mySparse.set((long)AccessUtils.index(this.myFullDim, i, j), tmpVal);
            this.mySparse.set((long)AccessUtils.index(this.myFullDim, j, i), tmpVal);
        }
        PrimitiveDenseStore tmpColI = (PrimitiveDenseStore)this.factory().makeZero(this.myIncluded.length, 1L);
        PhysicalStore<Double> tmpProdI = this.myFullAI.builder().row(this.myIncluded).get().multiply(column, tmpColI);
        for (int _i = 0; _i < this.myIncluded.length; ++_i) {
            double tmpVal = tmpProdI.doubleValue(_i);
            if (PrimitiveScalar.isSmall(tmpVal, 1.0)) continue;
            int i = this.myCountE + this.myIncluded[_i];
            this.mySparse.set((long)AccessUtils.index(this.myFullDim, i, j), tmpVal);
            this.mySparse.set((long)AccessUtils.index(this.myFullDim, j, i), tmpVal);
        }
    }

    @Override
    public long countColumns() {
        return this.myCountE + this.myCountI;
    }

    @Override
    public long countRows() {
        return this.myCountE + this.myCountI;
    }

    @Override
    public PhysicalStore.Factory<Double, PrimitiveDenseStore> factory() {
        return PrimitiveDenseStore.FACTORY;
    }

    @Override
    public void supplyTo(ElementsConsumer<Double> consumer) {
        consumer.fillAll(0.0);
        this.mySparse.supplyNonZerosTo(consumer, new LongUnaryOperator(){

            @Override
            public long applyAsLong(long operand) {
                int tmpFound;
                int tmpSparseRow = AccessUtils.row(operand, SymmetricSchurComplementSupplier.this.myFullDim);
                int tmpSparseCol = AccessUtils.column(operand, SymmetricSchurComplementSupplier.this.myFullDim);
                int tmpDenseRow = -1;
                if (tmpSparseRow < SymmetricSchurComplementSupplier.this.myCountE) {
                    tmpDenseRow = tmpSparseRow;
                } else {
                    tmpFound = Arrays.binarySearch(SymmetricSchurComplementSupplier.this.myIncluded, tmpSparseRow);
                    if (tmpFound >= 0) {
                        tmpDenseRow = SymmetricSchurComplementSupplier.this.myCountE + tmpFound;
                    }
                }
                int tmpDenseCol = -1;
                if (tmpSparseCol < SymmetricSchurComplementSupplier.this.myCountE) {
                    tmpDenseCol = tmpSparseCol;
                } else {
                    tmpFound = Arrays.binarySearch(SymmetricSchurComplementSupplier.this.myIncluded, tmpSparseCol);
                    if (tmpFound >= 0) {
                        tmpDenseCol = SymmetricSchurComplementSupplier.this.myCountE + tmpFound;
                    }
                }
                return tmpDenseRow < 0 || tmpDenseCol < 0 ? -1L : (long)AccessUtils.index(SymmetricSchurComplementSupplier.this.myCountE + SymmetricSchurComplementSupplier.this.myIncluded.length, tmpDenseRow, tmpDenseCol);
            }
        });
    }

    void update(int[] included) {
        this.myIncluded = included;
    }
}

