/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.linear.LinearSolver;

final class SimplexTableauSolver
extends LinearSolver {
    private final int[] myBasis;
    private final PivotPoint myPoint = new PivotPoint(this);
    private final PrimitiveDenseStore myTransposedTableau;

    SimplexTableauSolver(LinearSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        int tmpConstraintsCount = this.countConstraints();
        MatrixStore.Builder tmpTableauBuilder = MatrixStore.PRIMITIVE.makeZero(1, 1).get().builder();
        tmpTableauBuilder.left(new MatrixStore[]{matrices.getC().transpose()});
        if (tmpConstraintsCount >= 1) {
            tmpTableauBuilder.above(matrices.getAE(), matrices.getBE());
        }
        tmpTableauBuilder.below(1);
        this.myTransposedTableau = PrimitiveDenseStore.FACTORY.transpose(tmpTableauBuilder.build());
        int[] tmpBasis = null;
        if (tmpBasis != null && tmpBasis.length == tmpConstraintsCount) {
            this.myBasis = tmpBasis;
            this.include(tmpBasis);
        } else {
            this.myBasis = AccessUtils.makeIncreasingRange(-tmpConstraintsCount, tmpConstraintsCount);
        }
        for (int i = 0; i < tmpConstraintsCount; ++i) {
            if (this.myBasis[i] >= 0) continue;
            this.myTransposedTableau.caxpy(PrimitiveMath.NEG, i, this.myPoint.getRowObjective(), 0);
        }
        if (this.isDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Tableau Created");
        }
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        while (this.needsAnotherIteration()) {
            this.performIteration(this.myPoint.row, this.myPoint.col);
            if (!this.isDebug() || !this.isTableauPrintable()) continue;
            this.logDebugTableau("Tableau Iteration");
        }
        return this.buildResult();
    }

    private int countBasicArtificials() {
        int retVal = 0;
        int tmpLength = this.myBasis.length;
        for (int i = 0; i < tmpLength; ++i) {
            if (this.myBasis[i] >= 0) continue;
            ++retVal;
        }
        return retVal;
    }

    private boolean isBasicArtificials() {
        int tmpLength = this.myBasis.length;
        for (int i = 0; i < tmpLength; ++i) {
            if (this.myBasis[i] >= 0) continue;
            return true;
        }
        return false;
    }

    private final boolean isTableauPrintable() {
        return this.myTransposedTableau.count() <= 512L;
    }

    private final void logDebugTableau(String message) {
        this.debug(message + "; Basics: " + Arrays.toString(this.myBasis), (Access2D<?>)((Object)this.myTransposedTableau.transpose()));
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        return this.myPoint.objective();
    }

    protected PhysicalStore<Double> extractSolution() {
        int tmpCountVariables = this.countVariables();
        this.resetX();
        int tmpLength = this.myBasis.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpBasisIndex = this.myBasis[i];
            if (tmpBasisIndex < 0) continue;
            this.setX(tmpBasisIndex, this.myTransposedTableau.doubleValue(tmpCountVariables, i));
        }
        DecompositionStore<Double> tmpTableauSolution = this.getX();
        return tmpTableauSolution;
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return false;
    }

    @Override
    protected boolean needsAnotherIteration() {
        if (this.isDebug()) {
            this.debug("\nNeeds Another Iteration? Phase={} Artificials={} Objective={}", this.myPoint.phase(), this.countBasisDeficit(), this.myPoint.objective());
        }
        boolean retVal = false;
        this.myPoint.reset();
        if (this.myPoint.isPhase1()) {
            double tmpPhaseOneValue = this.myTransposedTableau.doubleValue(this.countVariables(), this.myPoint.getRowObjective());
            if (!this.isBasicArtificials() || this.options.objective.isZero(tmpPhaseOneValue)) {
                if (this.isDebug()) {
                    this.debug("\nSwitching to Phase2 with {} artificial variable(s) still in the basis.\n", this.countBasicArtificials());
                    this.debug("Reduced artificial costs:\n{}", this.sliceTableauRow(this.myPoint.getRowObjective()).copy(this.getExcluded()));
                }
                this.myPoint.switchToPhase2();
            }
        }
        this.myPoint.col = this.findNextPivotCol();
        if (this.myPoint.col >= 0) {
            this.myPoint.row = this.findNextPivotRow();
            if (this.myPoint.row >= 0) {
                retVal = true;
            } else if (this.myPoint.isPhase2()) {
                this.setState(Optimisation.State.UNBOUNDED);
                retVal = false;
            } else {
                this.setState(Optimisation.State.INFEASIBLE);
                retVal = false;
            }
        } else if (this.myPoint.isPhase1()) {
            this.setState(Optimisation.State.INFEASIBLE);
            retVal = false;
        } else {
            this.setState(Optimisation.State.OPTIMAL);
            retVal = false;
        }
        if (this.isDebug()) {
            if (retVal) {
                this.debug("\n==>>\tRow: {},\tExit: {},\tColumn/Enter: {}.\n", this.myPoint.row, this.myBasis[this.myPoint.row], this.myPoint.col);
            } else {
                this.debug("\n==>>\tNo more iterations needed/possible.\n", new Object[0]);
            }
        }
        return retVal;
    }

    @Override
    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        return true;
    }

    int findNextPivotCol() {
        int[] tmpExcluded = this.getExcluded();
        if (this.isDebug()) {
            if (this.options.validate) {
                this.debug("\nfindNextPivotCol (index of most negative value) among these:\n{}", this.sliceTableauRow(this.myPoint.getRowObjective()).copy(tmpExcluded));
            } else {
                this.debug("\nfindNextPivotCol", new Object[0]);
            }
        }
        int retVal = -1;
        double tmpMinVal = this.myPoint.isPhase2() ? -this.options.problem.epsilon() : PrimitiveMath.ZERO;
        for (int e = 0; e < tmpExcluded.length; ++e) {
            int tmpCol = tmpExcluded[e];
            double tmpVal = this.myTransposedTableau.doubleValue(tmpCol, this.myPoint.getRowObjective());
            if (!(tmpVal < tmpMinVal)) continue;
            retVal = tmpCol;
            tmpMinVal = tmpVal;
            if (!this.isDebug()) continue;
            this.debug("Col: {}\t=>\tReduced Contribution Weight: {}.", tmpCol, tmpVal);
        }
        return retVal;
    }

    int findNextPivotRow() {
        int tmpNumerCol = this.myPoint.getColRHS();
        int tmpDenomCol = this.myPoint.col;
        if (this.isDebug()) {
            if (this.options.validate) {
                Array1D<Double> tmpNumerators = this.sliceTableauColumn(tmpNumerCol);
                Array1D<Double> tmpDenominators = this.sliceTableauColumn(tmpDenomCol);
                Array1D<Double> tmpRatios = tmpNumerators.copy();
                tmpRatios.modifyMatching(PrimitiveFunction.DIVIDE, tmpDenominators);
                this.debug("\nfindNextPivotRow (smallest positive ratio) among these:\nNumerators={}\nDenominators={}\nRatios={}", tmpNumerators, tmpDenominators, tmpRatios);
            } else {
                this.debug("\nfindNextPivotRow", new Object[0]);
            }
        }
        int retVal = -1;
        double tmpNumer = Double.NaN;
        double tmpDenom = Double.NaN;
        double tmpRatio = Double.NaN;
        double tmpMinRatio = Double.MAX_VALUE;
        int tmpConstraintsCount = this.countConstraints();
        boolean tmpPhase2 = this.myPoint.isPhase2();
        for (int i = 0; i < tmpConstraintsCount; ++i) {
            boolean tmpSpecialCase = tmpPhase2 && this.myBasis[i] < 0;
            tmpDenom = this.myTransposedTableau.doubleValue(tmpDenomCol, i);
            tmpNumer = Math.abs(this.myTransposedTableau.doubleValue(tmpNumerCol, i));
            tmpRatio = this.options.problem.isSmall(tmpNumer, tmpDenom) ? Double.MAX_VALUE : (tmpSpecialCase ? (this.options.problem.isSmall(tmpDenom, tmpNumer) ? PrimitiveMath.MACHINE_EPSILON : Double.MAX_VALUE) : tmpNumer / tmpDenom);
            if (!tmpSpecialCase && !(tmpDenom > PrimitiveMath.ZERO) || !(tmpRatio >= PrimitiveMath.ZERO) || !(tmpRatio < tmpMinRatio)) continue;
            retVal = i;
            tmpMinRatio = tmpRatio;
            if (!this.isDebug()) continue;
            this.debug("Row: {}\t=>\tRatio: {},\tNumerator/RHS: {}, \tDenominator/Pivot: {}.", i, tmpRatio, tmpNumer, tmpDenom);
        }
        return retVal;
    }

    double getTableauElement(int row, int col) {
        return this.myTransposedTableau.doubleValue(col, row);
    }

    void performIteration(int pivotRow, int pivotCol) {
        int tmpNew;
        int tmpOld;
        double tmpPivotElement = this.getTableauElement(pivotRow, pivotCol);
        double tmpPivotRHS = this.getTableauElement(pivotRow, this.myPoint.getColRHS());
        for (int i = 0; i <= this.myPoint.getRowObjective(); ++i) {
            double tmpPivotColVal;
            if (i == pivotRow || (tmpPivotColVal = this.getTableauElement(i, pivotCol)) == PrimitiveMath.ZERO) continue;
            this.myTransposedTableau.caxpy(-tmpPivotColVal / tmpPivotElement, pivotRow, i, 0);
        }
        if (Math.abs(tmpPivotElement) < PrimitiveMath.ONE) {
            this.myTransposedTableau.modifyColumn(0L, (long)pivotRow, PrimitiveFunction.DIVIDE.second((Double)tmpPivotElement));
        } else if (tmpPivotElement != PrimitiveMath.ONE) {
            this.myTransposedTableau.modifyColumn(0L, (long)pivotRow, PrimitiveFunction.MULTIPLY.second((Double)(PrimitiveMath.ONE / tmpPivotElement)));
        }
        if (this.isDebug()) {
            this.debug("Iteration Point <{},{}>\tPivot: {} => {}\tRHS: {} => {}.", pivotRow, pivotCol, tmpPivotElement, this.getTableauElement(pivotRow, pivotCol), tmpPivotRHS, this.getTableauElement(pivotRow, this.myPoint.getColRHS()));
        }
        if ((tmpOld = this.myBasis[pivotRow]) >= 0) {
            this.exclude(tmpOld);
        }
        if ((tmpNew = pivotCol) >= 0) {
            this.include(tmpNew);
        }
        this.myBasis[pivotRow] = pivotCol;
        if (this.options.validate) {
            Array1D<Double> tmpRHS = this.sliceTableauColumn(this.myPoint.getColRHS());
            AggregatorFunction<Double> tmpMinAggr = PrimitiveAggregator.getSet().minimum();
            tmpRHS.visitAll(tmpMinAggr);
            double tmpMinVal = tmpMinAggr.doubleValue();
            if (tmpMinVal < PrimitiveMath.ZERO && !this.options.problem.isZero(tmpMinVal)) {
                this.debug("\nNegative RHS! {}", tmpMinVal);
                if (this.isDebug()) {
                    this.debug("Entire RHS columns: {}\n", tmpRHS);
                }
            }
        }
    }

    Array1D<Double> sliceTableauColumn(int col) {
        return ((Array1D)this.myTransposedTableau.asArray2D().sliceRow(col, 0L)).subList(0, this.countConstraints());
    }

    Array1D<Double> sliceTableauRow(int row) {
        return ((Array1D)this.myTransposedTableau.asArray2D().sliceColumn(0L, row)).subList(0, this.countVariables());
    }

    @Override
    public int[] getBasis() {
        return (int[])this.myBasis.clone();
    }

    @Override
    public double[] getResidualCosts() {
        this.logDebugTableau("Tableau extracted");
        double[] retVal = new double[this.countVariables()];
        int tmpRowObjective = this.countConstraints();
        for (int j = 0; j < retVal.length; ++j) {
            retVal[j] = this.myTransposedTableau.doubleValue(j, tmpRowObjective);
        }
        return retVal;
    }

    static final class PivotPoint {
        private int myRowObjective = -1;
        private final SimplexTableauSolver mySolver;
        int col = -1;
        int row = -1;

        private PivotPoint() {
            this(null);
            ProgrammingError.throwForIllegalInvocation();
        }

        PivotPoint(SimplexTableauSolver solver) {
            this.mySolver = solver;
            this.myRowObjective = this.mySolver.countConstraints() + 1;
            this.reset();
        }

        int getColRHS() {
            return this.mySolver.countVariables();
        }

        int getRowObjective() {
            return this.myRowObjective;
        }

        boolean isPhase1() {
            return this.myRowObjective == this.mySolver.countConstraints() + 1;
        }

        boolean isPhase2() {
            return this.myRowObjective == this.mySolver.countConstraints();
        }

        double objective() {
            return this.mySolver.getTableauElement(this.getRowObjective(), this.mySolver.countVariables());
        }

        int phase() {
            return this.myRowObjective == this.mySolver.countConstraints() ? 2 : 1;
        }

        void reset() {
            this.row = -1;
            this.col = -1;
        }

        void switchToPhase2() {
            this.myRowObjective = this.mySolver.countConstraints();
        }
    }
}

