/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.random.Random1D;

abstract class RandomNumber1D {
    private final Random1D myRandom;

    protected RandomNumber1D(Access2D<?> correlations) {
        this.myRandom = new Random1D(correlations);
    }

    public abstract Array1D<Double> getExpected();

    public Array1D<Double> getStandardDeviation() {
        Array1D<Double> tmpVar = this.getVariance();
        int tmpLength = tmpVar.size();
        Access1D retVal = Array1D.PRIMITIVE.makeZero(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            ((Array1D)retVal).set((long)i, Math.sqrt(tmpVar.doubleValue(i)));
        }
        return retVal;
    }

    public Array1D<Double> getVariance() {
        Array1D<Double> tmpStdDev = this.getStandardDeviation();
        int tmpLength = tmpStdDev.size();
        Access1D retVal = Array1D.PRIMITIVE.makeZero(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            double tmpVal = tmpStdDev.doubleValue(i);
            ((Array1D)retVal).set((long)i, tmpVal * tmpVal);
        }
        return retVal;
    }

    protected final Random1D random() {
        return this.myRandom;
    }
}

