/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public class CoordinationSet<V extends Number>
extends HashMap<String, CalendarDateSeries<V>> {
    private CalendarDateUnit myResolution = null;

    public CoordinationSet() {
    }

    public CoordinationSet(CalendarDateUnit aResolution) {
        this.myResolution = aResolution;
    }

    public CoordinationSet(Collection<CalendarDateSeries<V>> aTimeSeriesCollection) {
        super(aTimeSeriesCollection.size());
        for (CalendarDateSeries<V> tmpTimeSeries : aTimeSeriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(Collection<CalendarDateSeries<V>> aTimeSeriesCollection, CalendarDateUnit aResolution) {
        super(aTimeSeriesCollection.size());
        this.myResolution = aResolution;
        for (CalendarDateSeries<V> tmpTimeSeries : aTimeSeriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(int someInitialCapacity) {
        super(someInitialCapacity);
    }

    public CoordinationSet(int someInitialCapacity, float someLoadFactor) {
        super(someInitialCapacity, someLoadFactor);
    }

    public CoordinationSet(Map<? extends String, ? extends CalendarDateSeries<V>> someM) {
        super(someM);
    }

    public void complete() {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.complete();
        }
    }

    public CoordinationSet<V> copy() {
        return this.resample(this.getResolution());
    }

    @Override
    public CalendarDateSeries<V> get(Object key) {
        if (key instanceof CalendarDateSeries) {
            return (CalendarDateSeries)super.get(((CalendarDateSeries)key).getName());
        }
        return (CalendarDateSeries)super.get(key.toString());
    }

    public CalendarDateSeries<V> get(String aSeriesName) {
        return (CalendarDateSeries)super.get(aSeriesName);
    }

    public List<CalendarDate> getAllCalendarDates() {
        TreeSet retVal = new TreeSet();
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.addAll(tmpSeries.keySet());
        }
        return new ArrayList<CalendarDate>(retVal);
    }

    public List<String> getAllSeriesNames() {
        return new ArrayList<String>(this.keySet());
    }

    public CalendarDate getEarliestFirstKey() {
        CalendarDate retVal = null;
        CalendarDate tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = (CalendarDate)tmpSeries.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public CalendarDate getEarliestLastKey() {
        CalendarDate retVal = null;
        CalendarDate tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = (CalendarDate)tmpSeries.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public CalendarDate getLatestFirstKey() {
        CalendarDate retVal = null;
        CalendarDate tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = (CalendarDate)tmpSeries.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public CalendarDate getLatestLastKey() {
        CalendarDate retVal = null;
        CalendarDate tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = (CalendarDate)tmpSeries.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public CalendarDateUnit getResolution() {
        if (this.myResolution != null) {
            return this.myResolution;
        }
        CalendarDateUnit retVal = null;
        CalendarDateUnit tmpVal = null;
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpVal = tmpSeries.getResolution();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return retVal;
    }

    public V getValue(String aSeriesName, CalendarDate aCalendarDate) {
        return (V)((Number)this.get(aSeriesName).get(aCalendarDate));
    }

    public void modify(BinaryFunction<V> aFunc, V anArg) {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.modify((BinaryFunction)aFunc, (Number)anArg);
        }
    }

    public void modify(ParameterFunction<V> aFunc, int aParam) {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.modify((ParameterFunction)aFunc, aParam);
        }
    }

    public void modify(UnaryFunction<V> aFunc) {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.modify((UnaryFunction)aFunc);
        }
    }

    public CoordinationSet<V> prune() {
        CoordinationSet retVal = new CoordinationSet(this.getResolution());
        CalendarDate tmpFirstKey = this.getLatestFirstKey();
        CalendarDate tmpLastKey = this.getEarliestLastKey();
        if (tmpLastKey.compareTo(tmpFirstKey) != -1) {
            for (CalendarDateSeries tmpSeries : this.values()) {
                CalendarDateSeries tmpSubMap = tmpSeries.subMap(tmpFirstKey, true, tmpLastKey, true);
                retVal.put(tmpSubMap);
            }
        }
        CalendarDate tmpEarliestFirstKey = retVal.getEarliestFirstKey();
        CalendarDate tmpLatestFirstKey = retVal.getLatestFirstKey();
        CalendarDate tmpEarliestLastKey = retVal.getEarliestLastKey();
        CalendarDate tmpLatestLastKey = retVal.getLatestLastKey();
        if (!tmpEarliestFirstKey.equals(tmpFirstKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (!tmpLatestFirstKey.equals(tmpFirstKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (!tmpEarliestLastKey.equals(tmpLastKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        if (!tmpLatestLastKey.equals(tmpLastKey)) {
            throw new ProgrammingError("Something went wrong!");
        }
        return retVal;
    }

    public CoordinationSet<V> prune(CalendarDateUnit aResolution) {
        CoordinationSet retVal = new CoordinationSet(aResolution);
        CalendarDate tmpLatestFirstKey = this.getLatestFirstKey();
        CalendarDate tmpEarliestLastKey = this.getEarliestLastKey();
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.put(tmpSeries.resample(tmpLatestFirstKey, tmpEarliestLastKey, aResolution));
        }
        return retVal;
    }

    public CalendarDateSeries<V> put(CalendarDateSeries<V> aSeries) {
        return this.put(aSeries.getName(), aSeries);
    }

    public CoordinationSet<V> resample(CalendarDateUnit aResolution) {
        CoordinationSet retVal = new CoordinationSet(aResolution);
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.put(tmpSeries.resample(aResolution));
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder(this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()));
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.append('\n');
            retVal.append(tmpSeries.toString());
        }
        return retVal.toString();
    }
}

