/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.series.primitive.PrimitiveSeries;

public final class DataSeries
extends PrimitiveSeries {
    private final Array1D<Double> myValues;

    public static DataSeries copy(Access1D<?> aBase) {
        return new DataSeries((Array1D<Double>)Array1D.PRIMITIVE.copy((Access1D)aBase));
    }

    public static DataSeries copy(double[] aRaw) {
        return new DataSeries((Array1D<Double>)Array1D.PRIMITIVE.copy(aRaw));
    }

    public static DataSeries wrap(double[] aRaw) {
        return new DataSeries(Array1D.PRIMITIVE.wrap(PrimitiveArray.wrap(aRaw)));
    }

    private DataSeries(Array1D<Double> aValues) {
        this.myValues = aValues;
    }

    public final void modify(BinaryFunction<Double> aFunc, Double aNmbr) {
        this.myValues.modifyAll(aFunc.second(aNmbr));
    }

    public final void modify(Double aNmbr, BinaryFunction<Double> aFunc) {
        this.myValues.modifyAll(aFunc.first(aNmbr));
    }

    public final void modify(ParameterFunction<Double> aFunc, int aParam) {
        this.myValues.modifyAll(aFunc.parameter(aParam));
    }

    public final void modify(UnaryFunction<Double> aFunc) {
        this.myValues.modifyAll(aFunc);
    }

    @Override
    public final int size() {
        return this.myValues.size();
    }

    @Override
    public final double value(int index) {
        return this.myValues.doubleValue(index);
    }

    public final void visit(AggregatorFunction<Double> aVisitor) {
        this.myValues.visitAll(aVisitor);
    }
}

