/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.CalendarDateUnit;

public final class CalendarDateDuration
extends Number
implements Comparable<CalendarDateDuration> {
    public final double measure;
    public final CalendarDateUnit unit;

    public CalendarDateDuration(double aMeasure, CalendarDateUnit aUnit) {
        this.measure = aMeasure;
        this.unit = aUnit;
    }

    CalendarDateDuration() {
        this(PrimitiveMath.ONE, CalendarDateUnit.MILLIS);
    }

    @Override
    public int compareTo(CalendarDateDuration aReference) {
        long refVal;
        long tmpVal = this.toDurationInMillis();
        return tmpVal < (refVal = aReference.toDurationInMillis()) ? -1 : (tmpVal == refVal ? 0 : 1);
    }

    public CalendarDateDuration convertTo(CalendarDateUnit aDestinationUnit) {
        return new CalendarDateDuration(aDestinationUnit.convert(this.measure, this.unit), aDestinationUnit);
    }

    @Override
    public double doubleValue() {
        return this.measure;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarDateDuration)) {
            return false;
        }
        CalendarDateDuration other = (CalendarDateDuration)obj;
        if (Double.doubleToLongBits(this.measure) != Double.doubleToLongBits(other.measure)) {
            return false;
        }
        return this.unit == other.unit;
    }

    @Override
    public float floatValue() {
        return (float)this.measure;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.measure);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.measure;
    }

    @Override
    public long longValue() {
        return (long)this.measure;
    }

    public long toDurationInMillis() {
        return (long)(this.measure * (double)this.unit.size());
    }

    public String toString() {
        return Double.toString(this.measure) + this.unit.toString();
    }
}

