/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_solve;
import edu.ufl.cise.klu.tdouble.Dklu_tsolve;

public class Dklu_diagnostics
extends Dklu_internal {
    public static int klu_rgrowth(int[] Ap, int[] Ai, double[] Ax, KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        int[] len = new int[1];
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        if (Common == null) {
            return 0;
        }
        if (Symbolic == null || Ap == null || Ai == null || Ax == null) {
            Common.status = -3;
            return 0;
        }
        if (Numeric == null) {
            Common.rgrowth = 0.0;
            Common.status = 1;
            return 1;
        }
        Common.status = 0;
        double[] Aentry = Ax;
        int[] Pinv = Numeric.Pinv;
        double[] Rs = Numeric.Rs;
        int[] Q = Symbolic.Q;
        Common.rgrowth = 1.0;
        for (int i = 0; i < Symbolic.nblocks; ++i) {
            int k2 = Symbolic.R[i + 1];
            int k1 = Symbolic.R[i];
            int nk = k2 - k1;
            if (nk == 1) continue;
            double[] LU = Numeric.LUbx[i];
            int[] Uip = Numeric.Uip;
            int Uip_offset = k1;
            int[] Ulen = Numeric.Ulen;
            int Ulen_offset = k1;
            double[] Ukk = Numeric.Udiag;
            int Ukk_offset = k1;
            double min_block_rgrowth = 1.0;
            for (int j = 0; j < nk; ++j) {
                double temp;
                int k;
                double max_ai = 0.0;
                double max_ui = 0.0;
                int oldcol = Q[j + k1];
                int pend = Ap[oldcol + 1];
                for (k = Ap[oldcol]; k < pend; ++k) {
                    int oldrow = Ai[k];
                    int newrow = Pinv[oldrow];
                    if (newrow < k1) continue;
                    Dklu_diagnostics.ASSERT(newrow < k2);
                    double aik = Rs != null ? Aentry[k] / Rs[newrow] : Aentry[k];
                    temp = Dklu_diagnostics.ABS(aik);
                    if (!(temp > max_ai)) continue;
                    max_ai = temp;
                }
                double[] Ux = Dklu_diagnostics.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, j, len);
                for (k = 0; k < len[0]; ++k) {
                    temp = Dklu_diagnostics.ABS(Ux[Ux_offset[0] + k]);
                    if (!(temp > max_ui)) continue;
                    max_ui = temp;
                }
                temp = Dklu_diagnostics.ABS(Ukk[Ukk_offset + j]);
                if (temp > max_ui) {
                    max_ui = temp;
                }
                if (Dklu_diagnostics.SCALAR_IS_ZERO(max_ui) || !((temp = max_ai / max_ui) < min_block_rgrowth)) continue;
                min_block_rgrowth = temp;
            }
            if (!(min_block_rgrowth < Common.rgrowth)) continue;
            Common.rgrowth = min_block_rgrowth;
        }
        return 1;
    }

    public static int klu_condest(int[] Ap, double[] Ax, KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        int j;
        int i;
        if (Common == null) {
            return 0;
        }
        if (Symbolic == null || Ap == null || Ax == null) {
            Common.status = -3;
            return 0;
        }
        double abs_value = 0.0;
        if (Numeric == null) {
            Common.condest = 1.0 / abs_value;
            Common.status = 1;
            return 1;
        }
        Common.status = 0;
        int n = Symbolic.n;
        double[] Udiag = Numeric.Udiag;
        for (i = 0; i < n; ++i) {
            abs_value = Dklu_diagnostics.ABS(Udiag[i]);
            if (!Dklu_diagnostics.SCALAR_IS_ZERO(abs_value)) continue;
            Common.condest = 1.0 / abs_value;
            Common.status = 1;
            return 1;
        }
        double anorm = 0.0;
        double[] Aentry = Ax;
        for (i = 0; i < n; ++i) {
            int pend = Ap[i + 1];
            double csum = 0.0;
            for (j = Ap[i]; j < pend; ++j) {
                abs_value = Dklu_diagnostics.ABS(Aentry[j]);
                csum += abs_value;
            }
            if (!(csum > anorm)) continue;
            anorm = csum;
        }
        double[] X = Numeric.Xwork;
        int X_offset = n;
        double[] S = X;
        int S_offset = 2 * n;
        for (i = 0; i < n; ++i) {
            Dklu_diagnostics.CLEAR(S, S_offset + i);
            Dklu_diagnostics.CLEAR(X, X_offset + i);
            X[X_offset + i] = 1.0 / (double)n;
        }
        int jmax = 0;
        double ainv_norm = 0.0;
        for (i = 0; i < 5; ++i) {
            if (i > 0) {
                for (j = 0; j < n; ++j) {
                    Dklu_diagnostics.CLEAR(X, X_offset + j);
                }
                X[X_offset + jmax] = 1.0;
            }
            Dklu_solve.klu_solve(Symbolic, Numeric, n, 1, X, X_offset, Common);
            double est_old = ainv_norm;
            ainv_norm = 0.0;
            for (j = 0; j < n; ++j) {
                abs_value = Dklu_diagnostics.ABS(X[X_offset + j]);
                ainv_norm += abs_value;
            }
            boolean unchanged = true;
            for (j = 0; j < n; ++j) {
                double s;
                double d = s = X[X_offset + j] >= 0.0 ? 1.0 : -1.0;
                if (s == S[S_offset + j]) continue;
                S[S_offset + j] = s;
                unchanged = false;
            }
            if (i > 0 && (ainv_norm <= est_old || unchanged)) break;
            for (j = 0; j < n; ++j) {
                X[j] = S[S_offset + j];
            }
            Dklu_tsolve.klu_tsolve(Symbolic, Numeric, n, 1, X, X_offset, Common);
            int jnew = 0;
            double Xmax = 0.0;
            for (j = 0; j < n; ++j) {
                double xj = Dklu_diagnostics.ABS(X[X_offset + j]);
                if (!(xj > Xmax)) continue;
                Xmax = xj;
                jnew = j;
            }
            if (i > 0 && jnew == jmax) break;
            jmax = jnew;
        }
        for (j = 0; j < n; ++j) {
            Dklu_diagnostics.CLEAR(X, X_offset + j);
            X[X_offset + j] = j % 2 != 0 ? 1.0 + (double)j / (double)(n - 1) : -1.0 - (double)j / (double)(n - 1);
        }
        Dklu_solve.klu_solve(Symbolic, Numeric, n, 1, X, X_offset, Common);
        double est_new = 0.0;
        for (j = 0; j < n; ++j) {
            abs_value = Dklu_diagnostics.ABS(X[X_offset + j]);
            est_new += abs_value;
        }
        est_new = 2.0 * est_new / (double)(3 * n);
        ainv_norm = Dklu_diagnostics.MAX(est_new, ainv_norm);
        Common.condest = ainv_norm * anorm;
        return 1;
    }

    public static int klu_flops(KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        double flops = 0.0;
        if (Common == null) {
            return 0;
        }
        Common.flops = -1.0;
        if (Numeric == null || Symbolic == null) {
            Common.status = -3;
            return 0;
        }
        Common.status = 0;
        int[] R = Symbolic.R;
        int nblocks = Symbolic.nblocks;
        double[][] LUbx = Numeric.LUbx;
        for (int block = 0; block < nblocks; ++block) {
            int k1 = R[block];
            int nk = R[block + 1] - k1;
            if (nk <= 1) continue;
            int[] Llen = Numeric.Llen;
            int Llen_offset = k1;
            int[] Uip = Numeric.Uip;
            int Uip_offset = k1;
            int[] Ulen = Numeric.Ulen;
            int Ulen_offset = k1;
            double[] LU = LUbx[block];
            int[] Ui_offset = new int[1];
            for (int k = 0; k < nk; ++k) {
                double[] Ui = Dklu_diagnostics.GET_I_POINTER(LU, Uip, Uip_offset, Ui_offset, k);
                int ulen = Ulen[Ulen_offset + k];
                for (int p = 0; p < ulen; ++p) {
                    flops += (double)(2 * Llen[Llen_offset + (int)Ui[Ui_offset[0] + p]]);
                }
                flops += (double)Llen[Llen_offset + k];
            }
        }
        Common.flops = flops;
        return 1;
    }

    public static int klu_rcond(KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        double umin = 0.0;
        double umax = 0.0;
        if (Common == null) {
            return 0;
        }
        if (Symbolic == null) {
            Common.status = -3;
            return 0;
        }
        if (Numeric == null) {
            Common.rcond = 0.0;
            Common.status = 1;
            return 1;
        }
        Common.status = 0;
        int n = Symbolic.n;
        double[] Udiag = Numeric.Udiag;
        for (int j = 0; j < n; ++j) {
            double ukk = Dklu_diagnostics.ABS(Udiag[j]);
            if (Dklu_diagnostics.SCALAR_IS_NAN(ukk) || Dklu_diagnostics.SCALAR_IS_ZERO(ukk)) {
                Common.rcond = 0.0;
                Common.status = 1;
                return 1;
            }
            if (j == 0) {
                umin = ukk;
                umax = ukk;
                continue;
            }
            umin = Dklu_diagnostics.MIN(umin, ukk);
            umax = Dklu_diagnostics.MAX(umax, ukk);
        }
        Common.rcond = umin / umax;
        if (Dklu_diagnostics.SCALAR_IS_NAN(Common.rcond) || Dklu_diagnostics.SCALAR_IS_ZERO(Common.rcond)) {
            Common.rcond = 0.0;
            Common.status = 1;
        }
        return 1;
    }
}

