/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessAnyD;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class AccessUtils {
    public static Access1D<BigDecimal> asBig1D(final Access1D<?> access) {
        return new Access1D<BigDecimal>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public BigDecimal get(long index) {
                return TypeUtils.toBigDecimal(access.get(index));
            }
        };
    }

    public static Access2D<BigDecimal> asBig2D(final Access2D<?> access) {
        return new Access2D<BigDecimal>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long column) {
                return access.doubleValue(row, column);
            }

            @Override
            public BigDecimal get(long index) {
                return TypeUtils.toBigDecimal(access.get(index));
            }

            @Override
            public BigDecimal get(long row, long column) {
                return TypeUtils.toBigDecimal(access.get(row, column));
            }
        };
    }

    public static AccessAnyD<BigDecimal> asBigAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<BigDecimal>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public BigDecimal get(long index) {
                return TypeUtils.toBigDecimal(access.get(index));
            }

            @Override
            public BigDecimal get(long[] reference) {
                return TypeUtils.toBigDecimal(access.get(reference));
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static Access1D<ComplexNumber> asComplex1D(final Access1D<?> access) {
        return new Access1D<ComplexNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public ComplexNumber get(long index) {
                return ComplexNumber.valueOf(access.get(index));
            }
        };
    }

    public static Access2D<ComplexNumber> asComplex2D(final Access2D<?> access) {
        return new Access2D<ComplexNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long column) {
                return access.doubleValue(row, column);
            }

            @Override
            public ComplexNumber get(long index) {
                return ComplexNumber.valueOf(access.get(index));
            }

            @Override
            public ComplexNumber get(long row, long column) {
                return ComplexNumber.valueOf(access.get(row, column));
            }
        };
    }

    public static AccessAnyD<ComplexNumber> asComplexAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<ComplexNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public ComplexNumber get(long index) {
                return ComplexNumber.valueOf(access.get(index));
            }

            @Override
            public ComplexNumber get(long[] reference) {
                return ComplexNumber.valueOf(access.get(reference));
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static Access1D<Double> asPrimitive1D(final Access1D<?> access) {
        return new Access1D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }
        };
    }

    public static Access2D<Double> asPrimitive2D(final Access2D<?> access) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long column) {
                return access.doubleValue(row, column);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long row, long column) {
                return access.doubleValue(row, column);
            }
        };
    }

    public static AccessAnyD<Double> asPrimitiveAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static Access1D<Quaternion> asQuaternion1D(final Access1D<?> access) {
        return new Access1D<Quaternion>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Quaternion get(long index) {
                return Quaternion.valueOf(access.get(index));
            }
        };
    }

    public static Access2D<Quaternion> asQuaternion2D(final Access2D<?> access) {
        return new Access2D<Quaternion>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long column) {
                return access.doubleValue(row, column);
            }

            @Override
            public Quaternion get(long index) {
                return Quaternion.valueOf(access.get(index));
            }

            @Override
            public Quaternion get(long row, long column) {
                return Quaternion.valueOf(access.get(row, column));
            }
        };
    }

    public static AccessAnyD<Quaternion> asQuaternionAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<Quaternion>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public Quaternion get(long index) {
                return Quaternion.valueOf(access.get(index));
            }

            @Override
            public Quaternion get(long[] reference) {
                return Quaternion.valueOf(access.get(reference));
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static Access1D<RationalNumber> asRational1D(final Access1D<?> access) {
        return new Access1D<RationalNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public RationalNumber get(long index) {
                return RationalNumber.valueOf(access.get(index));
            }
        };
    }

    public static Access2D<RationalNumber> asRational2D(final Access2D<?> access) {
        return new Access2D<RationalNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long column) {
                return access.doubleValue(row, column);
            }

            @Override
            public RationalNumber get(long index) {
                return RationalNumber.valueOf(access.get(index));
            }

            @Override
            public RationalNumber get(long row, long column) {
                return RationalNumber.valueOf(access.get(row, column));
            }
        };
    }

    public static AccessAnyD<RationalNumber> asRationalAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<RationalNumber>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] reference) {
                return access.doubleValue(reference);
            }

            @Override
            public RationalNumber get(long index) {
                return RationalNumber.valueOf(access.get(index));
            }

            @Override
            public RationalNumber get(long[] reference) {
                return RationalNumber.valueOf(access.get(reference));
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static int column(int index, int structure) {
        return index / structure;
    }

    public static int column(int index, int[] structure) {
        return AccessUtils.column(index, structure[0]);
    }

    public static int column(long index, int structure) {
        return (int)(index / (long)structure);
    }

    public static long column(long index, long structure) {
        return index / structure;
    }

    public static long column(long index, long[] structure) {
        return AccessUtils.column(index, structure[0]);
    }

    public static int count(int[] structure) {
        int retVal = 1;
        int tmpLength = structure.length;
        for (int i = 0; i < tmpLength; ++i) {
            retVal *= structure[i];
        }
        return retVal;
    }

    public static int count(int[] structure, int dimension) {
        return structure.length > dimension ? structure[dimension] : 1;
    }

    public static long count(long[] structure) {
        long retVal = 1L;
        int tmpLength = structure.length;
        for (int i = 0; i < tmpLength; ++i) {
            retVal *= structure[i];
        }
        return retVal;
    }

    public static long count(long[] structure, int dimension) {
        return structure.length > dimension ? structure[dimension] : 1L;
    }

    public static boolean equals(Access1D<?> accessA, Access1D<?> accessB, NumberContext context) {
        boolean retVal;
        long tmpLength = accessA.count();
        boolean bl = retVal = tmpLength == accessB.count();
        if (accessA.get(0L) instanceof ComplexNumber && accessB.get(0L) instanceof ComplexNumber) {
            Access1D<?> tmpAccessA = accessA;
            Access1D<?> tmpAccessB = accessB;
            int i = 0;
            while (retVal && (long)i < tmpLength) {
                retVal &= !context.isDifferent(((ComplexNumber)tmpAccessA.get(i)).getReal(), ((ComplexNumber)tmpAccessB.get(i)).getReal());
                retVal &= !context.isDifferent(((ComplexNumber)tmpAccessA.get((long)((long)i))).i, ((ComplexNumber)tmpAccessB.get((long)((long)i))).i);
                ++i;
            }
        } else {
            int i = 0;
            while (retVal && (long)i < tmpLength) {
                retVal &= !context.isDifferent(accessA.doubleValue(i), accessB.doubleValue(i));
                ++i;
            }
        }
        return retVal;
    }

    public static boolean equals(Access2D<?> accessA, Access2D<?> accessB, NumberContext context) {
        return accessA.countRows() == accessB.countRows() && accessA.countColumns() == accessB.countColumns() && AccessUtils.equals(accessA, accessB, context);
    }

    public static boolean equals(AccessAnyD<?> accessA, AccessAnyD<?> accessB, NumberContext context) {
        long tmpCount;
        boolean retVal = true;
        int d = 0;
        while ((retVal &= (tmpCount = accessA.count(d)) == accessB.count(d)) && (++d <= 3 || tmpCount > 1L)) {
        }
        return retVal && AccessUtils.equals(accessA, accessB, context);
    }

    public static int hashCode(Access1D<?> access) {
        int tmpSize = (int)access.count();
        int retVal = tmpSize + 31;
        for (int ij = 0; ij < tmpSize; ++ij) {
            retVal = (int)((double)retVal * access.doubleValue(ij));
        }
        return retVal;
    }

    public static int index(int structure, int row, int column) {
        return row + column * structure;
    }

    public static int index(int[] structure, int[] reference) {
        int retVal = reference[0];
        int tmpFactor = structure[0];
        int tmpLength = reference.length;
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static int index(int[] structure, long[] reference) {
        int retVal = (int)reference[0];
        int tmpFactor = structure[0];
        int tmpLength = reference.length;
        for (int i = 1; i < tmpLength; ++i) {
            retVal = (int)((long)retVal + (long)tmpFactor * reference[i]);
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long index(long structure, long row, long column) {
        return row + column * structure;
    }

    public static long index(long[] structure, long[] reference) {
        long retVal = reference[0];
        long tmpFactor = structure[0];
        int tmpLength = Math.min(structure.length, reference.length);
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static int[] makeDecreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - i;
        }
        return retVal;
    }

    public static long[] makeDecreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - (long)i;
        }
        return retVal;
    }

    public static int[] makeIncreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + i;
        }
        return retVal;
    }

    public static long[] makeIncreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + (long)i;
        }
        return retVal;
    }

    public static long[] reference(long index, long[] structure) {
        long[] retVal = new long[structure.length];
        long tmpPrev = 1L;
        long tmpNext = 1L;
        for (int s = 0; s < structure.length; ++s) {
            retVal[s] = index % (tmpNext *= structure[s]) / tmpPrev;
            tmpPrev = tmpNext;
        }
        return retVal;
    }

    public static int row(int index, int structure) {
        return index % structure;
    }

    public static int row(int index, int[] structure) {
        return AccessUtils.row(index, structure[0]);
    }

    public static int row(long index, int structure) {
        return (int)(index % (long)structure);
    }

    public static long row(long index, long structure) {
        return index % structure;
    }

    public static long row(long index, long[] structure) {
        return AccessUtils.row(index, structure[0]);
    }

    public static long[] shape(StructureAnyD structure) {
        long tmpSize = structure.count();
        long tmpTotal = structure.count(0);
        int tmpRank = 1;
        while (tmpTotal < tmpSize) {
            tmpTotal *= structure.count(tmpRank);
            ++tmpRank;
        }
        long[] retVal = new long[tmpRank];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = structure.count(i);
        }
        return retVal;
    }

    @Deprecated
    public static int size(int[] structure) {
        return AccessUtils.count(structure);
    }

    @Deprecated
    public static int size(int[] structure, int dimension) {
        return AccessUtils.count(structure, dimension);
    }

    public static int step(int[] structure, int dimension) {
        int retVal = 1;
        for (int i = 0; i < dimension; ++i) {
            retVal *= AccessUtils.count(structure, i);
        }
        return retVal;
    }

    public static int step(int[] structure, int[] increment) {
        int retVal = 0;
        int tmpFactor = 1;
        int tmpLimit = increment.length;
        for (int i = 1; i < tmpLimit; ++i) {
            retVal += tmpFactor * increment[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long step(long[] structure, int dimension) {
        long retVal = 1L;
        for (int i = 0; i < dimension; ++i) {
            retVal *= AccessUtils.count(structure, i);
        }
        return retVal;
    }

    public static long step(long[] structure, long[] increment) {
        long retVal = 0L;
        long tmpFactor = 1L;
        int tmpLimit = increment.length;
        for (int i = 1; i < tmpLimit; ++i) {
            retVal += tmpFactor * increment[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    @Deprecated
    public static long[] structure(StructureAnyD structure) {
        return AccessUtils.shape(structure);
    }

    private AccessUtils() {
    }
}

