/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class Array2D<N extends Number>
implements Access2D<N>,
Access2D.Elements,
Access2D.IndexOf,
Access2D.Fillable<N>,
Access2D.Iterable2D<N>,
Access2D.Modifiable<N>,
Access2D.Visitable<N>,
Access2D.Sliceable<N>,
Access2D.Special<N>,
Serializable {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        BasicArray.BasicFactory<BigDecimal> delegate() {
            return BasicArray.BIG;
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        BasicArray.BasicFactory<ComplexNumber> delegate() {
            return BasicArray.COMPLEX;
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        BasicArray.BasicFactory<Double> delegate() {
            return BasicArray.PRIMITIVE;
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        BasicArray.BasicFactory<Quaternion> delegate() {
            return BasicArray.QUATERNION;
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        BasicArray.BasicFactory<RationalNumber> delegate() {
            return BasicArray.RATIONAL;
        }
    };
    private final long myColumnsCount;
    private final BasicArray<N> myDelegate;
    private final long myRowsCount;

    private Array2D() {
        this(null, 0L);
    }

    Array2D(BasicArray<N> delegate, long structure) {
        this.myDelegate = delegate;
        this.myRowsCount = structure;
        this.myColumnsCount = structure == 0L ? 0L : delegate.count() / structure;
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long row, long column, double addend) {
        this.myDelegate.add(AccessUtils.index(this.myRowsCount, row, column), addend);
    }

    @Override
    public void add(long row, long column, Number addend) {
        this.myDelegate.add(AccessUtils.index(this.myRowsCount, row, column), addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.myDelegate.add(index, addend);
    }

    @Deprecated
    public Array1D<N> asArray1D() {
        return this.myDelegate.asArray1D();
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(index);
    }

    @Override
    public double doubleValue(long row, long column) {
        return this.myDelegate.doubleValue(AccessUtils.index(this.myRowsCount, row, column));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Array2D) {
            Array2D tmpObj = (Array2D)obj;
            return this.myRowsCount == tmpObj.countRows() && this.myColumnsCount == tmpObj.countColumns() && this.myDelegate.equals(tmpObj.getDelegate());
        }
        return super.equals(obj);
    }

    @Override
    public void exchangeColumns(long aColA, long aColB) {
        this.myDelegate.exchange(aColA * this.myRowsCount, aColB * this.myRowsCount, 1L, this.myRowsCount);
    }

    @Override
    public void exchangeRows(long aRowA, long aRowB) {
        this.myDelegate.exchange(aRowA, aRowB, this.myRowsCount, this.myColumnsCount);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(0L, this.count(), 1L, supplier);
    }

    @Override
    public void fillColumn(long row, long column, N value) {
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L, value);
    }

    @Override
    public void fillColumn(long row, long column, NullaryFunction<N> supplier) {
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L, supplier);
    }

    @Override
    public void fillDiagonal(long row, long column, N value) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount, value);
    }

    @Override
    public void fillDiagonal(long row, long column, NullaryFunction<N> supplier) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount, supplier);
    }

    @Override
    public void fillOne(long row, long column, N value) {
        this.myDelegate.fillOne(AccessUtils.index(this.myRowsCount, row, column), value);
    }

    @Override
    public void fillOne(long row, long column, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(AccessUtils.index(this.myRowsCount, row, column), supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(index, supplier);
    }

    @Override
    public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOneMatching(index, values, valueIndex);
    }

    @Override
    public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOneMatching(AccessUtils.index(this.myRowsCount, row, column), values, valueIndex);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.myDelegate.fill(first, limit, 1L, supplier);
    }

    @Override
    public void fillRow(long row, long column, N value) {
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, value);
    }

    @Override
    public void fillRow(long row, long column, NullaryFunction<N> supplier) {
        this.myDelegate.fill(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, supplier);
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(index);
    }

    @Override
    public N get(long row, long column) {
        return this.myDelegate.get(AccessUtils.index(this.myRowsCount, row, column));
    }

    public int hashCode() {
        return (int)(this.myRowsCount * this.myColumnsCount * (long)this.myDelegate.hashCode());
    }

    @Override
    public long indexOfLargestInColumn(long row, long column) {
        return this.myDelegate.indexOfLargest(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L) % this.myRowsCount;
    }

    @Override
    public long indexOfLargestInDiagonal(long row, long column) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        return this.myDelegate.indexOfLargest(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount);
    }

    @Override
    public long indexOfLargestInRow(long row, long column) {
        return this.myDelegate.indexOfLargest(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount) / this.myRowsCount;
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(index);
    }

    @Override
    public boolean isAbsolute(long row, long column) {
        return this.myDelegate.isAbsolute(AccessUtils.index(this.myRowsCount, row, column));
    }

    @Deprecated
    public boolean isAllZeros() {
        return this.myDelegate.isSmall(0L, this.count(), 1L, PrimitiveMath.ONE);
    }

    @Deprecated
    public boolean isColumnZeros(long row, long column) {
        return this.myDelegate.isSmall(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L, PrimitiveMath.ONE);
    }

    @Deprecated
    public boolean isDiagonalZeros(long row, long column) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        return this.myDelegate.isSmall(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount, PrimitiveMath.ONE);
    }

    @Deprecated
    public boolean isRowZeros(long row, long column) {
        return this.myDelegate.isSmall(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, PrimitiveMath.ONE);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(index, comparedTo);
    }

    @Override
    public boolean isSmall(long row, long column, double comparedTo) {
        return this.myDelegate.isSmall(AccessUtils.index(this.myRowsCount, row, column), comparedTo);
    }

    @Override
    public void modifyAll(UnaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, function);
    }

    @Override
    public void modifyColumn(long row, long column, UnaryFunction<N> function) {
        this.myDelegate.modify(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L, function);
    }

    @Override
    public void modifyDiagonal(long row, long column, UnaryFunction<N> function) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        this.myDelegate.modify(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount, function);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.myDelegate.modify(0L, this.count(), 1L, function, right);
    }

    @Override
    public void modifyOne(long row, long column, UnaryFunction<N> function) {
        this.myDelegate.modifyOne(AccessUtils.index(this.myRowsCount, row, column), function);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> function) {
        this.myDelegate.modifyOne(index, function);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> function) {
        this.myDelegate.modify(first, limit, 1L, function);
    }

    @Override
    public void modifyRow(long row, long column, UnaryFunction<N> function) {
        this.myDelegate.modify(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, function);
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long row, long column, double value) {
        this.myDelegate.set(AccessUtils.index(this.myRowsCount, row, column), value);
    }

    @Override
    public void set(long row, long column, Number value) {
        this.myDelegate.set(AccessUtils.index(this.myRowsCount, row, column), value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public Array1D<N> sliceColumn(long row, long column) {
        return new Array1D<N>(this.myDelegate, AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L);
    }

    @Override
    public Array1D<N> sliceDiagonal(long row, long column) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        return new Array1D<N>(this.myDelegate, AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myDelegate.asArray1D().sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceRow(long row, long column) {
        return new Array1D<N>(this.myDelegate, AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount);
    }

    @Deprecated
    public double[][] toRawCopy() {
        return this.toRawCopy2D();
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitColumn(long row, long column, VoidFunction<N> visitor) {
        this.myDelegate.visit(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, this.myRowsCount, column), 1L, visitor);
    }

    @Override
    public void visitDiagonal(long row, long column, VoidFunction<N> visitor) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - column);
        this.myDelegate.visit(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row + tmpCount, column + tmpCount), 1L + this.myRowsCount, visitor);
    }

    @Override
    public void visitOne(long row, long column, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(AccessUtils.index(this.myRowsCount, row, column), visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(index, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(first, limit, 1L, visitor);
    }

    @Override
    public void visitRow(long row, long column, VoidFunction<N> visitor) {
        this.myDelegate.visit(AccessUtils.index(this.myRowsCount, row, column), AccessUtils.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, visitor);
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    @Override
    public long indexOfLargest() {
        return this.myDelegate.indexOfLargest();
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.myDelegate.indexOfLargestInRange(first, limit);
    }

    public static abstract class Factory<N extends Number>
    implements Access2D.Factory<Array2D<N>> {
        @Override
        public final Array2D<N> columns(Access1D<?> ... source) {
            int tmpColumns = source.length;
            long tmpRows = source[0].count();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (long i = 0L; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, (Number)tmpColumn.get(i));
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> columns(double[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        @SafeVarargs
        public final Array2D<N> columns(List<? extends Number> ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].size();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn.get(i));
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> columns(Number[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> copy(Access2D<?> source) {
            long tmpColumns = source.countColumns();
            long tmpRows = source.countRows();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (long j = 0L; j < tmpColumns; ++j) {
                for (long i = 0L; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, (Number)source.get(i, j));
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> makeEye(long rows, long columns) {
            BasicArray<N> tmpDelegate = this.delegate().makeStructuredZero(rows, columns);
            long tmpLimit = Math.min(rows, columns);
            long tmpIncr = rows + 1L;
            for (long ij = 0L; ij < tmpLimit; ++ij) {
                tmpDelegate.set(ij * tmpIncr, 1.0);
            }
            return tmpDelegate.asArray2D(rows);
        }

        @Override
        public final Array2D<N> makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(rows, columns);
            long tmpIndex = 0L;
            for (long j = 0L; j < columns; ++j) {
                for (long i = 0L; i < rows; ++i) {
                    tmpDelegate.set(tmpIndex++, (Number)supplier.get());
                }
            }
            return tmpDelegate.asArray2D(rows);
        }

        @Override
        public final Array2D<N> makeZero(long rows, long columns) {
            return this.delegate().makeStructuredZero(rows, columns).asArray2D(rows);
        }

        @Override
        public final Array2D<N> rows(Access1D<?> ... source) {
            int tmpRows = source.length;
            long tmpColumns = source[0].count();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                Access1D<?> tmpRow = source[i];
                for (long j = 0L; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)i + j * (long)tmpRows, (Number)tmpRow.get(j));
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(double[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow[j]);
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(List<? extends Number> ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].size();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow.get(j));
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(Number[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow[j]);
                }
            }
            return tmpDelegate.asArray2D(tmpRows);
        }

        abstract BasicArray.BasicFactory<N> delegate();
    }
}

