/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.EquilibriumModel;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public final class BlackLittermanModel
extends EquilibriumModel {
    private BigDecimal myConfidence = BigMath.ONE;
    private final BasicMatrix myOriginalWeights;
    private final List<FinancePortfolio> myViews;

    public BlackLittermanModel(FinancePortfolio.Context context, FinancePortfolio originalWeights) {
        super(context);
        this.myOriginalWeights = (BasicMatrix)MATRIX_FACTORY.columns(originalWeights.getWeights());
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    public BlackLittermanModel(MarketEquilibrium marketEquilibrium, BasicMatrix originalWeights) {
        super(marketEquilibrium);
        this.myOriginalWeights = originalWeights;
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    private BlackLittermanModel(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myOriginalWeights = null;
        this.myViews = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public final void addView(FinancePortfolio aView) {
        this.myViews.add(aView);
    }

    public final void addViewWithBalancedConfidence(List<BigDecimal> someWeights, Number aReturn) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public final void addViewWithScaledConfidence(List<BigDecimal> someWeights, Number aReturn, Number aScale) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(TypeUtils.toBigDecimal(aScale));
        this.myViews.add(tmpView);
    }

    @Deprecated
    public final void addViewWithStandardDeviation(List<BigDecimal> someWeights, BigDecimal aReturn, BigDecimal aStdDev) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(aReturn);
        tmpView.setReturnVariance(aStdDev.multiply(aStdDev));
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public final Scalar<?> getConfidence() {
        return BigScalar.of(this.myConfidence);
    }

    public final void setConfidence(Number aWeight) {
        this.myConfidence = TypeUtils.toBigDecimal(aWeight);
    }

    @Override
    protected BasicMatrix calculateAssetReturns() {
        return this.calculateAssetReturns(this.calculateAssetWeights());
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        BasicMatrix tmpViewPortfolios = this.getViewPortfolios();
        BasicMatrix tmpViewReturns = this.getViewReturns();
        BasicMatrix tmpViewVariances = this.getViewVariances();
        BasicMatrix tmpCovariances = this.getCovariances();
        BasicMatrix tmpRightParenthesis = tmpViewReturns.subtract(tmpViewPortfolios.multiply(tmpCovariances).multiply(this.myOriginalWeights));
        BasicMatrix tmpViewsTransposed = tmpViewPortfolios.transpose();
        BasicMatrix tmpLeftParenthesis = tmpViewVariances.add(tmpViewPortfolios.multiply(tmpCovariances).multiply(tmpViewsTransposed));
        return this.myOriginalWeights.add(tmpViewsTransposed.multiply(tmpLeftParenthesis.solve(tmpRightParenthesis)));
    }

    protected final BasicMatrix getOriginalReturns() {
        return this.calculateAssetReturns(this.myOriginalWeights);
    }

    protected final BasicMatrix getOriginalWeights() {
        return this.myOriginalWeights;
    }

    protected final BasicMatrix getViewPortfolios() {
        int tmpRowDim = this.myViews.size();
        int tmpColDim = (int)this.myOriginalWeights.count();
        Access2D.Builder retVal = MATRIX_FACTORY.getBuilder(tmpRowDim, tmpColDim);
        for (int i = 0; i < tmpRowDim; ++i) {
            FinancePortfolio tmpView = this.myViews.get(i);
            List<BigDecimal> tmpWeights = tmpView.getWeights();
            for (int j = 0; j < tmpColDim; ++j) {
                retVal.set((long)i, (long)j, tmpWeights.get(j));
            }
        }
        return (BasicMatrix)retVal.build();
    }

    protected final BasicMatrix getViewReturns() {
        int tmpRowDim = this.myViews.size();
        boolean tmpColDim = true;
        Access2D.Builder retVal = MATRIX_FACTORY.getBuilder(tmpRowDim, 1);
        double tmpRAF = this.getRiskAversion().doubleValue();
        for (int i = 0; i < tmpRowDim; ++i) {
            double tmpRet = this.myViews.get(i).getMeanReturn();
            retVal.set((long)i, 0L, PrimitiveFunction.DIVIDE.invoke(tmpRet, tmpRAF));
        }
        return (BasicMatrix)retVal.build();
    }

    protected final List<FinancePortfolio> getViews() {
        return this.myViews;
    }

    protected final BasicMatrix getViewVariances() {
        int tmpDim = this.myViews.size();
        Access2D.Builder retVal = MATRIX_FACTORY.getBuilder(tmpDim, tmpDim);
        if (this.myConfidence.compareTo(BigMath.ONE) == 0) {
            for (int ij = 0; ij < tmpDim; ++ij) {
                retVal.set((long)ij, (long)ij, this.myViews.get(ij).getReturnVariance());
            }
        } else {
            double tmpScale = this.myConfidence.doubleValue();
            for (int ij = 0; ij < tmpDim; ++ij) {
                double tmpVar = this.myViews.get(ij).getReturnVariance();
                retVal.set((long)ij, (long)ij, PrimitiveFunction.DIVIDE.invoke(tmpVar, tmpScale));
            }
        }
        return (BasicMatrix)retVal.build();
    }

    BigDecimal calculateVariance(BasicMatrix aWeightsMtrx) {
        BasicMatrix tmpVal = this.getCovariances();
        tmpVal = tmpVal.multiply(aWeightsMtrx);
        return tmpVal.multiplyLeft(aWeightsMtrx.transpose()).toBigDecimal(0, 0);
    }

    private static final class View
    extends FinancePortfolio {
        private BigDecimal myMeanReturn = BigMath.ZERO;
        private final BlackLittermanModel myModel;
        private BigDecimal myReturnVariance = null;
        private BigDecimal myScale = null;
        private final List<BigDecimal> myWeights;

        public View(BlackLittermanModel aModel, List<BigDecimal> someWeights) {
            this.myModel = aModel;
            this.myWeights = someWeights;
        }

        private View() {
            this.myModel = null;
            this.myWeights = null;
            ProgrammingError.throwForIllegalInvocation();
        }

        @Override
        public double getMeanReturn() {
            if (this.myMeanReturn != null) {
                return this.myMeanReturn.doubleValue();
            }
            return PrimitiveMath.ZERO;
        }

        @Override
        public double getReturnVariance() {
            if (this.myReturnVariance != null) {
                return this.myReturnVariance.doubleValue();
            }
            BasicMatrix tmpWeights = (BasicMatrix)MATRIX_FACTORY.columns(this.myWeights);
            BigDecimal retVal = this.myModel.calculateVariance(tmpWeights);
            retVal = this.myScale != null ? retVal.multiply(this.myScale) : retVal.multiply(this.myModel.getConfidence().toBigDecimal());
            return retVal.doubleValue();
        }

        @Override
        public List<BigDecimal> getWeights() {
            return this.myWeights;
        }

        @Override
        protected void reset() {
        }

        protected final void setMeanReturn(BigDecimal aMeanReturn) {
            this.myMeanReturn = aMeanReturn;
        }

        protected final void setReturnVariance(BigDecimal aReturnVariance) {
            this.myReturnVariance = aReturnVariance;
        }

        protected final void setScale(BigDecimal aScale) {
            this.myScale = aScale;
        }
    }
}

