/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.BigMath;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.function.BigFunction;

final class NormalisedPortfolio
extends FinancePortfolio {
    private final FinancePortfolio myPortfolio;
    private transient BigDecimal myTotalWeight;

    public NormalisedPortfolio(FinancePortfolio aPortfolio) {
        this.myPortfolio = aPortfolio;
    }

    private NormalisedPortfolio() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    @Override
    public double getMeanReturn() {
        return this.myPortfolio.getMeanReturn() / this.getTotalWeight().doubleValue();
    }

    @Override
    public double getVolatility() {
        return this.myPortfolio.getVolatility() / this.getTotalWeight().doubleValue();
    }

    @Override
    public List<BigDecimal> getWeights() {
        ArrayList<BigDecimal> retVal = new ArrayList<BigDecimal>();
        BigDecimal tmpTotalWeight = this.getTotalWeight();
        BigDecimal tmpSum = BigMath.ZERO;
        BigDecimal tmpLargest = BigMath.ZERO;
        int tmpIndex = -1;
        List<BigDecimal> tmpWeights = this.myPortfolio.getWeights();
        for (int i = 0; i < tmpWeights.size(); ++i) {
            BigDecimal tmpWeight = tmpWeights.get(i);
            tmpWeight = BigFunction.DIVIDE.invoke(tmpWeight, tmpTotalWeight);
            tmpWeight = WEIGHT_CONTEXT.enforce(tmpWeight);
            retVal.add(tmpWeight);
            tmpSum = tmpSum.add(tmpWeight);
            if (tmpWeight.abs().compareTo(tmpLargest) != 1) continue;
            tmpLargest = tmpWeight.abs();
            tmpIndex = i;
        }
        if (tmpSum.compareTo(BigMath.ONE) != 0 && tmpIndex != -1) {
            retVal.set(tmpIndex, ((BigDecimal)retVal.get(tmpIndex)).subtract(tmpSum.subtract(BigMath.ONE)));
        }
        return retVal;
    }

    private final BigDecimal getTotalWeight() {
        if (this.myTotalWeight == null) {
            this.myTotalWeight = BigMath.ZERO;
            for (BigDecimal tmpWeight : this.myPortfolio.getWeights()) {
                this.myTotalWeight = this.myTotalWeight.add(tmpWeight);
            }
            if (this.myTotalWeight.signum() == 0) {
                this.myTotalWeight = BigMath.ONE;
            }
        }
        return this.myTotalWeight;
    }

    @Override
    protected void reset() {
        this.myPortfolio.reset();
        this.myTotalWeight = null;
    }
}

