/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public abstract class ComplexAggregator {
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> CARDINALITY = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private int myCount = 0;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return ComplexNumber.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    if (!TypeUtils.isZero(anArg.norm())) {
                        ++this.myCount;
                    }
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myCount += result.intValue();
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myCount = 0;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> LARGEST = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MAX.invoke(this.myNumber, ComplexFunction.ABS.invoke(anArg));
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> MAX = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> MIN = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.INFINITY;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    if (ComplexNumber.isInfinite(this.myNumber)) {
                        return ComplexNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.INFINITY;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> NORM1 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.norm());
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> NORM2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return ComplexNumber.valueOf(Math.sqrt(this.myNumber.norm()));
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    double tmpMod = anArg.norm();
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.HYPOT.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> PRODUCT = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ONE;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ONE;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> PRODUCT2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ONE;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myNumber = this.myNumber.multiply(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ONE;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SMALLEST = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.INFINITY;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    if (ComplexNumber.isInfinite(this.myNumber)) {
                        return ComplexNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    if (!ComplexNumber.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = ComplexFunction.MIN.invoke(this.myNumber, ComplexFunction.ABS.invoke(anArg));
                    }
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.INFINITY;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SUM = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SUM2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new AggregatorFunction<ComplexNumber>(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public ComplexNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(ComplexNumber.valueOf(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myNumber = this.myNumber.add(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<ComplexNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    private static final AggregatorSet<ComplexNumber> SET = new AggregatorSet<ComplexNumber>(){

        @Override
        public AggregatorFunction<ComplexNumber> cardinality() {
            return CARDINALITY.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> largest() {
            return LARGEST.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> maximum() {
            return MAX.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> minimum() {
            return MIN.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> norm1() {
            return NORM1.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> norm2() {
            return NORM2.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> product() {
            return PRODUCT.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> product2() {
            return PRODUCT2.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> smallest() {
            return SMALLEST.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> sum() {
            return SUM.get().reset();
        }

        @Override
        public AggregatorFunction<ComplexNumber> sum2() {
            return SUM2.get().reset();
        }
    };

    @Deprecated
    public static AggregatorSet<ComplexNumber> getCollection() {
        return ComplexAggregator.getSet();
    }

    public static AggregatorSet<ComplexNumber> getSet() {
        return SET;
    }

    private ComplexAggregator() {
        ProgrammingError.throwForIllegalInvocation();
    }
}

