/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import java.util.function.Function;
import org.ojalgo.access.Access1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.multiary.FirstOrderApproximation;
import org.ojalgo.function.multiary.SecondOrderApproximation;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

public interface MultiaryFunction<N extends Number>
extends BasicFunction<N>,
Function<Access1D<N>, N> {
    @Override
    default public N apply(Access1D<N> arg) {
        return this.invoke(arg);
    }

    public int arity();

    public N invoke(Access1D<N> var1);

    public static interface TwiceDifferentiable<N extends Number>
    extends MultiaryFunction<N> {
        public MatrixStore<N> getGradient(Access1D<N> var1);

        public MatrixStore<N> getHessian(Access1D<N> var1);

        public FirstOrderApproximation<N> toFirstOrderApproximation(Access1D<N> var1);

        public SecondOrderApproximation<N> toSecondOrderApproximation(Access1D<N> var1);
    }

    public static interface Quadratic<N extends Number>
    extends MultiaryFunction<N> {
        public PhysicalStore<N> quadratic();
    }

    public static interface Linear<N extends Number>
    extends MultiaryFunction<N> {
        public PhysicalStore<N> linear();
    }

    public static interface Convex<N extends Number>
    extends MultiaryFunction<N> {
    }

    public static interface Constant<N extends Number, F extends Constant<N, ?>>
    extends MultiaryFunction<N> {
        public F constant(Number var1);

        public N getConstant();

        public void setConstant(Number var1);
    }
}

