/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public final class ComplexMatrix
extends AbstractMatrix<ComplexNumber, ComplexMatrix> {
    public static final BasicMatrix.Factory<ComplexMatrix> FACTORY = new MatrixFactory<ComplexNumber, ComplexMatrix>(ComplexMatrix.class, ComplexDenseStore.FACTORY);

    public static Access2D.Builder<ComplexMatrix> getBuilder(int aLength) {
        return FACTORY.getBuilder(aLength);
    }

    public static Access2D.Builder<ComplexMatrix> getBuilder(int aRowDim, int aColDim) {
        return FACTORY.getBuilder(aRowDim, aColDim);
    }

    ComplexMatrix(MatrixStore<ComplexNumber> aStore) {
        super(aStore);
    }

    @Override
    public ComplexMatrix enforce(NumberContext context) {
        return (ComplexMatrix)this.modify(context.getComplexFunction());
    }

    public PrimitiveMatrix getArgument() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexArgument(this.getStore()));
    }

    public PrimitiveMatrix getImaginary() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexImaginary(this.getStore()));
    }

    public PrimitiveMatrix getModulus() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexModulus(this.getStore()));
    }

    public PrimitiveMatrix getReal() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexReal(this.getStore()));
    }

    @Override
    public BigDecimal toBigDecimal(int row, int column) {
        return new BigDecimal(this.getStore().doubleValue(row, column));
    }

    @Override
    public ComplexNumber toComplexNumber(int row, int column) {
        return (ComplexNumber)this.getStore().get(row, column);
    }

    @Override
    public PhysicalStore<ComplexNumber> toComplexStore() {
        return this.getStore().copy();
    }

    @Override
    public String toString(int row, int col) {
        return this.toComplexNumber(row, col).toString();
    }

    @Override
    MatrixFactory<ComplexNumber, ComplexMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    MatrixStore<ComplexNumber> getStoreFrom(Access1D<?> aMtrx) {
        if (aMtrx instanceof ComplexMatrix) {
            return ((ComplexMatrix)aMtrx).getStore();
        }
        if (aMtrx instanceof ComplexDenseStore) {
            return (ComplexDenseStore)aMtrx;
        }
        if (aMtrx instanceof MatrixStore && !this.isEmpty() && aMtrx.get(0L) instanceof ComplexNumber) {
            return (MatrixStore)aMtrx;
        }
        if (aMtrx instanceof Access2D) {
            return (MatrixStore)this.getPhysicalFactory().copy((Access2D)aMtrx);
        }
        return (MatrixStore)this.getPhysicalFactory().columns(aMtrx);
    }
}

