/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Bidiagonal;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

abstract class BidiagonalDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Bidiagonal<N> {
    private transient DiagonalAccess<N> myDiagonalAccessD;
    private boolean myFullSize = false;
    private Array1D<N> myInitDiagQ1 = null;
    private Array1D<N> myInitDiagQ2 = null;
    private transient DecompositionStore<N> myQ1;
    private transient DecompositionStore<N> myQ2;

    protected BidiagonalDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public boolean decompose(ElementsSupplier<N> matrix) {
        this.reset();
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpLimit = Math.min(tmpRowDim, tmpColDim);
        Householder tmpHouseholderRow = this.makeHouseholder(tmpColDim);
        Householder tmpHouseholderCol = this.makeHouseholder(tmpRowDim);
        if (this.isAspectRatioNormal()) {
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (ij + 1 < tmpRowDim && tmpStore.generateApplyAndCopyHouseholderColumn(ij, ij, tmpHouseholderCol)) {
                    tmpStore.transformLeft(tmpHouseholderCol, ij + 1);
                }
                if (ij + 2 >= tmpColDim || !tmpStore.generateApplyAndCopyHouseholderRow(ij, ij + 1, tmpHouseholderRow)) continue;
                tmpStore.transformRight(tmpHouseholderRow, ij + 1);
            }
            Array1D<N>[] tmpInitDiags = this.makeReal();
            if (tmpInitDiags != null) {
                this.myInitDiagQ1 = tmpInitDiags[0];
                this.myInitDiagQ2 = tmpInitDiags[1];
            }
        } else {
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (ij + 1 < tmpColDim && tmpStore.generateApplyAndCopyHouseholderRow(ij, ij, tmpHouseholderRow)) {
                    tmpStore.transformRight(tmpHouseholderRow, ij + 1);
                }
                if (ij + 2 >= tmpRowDim || !tmpStore.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholderCol)) continue;
                tmpStore.transformLeft(tmpHouseholderCol, ij + 1);
            }
            Array1D<N>[] tmpInitDiags = this.makeReal();
            if (tmpInitDiags != null) {
                this.myInitDiagQ1 = tmpInitDiags[0];
                this.myInitDiagQ2 = tmpInitDiags[1];
            }
        }
        return this.computed(true);
    }

    @Override
    public boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public MatrixStore<N> getD() {
        return this.getInPlace().builder().bidiagonal(this.isAspectRatioNormal(), false).build();
    }

    @Override
    public MatrixStore<N> getQ1() {
        if (this.myQ1 == null) {
            this.myQ1 = this.makeQ1();
        }
        return this.myQ1;
    }

    @Override
    public MatrixStore<N> getQ2() {
        if (this.myQ2 == null) {
            this.myQ2 = this.makeQ2();
        }
        return this.myQ2;
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isUpper() {
        return this.isAspectRatioNormal();
    }

    @Override
    public void reset() {
        super.reset();
        this.myQ1 = null;
        this.myQ2 = null;
        this.myDiagonalAccessD = null;
        this.myInitDiagQ1 = null;
        this.myInitDiagQ2 = null;
    }

    @Override
    public void setFullSize(boolean fullSize) {
        this.myFullSize = fullSize;
    }

    private DiagonalAccess<N> makeDiagonalAccessD() {
        Access1D tmpSub;
        Access1D tmpSuper;
        Array2D tmpArray2D = this.getInPlace().asArray2D();
        Access1D tmpMain = tmpArray2D.sliceDiagonal(0L, 0L);
        if (this.isAspectRatioNormal()) {
            tmpSuper = tmpArray2D.sliceDiagonal(0L, 1L);
            tmpSub = null;
        } else {
            tmpSub = tmpArray2D.sliceDiagonal(1L, 0L);
            tmpSuper = null;
        }
        return new DiagonalAccess(tmpMain, tmpSuper, tmpSub, this.scalar().zero().getNumber());
    }

    private void solve(PhysicalStore<N> aMtrxV, MatrixStore<N> aMtrxD, DiagonalAccess<N> aMtrxSimilar) {
        int tmpDim = (int)aMtrxV.countRows();
        int tmpLim = tmpDim - 1;
        for (int j = 0; j < tmpDim; ++j) {
            int i;
            double tmpSingular = aMtrxD.doubleValue(j, j);
            if (TypeUtils.isZero(tmpSingular)) {
                for (i = 0; i < tmpDim; ++i) {
                    aMtrxV.set((long)i, (long)j, PrimitiveMath.ZERO);
                }
                continue;
            }
            for (i = 0; i < tmpLim; ++i) {
                aMtrxV.set((long)i, (long)j, (aMtrxSimilar.doubleValue(i, i) * aMtrxV.doubleValue(i, j) + aMtrxSimilar.doubleValue(i, i + 1) * aMtrxV.doubleValue(i + 1, j)) / tmpSingular);
            }
            aMtrxV.set((long)tmpLim, (long)j, aMtrxSimilar.doubleValue(tmpLim, tmpLim) * aMtrxV.doubleValue(tmpLim, j) / tmpSingular);
        }
    }

    private DecompositionStore<N> solve2(PhysicalStore<N> aMtrxV, MatrixStore<N> aMtrxD, DiagonalAccess<N> aMtrxSimilar) {
        int tmpDim = (int)aMtrxV.countRows();
        int tmpLim = tmpDim - 1;
        DecompositionStore retVal = this.makeZero(tmpDim, tmpDim);
        for (int j = 0; j < tmpDim; ++j) {
            int i;
            double tmpSingular = aMtrxD.doubleValue(j, j);
            if (TypeUtils.isZero(tmpSingular)) {
                for (i = 0; i < tmpDim; ++i) {
                    retVal.set((long)i, (long)j, aMtrxV.doubleValue(i, j));
                }
                continue;
            }
            for (i = 0; i < tmpLim; ++i) {
                retVal.set((long)i, (long)j, (aMtrxSimilar.doubleValue(i, i) * aMtrxV.doubleValue(i, j) + aMtrxSimilar.doubleValue(i, i + 1) * aMtrxV.doubleValue(i + 1, j)) / tmpSingular);
            }
            retVal.set((long)tmpLim, (long)j, aMtrxSimilar.doubleValue(tmpLim, tmpLim) * aMtrxV.doubleValue(tmpLim, j) / tmpSingular);
        }
        return retVal;
    }

    protected DecompositionStore<N> makeQ1() {
        int ij;
        DecompositionStore.HouseholderReference tmpHouseholderReference = new DecompositionStore.HouseholderReference(this.getInPlace(), true);
        int tmpRowDim = this.getRowDim();
        int tmpMinDim = this.getMinDim();
        DecompositionStore retVal = null;
        if (this.myInitDiagQ1 != null) {
            retVal = this.makeZero(tmpRowDim, this.myFullSize ? tmpRowDim : tmpMinDim);
            for (int ij2 = 0; ij2 < tmpMinDim; ++ij2) {
                retVal.set((long)ij2, (long)ij2, (Number)this.myInitDiagQ1.get(ij2));
            }
        } else {
            retVal = this.makeEye(tmpRowDim, this.myFullSize ? tmpRowDim : tmpMinDim);
        }
        boolean tmpUpper = this.isUpper();
        int n = ij = tmpUpper && tmpRowDim != tmpMinDim ? tmpMinDim - 1 : tmpMinDim - 2;
        while (ij >= 0) {
            tmpHouseholderReference.row = tmpUpper ? ij : ij + 1;
            tmpHouseholderReference.col = ij;
            if (!tmpHouseholderReference.isZero()) {
                retVal.transformLeft(tmpHouseholderReference, ij);
            }
            --ij;
        }
        return retVal;
    }

    protected DecompositionStore<N> makeQ2() {
        int ij;
        DecompositionStore.HouseholderReference tmpHouseholderReference = new DecompositionStore.HouseholderReference(this.getInPlace(), false);
        int tmpMinDim = this.getMinDim();
        int tmpColDim = this.getColDim();
        DecompositionStore retVal = null;
        if (this.myInitDiagQ2 != null) {
            retVal = this.makeZero(tmpColDim, this.myFullSize ? tmpColDim : tmpMinDim);
            for (int ij2 = 0; ij2 < tmpMinDim; ++ij2) {
                retVal.set((long)ij2, (long)ij2, (Number)this.myInitDiagQ2.get(ij2));
            }
        } else {
            retVal = this.makeEye(tmpColDim, this.myFullSize ? tmpColDim : tmpMinDim);
        }
        boolean tmpUpper = this.isUpper();
        int n = ij = tmpUpper ? tmpMinDim - 2 : tmpMinDim - 1;
        while (ij >= 0) {
            tmpHouseholderReference.row = ij;
            int n2 = tmpHouseholderReference.col = tmpUpper ? ij + 1 : ij;
            if (!tmpHouseholderReference.isZero()) {
                retVal.transformLeft(tmpHouseholderReference, ij);
            }
            --ij;
        }
        return retVal;
    }

    DiagonalAccess<N> getDiagonalAccessD() {
        if (this.myDiagonalAccessD == null) {
            this.myDiagonalAccessD = this.makeDiagonalAccessD();
        }
        return this.myDiagonalAccessD;
    }

    abstract Array1D<N>[] makeReal();

    static final class Primitive
    extends BidiagonalDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }

        @Override
        Array1D<Double>[] makeReal() {
            return null;
        }
    }

    static final class Complex
    extends BidiagonalDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }

        @Override
        Array1D<ComplexNumber>[] makeReal() {
            DiagonalAccess tmpDiagonalAccessD = this.getDiagonalAccessD();
            Access1D tmpInitDiagQ1 = Array1D.COMPLEX.makeZero(tmpDiagonalAccessD.getDimension());
            ((Array1D)tmpInitDiagQ1).fillAll(ComplexNumber.ONE);
            Access1D tmpInitDiagQ2 = Array1D.COMPLEX.makeZero(tmpDiagonalAccessD.getDimension());
            ((Array1D)tmpInitDiagQ2).fillAll(ComplexNumber.ONE);
            boolean tmpUpper = this.isUpper();
            if (tmpUpper) {
                Array1D tmpMainDiagonal = tmpDiagonalAccessD.mainDiagonal;
                Array1D tmpSuperdiagonal = tmpDiagonalAccessD.superdiagonal;
                int tmpLimit = tmpSuperdiagonal.size();
                for (int i = 0; i < tmpLimit; ++i) {
                    ComplexNumber tmpSignum;
                    if (!((ComplexNumber)tmpMainDiagonal.get(i)).isReal()) {
                        tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(i)).signum();
                        tmpMainDiagonal.set(i, (Object)((ComplexNumber)tmpMainDiagonal.get(i)).divide(tmpSignum));
                        tmpSuperdiagonal.set(i, (Object)((ComplexNumber)tmpSuperdiagonal.get(i)).divide(tmpSignum));
                        ((Array1D)tmpInitDiagQ1).set(i, (Object)tmpSignum);
                    }
                    if (((ComplexNumber)tmpSuperdiagonal.get(i)).isReal()) continue;
                    tmpSignum = ((ComplexNumber)tmpSuperdiagonal.get(i)).signum();
                    tmpSuperdiagonal.set(i, (Object)((ComplexNumber)tmpSuperdiagonal.get(i)).divide(tmpSignum));
                    tmpMainDiagonal.set(i + 1, (Object)((ComplexNumber)tmpMainDiagonal.get(i + 1)).divide(tmpSignum));
                    ((Array1D)tmpInitDiagQ2).set(i + 1, (Object)tmpSignum.conjugate());
                }
                if (!((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).isReal()) {
                    ComplexNumber tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).signum();
                    tmpMainDiagonal.set(tmpLimit, (Object)((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).divide(tmpSignum));
                    ((Array1D)tmpInitDiagQ1).set(tmpLimit, (Object)tmpSignum);
                }
            } else {
                Array1D tmpMainDiagonal = tmpDiagonalAccessD.mainDiagonal;
                Array1D tmpSubdiagonal = tmpDiagonalAccessD.subdiagonal;
                int tmpLimit = tmpSubdiagonal.size();
                for (int i = 0; i < tmpLimit; ++i) {
                    ComplexNumber tmpSignum;
                    if (!((ComplexNumber)tmpMainDiagonal.get(i)).isReal()) {
                        tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(i)).signum();
                        tmpMainDiagonal.set(i, (Object)((ComplexNumber)tmpMainDiagonal.get(i)).divide(tmpSignum));
                        tmpSubdiagonal.set(i, (Object)((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpSignum));
                        ((Array1D)tmpInitDiagQ2).set(i, (Object)tmpSignum.conjugate());
                    }
                    if (((ComplexNumber)tmpSubdiagonal.get(i)).isReal()) continue;
                    tmpSignum = ((ComplexNumber)tmpSubdiagonal.get(i)).signum();
                    tmpSubdiagonal.set(i, (Object)((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpSignum));
                    tmpMainDiagonal.set(i + 1, (Object)((ComplexNumber)tmpMainDiagonal.get(i + 1)).divide(tmpSignum));
                    ((Array1D)tmpInitDiagQ1).set(i + 1, (Object)tmpSignum);
                }
                if (!((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).isReal()) {
                    ComplexNumber tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).signum();
                    tmpMainDiagonal.set(tmpLimit, (Object)((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).divide(tmpSignum));
                    ((Array1D)tmpInitDiagQ2).set(tmpLimit, (Object)tmpSignum.conjugate());
                }
            }
            return new Array1D[]{tmpInitDiagQ1, tmpInitDiagQ2};
        }
    }

    static final class Big
    extends BidiagonalDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }

        @Override
        Array1D<BigDecimal>[] makeReal() {
            return null;
        }
    }
}

