/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.CholeskyDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawCholesky;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Cholesky<N extends Number>
extends LDU<N>,
MatrixDecomposition.Hermitian<N> {
    public static <N extends Number> Cholesky<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new CholeskyDecomposition.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new CholeskyDecomposition.Complex();
        }
        if (tmpNumber instanceof Double) {
            if (32L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new CholeskyDecomposition.Primitive();
            }
            return new RawCholesky();
        }
        throw new IllegalArgumentException();
    }

    public static Cholesky<BigDecimal> makeBig() {
        return new CholeskyDecomposition.Big();
    }

    public static Cholesky<ComplexNumber> makeComplex() {
        return new CholeskyDecomposition.Complex();
    }

    public static Cholesky<Double> makePrimitive() {
        return new CholeskyDecomposition.Primitive();
    }

    public boolean isSPD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

