/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.LDLDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawLDL;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface LDL<N extends Number>
extends LDU<N>,
MatrixDecomposition.Hermitian<N> {
    public static <N extends Number> LDL<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new LDLDecomposition.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new LDLDecomposition.Complex();
        }
        if (tmpNumber instanceof Double) {
            if (256L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new LDLDecomposition.Primitive();
            }
            return new RawLDL();
        }
        throw new IllegalArgumentException();
    }

    public static LDL<BigDecimal> makeBig() {
        return new LDLDecomposition.Big();
    }

    public static LDL<ComplexNumber> makeComplex() {
        return new LDLDecomposition.Complex();
    }

    public static LDL<Double> makePrimitive() {
        return new LDLDecomposition.Primitive();
    }

    @Override
    default public boolean equals(MatrixStore<N> other, NumberContext context) {
        return MatrixUtils.equals(other, this, context);
    }

    public MatrixStore<N> getD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    public int getRank();

    default public boolean isFullSize() {
        return true;
    }

    public boolean isSquareAndNotSingular();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

